/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class QuirkSettingsLoader
implements Function<Context, QuirkSettings> {
    private static final String TAG = "QuirkSettingsLoader";
    public static final String KEY_DEFAULT_QUIRK_ENABLED = "androidx.camera.core.quirks.DEFAULT_QUIRK_ENABLED";
    public static final String KEY_QUIRK_FORCE_ENABLED = "androidx.camera.core.quirks.FORCE_ENABLED";
    public static final String KEY_QUIRK_FORCE_DISABLED = "androidx.camera.core.quirks.FORCE_DISABLED";

    @Nullable
    public QuirkSettings apply(@NonNull Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            Bundle metadata = packageManager.getServiceInfo((ComponentName)new ComponentName((Context)context, MetadataHolderService.class), (int)640).metaData;
            if (metadata == null) {
                Logger.w(TAG, "No metadata in MetadataHolderService.");
                return null;
            }
            return QuirkSettingsLoader.buildQuirkSettings(context, metadata);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.d(TAG, "QuirkSettings$MetadataHolderService is not found.");
            return null;
        }
    }

    @NonNull
    private static QuirkSettings buildQuirkSettings(@NonNull Context context, @NonNull Bundle metadata) {
        boolean defaultEnabled = metadata.getBoolean(KEY_DEFAULT_QUIRK_ENABLED, true);
        Object[] forceEnabled = QuirkSettingsLoader.loadQuirks(context, metadata, KEY_QUIRK_FORCE_ENABLED);
        Object[] forceDisabled = QuirkSettingsLoader.loadQuirks(context, metadata, KEY_QUIRK_FORCE_DISABLED);
        Logger.d(TAG, "Loaded quirk settings from metadata:");
        Logger.d(TAG, "  KEY_DEFAULT_QUIRK_ENABLED = " + defaultEnabled);
        Logger.d(TAG, "  KEY_QUIRK_FORCE_ENABLED = " + Arrays.toString(forceEnabled));
        Logger.d(TAG, "  KEY_QUIRK_FORCE_DISABLED = " + Arrays.toString(forceDisabled));
        return new QuirkSettings.Builder().setEnabledWhenDeviceHasQuirk(defaultEnabled).forceEnableQuirks(QuirkSettingsLoader.resolveQuirkNames((String[])forceEnabled)).forceDisableQuirks(QuirkSettingsLoader.resolveQuirkNames((String[])forceDisabled)).build();
    }

    @NonNull
    private static String[] loadQuirks(@NonNull Context context, @NonNull Bundle metadata, @NonNull String key) {
        if (!metadata.containsKey(key)) {
            return new String[0];
        }
        int resourceId = metadata.getInt(key, -1);
        if (resourceId == -1) {
            Logger.w(TAG, "Resource ID not found for key: " + key);
            return new String[0];
        }
        try {
            return context.getResources().getStringArray(resourceId);
        }
        catch (Resources.NotFoundException e) {
            Logger.w(TAG, "Quirk class names resource not found: " + resourceId, e);
            return new String[0];
        }
    }

    @NonNull
    private static Set<Class<? extends Quirk>> resolveQuirkNames(@NonNull String[] nameArray) {
        HashSet<Class<? extends Quirk>> quirkSet = new HashSet<Class<? extends Quirk>>();
        for (String quirkName : nameArray) {
            Class<? extends Quirk> clazz = QuirkSettingsLoader.resolveQuirkName(quirkName);
            if (clazz == null) continue;
            quirkSet.add(clazz);
        }
        return quirkSet;
    }

    @Nullable
    private static Class<? extends Quirk> resolveQuirkName(@NonNull String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (Quirk.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            Logger.w(TAG, className + " does not implement the Quirk interface.");
        }
        catch (ClassNotFoundException e) {
            Logger.w(TAG, "Class not found: " + className, e);
        }
        return null;
    }

    public static class MetadataHolderService
    extends Service {
        private MetadataHolderService() {
        }

        @Nullable
        public IBinder onBind(Intent intent) {
            throw new UnsupportedOperationException();
        }
    }
}

