/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.utils.UseCaseConfigUtil;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class UseCase {
    private final Set<StateChangeCallback> mStateChangeCallbacks = new HashSet<StateChangeCallback>();
    private final Object mCameraLock = new Object();
    private State mState = State.INACTIVE;
    @Nullable
    private UseCaseConfig<?> mExtendedConfig;
    @NonNull
    private UseCaseConfig<?> mUseCaseConfig;
    @NonNull
    private UseCaseConfig<?> mCurrentConfig;
    private StreamSpec mAttachedStreamSpec;
    @Nullable
    private UseCaseConfig<?> mCameraConfig;
    @Nullable
    private Rect mViewPortCropRect;
    @NonNull
    private Matrix mSensorToBufferTransformMatrix = new Matrix();
    @GuardedBy(value="mCameraLock")
    private CameraInternal mCamera;
    @GuardedBy(value="mCameraLock")
    @Nullable
    private CameraInternal mSecondaryCamera;
    @Nullable
    private CameraEffect mEffect;
    @Nullable
    private String mPhysicalCameraId;
    @NonNull
    private SessionConfig mAttachedSessionConfig = SessionConfig.defaultEmptySessionConfig();
    @NonNull
    private SessionConfig mAttachedSecondarySessionConfig = SessionConfig.defaultEmptySessionConfig();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCase(@NonNull UseCaseConfig<?> currentConfig) {
        this.mUseCaseConfig = currentConfig;
        this.mCurrentConfig = currentConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public abstract UseCaseConfig<?> getDefaultConfig(boolean var1, @NonNull UseCaseConfigFactory var2);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public abstract UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfig<?> mergeConfigs(@NonNull CameraInfoInternal cameraInfo, @Nullable UseCaseConfig<?> extendedConfig, @Nullable UseCaseConfig<?> cameraDefaultConfig) {
        ResolutionSelector resolutionSelector;
        MutableOptionsBundle mergedConfig;
        if (cameraDefaultConfig != null) {
            mergedConfig = MutableOptionsBundle.from(cameraDefaultConfig);
            mergedConfig.removeOption(TargetConfig.OPTION_TARGET_NAME);
        } else {
            mergedConfig = MutableOptionsBundle.create();
        }
        if ((this.mUseCaseConfig.containsOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO) || this.mUseCaseConfig.containsOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION)) && mergedConfig.containsOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR)) {
            mergedConfig.removeOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR);
        }
        if (this.mUseCaseConfig.containsOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR) && mergedConfig.containsOption(ImageOutputConfig.OPTION_MAX_RESOLUTION) && (resolutionSelector = this.mUseCaseConfig.retrieveOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR)).getResolutionStrategy() != null) {
            mergedConfig.removeOption(ImageOutputConfig.OPTION_MAX_RESOLUTION);
        }
        for (Config.Option<?> opt : this.mUseCaseConfig.listOptions()) {
            Config.mergeOptionValue(mergedConfig, mergedConfig, this.mUseCaseConfig, opt);
        }
        if (extendedConfig != null) {
            for (Config.Option<?> opt : extendedConfig.listOptions()) {
                Config.Option<?> objectOpt = opt;
                if (objectOpt.getId().equals(TargetConfig.OPTION_TARGET_NAME.getId())) continue;
                Config.mergeOptionValue(mergedConfig, mergedConfig, extendedConfig, opt);
            }
        }
        if (mergedConfig.containsOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION) && mergedConfig.containsOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO)) {
            mergedConfig.removeOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO);
        }
        if (mergedConfig.containsOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR) && mergedConfig.retrieveOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR).getAllowedResolutionMode() != 0) {
            mergedConfig.insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, true);
        }
        return this.onMergeConfig(cameraInfo, this.getUseCaseConfigBuilder(mergedConfig));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        return builder.getUseCaseConfig();
    }

    public static int snapToSurfaceRotation(@IntRange(from=0L, to=359L) int orientation) {
        Preconditions.checkArgumentInRange((int)orientation, (int)0, (int)359, (String)"orientation");
        if (orientation >= 315 || orientation < 45) {
            return 0;
        }
        if (orientation >= 225) {
            return 1;
        }
        if (orientation >= 135) {
            return 2;
        }
        return 3;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setPhysicalCameraId(@NonNull String physicalCameraId) {
        this.mPhysicalCameraId = physicalCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getPhysicalCameraId() {
        return this.mPhysicalCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean setTargetRotationInternal(int targetRotation) {
        ImageOutputConfig oldConfig = (ImageOutputConfig)((Object)this.getCurrentConfig());
        int oldRotation = oldConfig.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != targetRotation) {
            UseCaseConfig.Builder<?, ?, ?> builder = this.getUseCaseConfigBuilder(this.mUseCaseConfig);
            UseCaseConfigUtil.updateTargetRotationAndRelatedConfigs(builder, targetRotation);
            this.mUseCaseConfig = builder.getUseCaseConfig();
            CameraInternal camera = this.getCamera();
            this.mCurrentConfig = camera == null ? this.mUseCaseConfig : this.mergeConfigs(camera.getCameraInfoInternal(), this.mExtendedConfig, this.mCameraConfig);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"WrongConstant"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected int getTargetRotationInternal() {
        return ((ImageOutputConfig)((Object)this.mCurrentConfig)).getTargetRotation(0);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Range<Integer> getTargetFrameRateInternal() {
        return this.mCurrentConfig.getTargetFrameRate(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected int getMirrorModeInternal() {
        return ((ImageOutputConfig)((Object)this.mCurrentConfig)).getMirrorMode(-1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isMirroringRequired(@NonNull CameraInternal camera) {
        int mirrorMode = this.getMirrorModeInternal();
        switch (mirrorMode) {
            case -1: 
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return camera.isFrontFacing();
            }
        }
        throw new AssertionError((Object)("Unknown mirrorMode: " + mirrorMode));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected int getAppTargetRotation() {
        return ((ImageOutputConfig)((Object)this.mCurrentConfig)).getAppTargetRotation(-1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=0L, to=359L)
    protected int getRelativeRotation(@NonNull CameraInternal cameraInternal) {
        return this.getRelativeRotation(cameraInternal, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=0L, to=359L)
    protected int getRelativeRotation(@NonNull CameraInternal cameraInternal, boolean requireMirroring) {
        boolean inputStreamMirrored;
        int rotation = cameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.getTargetRotationInternal());
        boolean bl = inputStreamMirrored = !cameraInternal.getHasTransform() && requireMirroring;
        if (inputStreamMirrored) {
            rotation = TransformUtils.within360(-rotation);
        }
        return rotation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void updateSessionConfig(@NonNull List<SessionConfig> sessionConfigs) {
        if (sessionConfigs.isEmpty()) {
            return;
        }
        this.mAttachedSessionConfig = sessionConfigs.get(0);
        if (sessionConfigs.size() > 1) {
            this.mAttachedSecondarySessionConfig = sessionConfigs.get(1);
        }
        for (SessionConfig sessionConfig : sessionConfigs) {
            for (DeferrableSurface surface : sessionConfig.getSurfaces()) {
                if (surface.getContainerClass() != null) continue;
                surface.setContainerClass(this.getClass());
            }
        }
    }

    private void addStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.add(callback);
    }

    private void removeStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.remove(callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig getSessionConfig() {
        return this.mAttachedSessionConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig getSecondarySessionConfig() {
        return this.mAttachedSecondarySessionConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyActive() {
        this.mState = State.ACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyInactive() {
        this.mState = State.INACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyUpdated() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseUpdated(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyReset() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseReset(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void notifyState() {
        switch (this.mState.ordinal()) {
            case 1: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseInactive(this);
                }
                break;
            }
            case 0: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseActive(this);
                }
                break;
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected String getCameraId() {
        return ((CameraInternal)Preconditions.checkNotNull((Object)this.getCamera(), (Object)("No camera attached to use case: " + this))).getCameraInfoInternal().getCameraId();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    protected String getSecondaryCameraId() {
        return this.getSecondaryCamera() == null ? null : this.getSecondaryCamera().getCameraInfoInternal().getCameraId();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean isCurrentCamera(@NonNull String cameraId) {
        if (this.getCamera() == null) {
            return false;
        }
        return Objects.equals(cameraId, this.getCameraId());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getName() {
        return Objects.requireNonNull(this.mCurrentConfig.getTargetName("<UnknownUseCase-" + this.hashCode() + ">"));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> getAppConfig() {
        return this.mUseCaseConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfig<?> getCurrentConfig() {
        return this.mCurrentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraInternal getCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            return this.mCamera;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraInternal getSecondaryCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            return this.mSecondaryCamera;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Size getAttachedSurfaceResolution() {
        return this.mAttachedStreamSpec != null ? this.mAttachedStreamSpec.getResolution() : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public StreamSpec getAttachedStreamSpec() {
        return this.mAttachedStreamSpec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateSuggestedStreamSpec(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        this.mAttachedStreamSpec = this.onSuggestedStreamSpecUpdated(primaryStreamSpec, secondaryStreamSpec);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        return primaryStreamSpec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateSuggestedStreamSpecImplementationOptions(@NonNull Config config) {
        this.mAttachedStreamSpec = this.onSuggestedStreamSpecImplementationOptionsUpdated(config);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        if (this.mAttachedStreamSpec == null) {
            throw new UnsupportedOperationException("Attempt to update the implementation options for a use case without attached stream specifications.");
        }
        return this.mAttachedStreamSpec.toBuilder().setImplementationOptions(config).build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onCameraControlReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"WrongConstant"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void bindToCamera(@NonNull CameraInternal camera, @Nullable CameraInternal secondaryCamera, @Nullable UseCaseConfig<?> extendedConfig, @Nullable UseCaseConfig<?> cameraConfig) {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mCamera = camera;
            this.mSecondaryCamera = secondaryCamera;
            this.addStateChangeCallback(camera);
            if (secondaryCamera != null) {
                this.addStateChangeCallback(secondaryCamera);
            }
        }
        this.mExtendedConfig = extendedConfig;
        this.mCameraConfig = cameraConfig;
        this.mCurrentConfig = this.mergeConfigs(camera.getCameraInfoInternal(), this.mExtendedConfig, this.mCameraConfig);
        this.onBind();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onBind() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void unbindFromCamera(@NonNull CameraInternal camera) {
        this.onUnbind();
        Object object = this.mCameraLock;
        synchronized (object) {
            if (camera == this.mCamera) {
                this.removeStateChangeCallback(this.mCamera);
                this.mCamera = null;
            }
            if (camera == this.mSecondaryCamera) {
                this.removeStateChangeCallback(this.mSecondaryCamera);
                this.mSecondaryCamera = null;
            }
        }
        this.mAttachedStreamSpec = null;
        this.mViewPortCropRect = null;
        this.mCurrentConfig = this.mUseCaseConfig;
        this.mExtendedConfig = null;
        this.mCameraConfig = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onUnbind() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @CallSuper
    public void onStateAttached() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateDetached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected CameraControlInternal getCameraControl() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera == null) {
                return CameraControlInternal.DEFAULT_EMPTY_INSTANCE;
            }
            return this.mCamera.getCameraControlInternal();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @CallSuper
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        this.mViewPortCropRect = viewPortCropRect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setEffect(@Nullable CameraEffect effect) {
        Preconditions.checkArgument((effect == null || this.isEffectTargetsSupported(effect.getTargets()) ? 1 : 0) != 0);
        this.mEffect = effect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraEffect getEffect() {
        return this.mEffect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Rect getViewPortCropRect() {
        return this.mViewPortCropRect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @CallSuper
    public void setSensorToBufferTransformMatrix(@NonNull Matrix sensorToBufferTransformMatrix) {
        this.mSensorToBufferTransformMatrix = new Matrix(sensorToBufferTransformMatrix);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Matrix getSensorToBufferTransformMatrix() {
        return this.mSensorToBufferTransformMatrix;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getImageFormat() {
        return this.mCurrentConfig.getInputFormat();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    protected ResolutionInfo getResolutionInfoInternal() {
        CameraInternal camera = this.getCamera();
        Size resolution = this.getAttachedSurfaceResolution();
        if (camera == null || resolution == null) {
            return null;
        }
        Rect cropRect = this.getViewPortCropRect();
        if (cropRect == null) {
            cropRect = new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
        }
        int rotationDegrees = this.getRelativeRotation(camera);
        return new ResolutionInfo(resolution, cropRect, rotationDegrees);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Set<Integer> getSupportedEffectTargets() {
        return Collections.emptySet();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isEffectTargetsSupported(int effectTargets) {
        for (Integer useCaseTargets : this.getSupportedEffectTargets()) {
            if (!TargetUtils.isSuperset(effectTargets, useCaseTargets)) continue;
            return true;
        }
        return false;
    }

    static enum State {
        ACTIVE,
        INACTIVE;

    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface StateChangeCallback {
        public void onUseCaseActive(@NonNull UseCase var1);

        public void onUseCaseInactive(@NonNull UseCase var1);

        public void onUseCaseUpdated(@NonNull UseCase var1);

        public void onUseCaseReset(@NonNull UseCase var1);
    }
}

