/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LayoutSettings {
    public static final LayoutSettings DEFAULT = new Builder().setAlpha(1.0f).setOffsetX(0.0f).setOffsetY(0.0f).setWidth(1.0f).setHeight(1.0f).build();
    private final float mAlpha;
    private final float mOffsetX;
    private final float mOffsetY;
    private final float mWidth;
    private final float mHeight;

    private LayoutSettings(float alpha, float offsetX, float offsetY, float width, float height) {
        this.mAlpha = alpha;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        this.mWidth = width;
        this.mHeight = height;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public float getOffsetX() {
        return this.mOffsetX;
    }

    public float getOffsetY() {
        return this.mOffsetY;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public static final class Builder {
        private float mAlpha = 1.0f;
        private float mOffsetX = 0.0f;
        private float mOffsetY = 0.0f;
        private float mWidth = 0.0f;
        private float mHeight = 0.0f;

        @NonNull
        public Builder setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.mAlpha = alpha;
            return this;
        }

        @NonNull
        public Builder setOffsetX(@FloatRange(from=-1.0, to=1.0) float offsetX) {
            this.mOffsetX = offsetX;
            return this;
        }

        @NonNull
        public Builder setOffsetY(@FloatRange(from=-1.0, to=1.0) float offsetY) {
            this.mOffsetY = offsetY;
            return this;
        }

        @NonNull
        public Builder setWidth(@FloatRange(from=-1.0, to=1.0) float width) {
            this.mWidth = width;
            return this;
        }

        @NonNull
        public Builder setHeight(@FloatRange(from=-1.0, to=1.0) float height) {
            this.mHeight = height;
            return this;
        }

        @NonNull
        public LayoutSettings build() {
            return new LayoutSettings(this.mAlpha, this.mOffsetX, this.mOffsetY, this.mWidth, this.mHeight);
        }
    }
}

