/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import java.util.Objects;

public class ImageCaptureLatencyEstimate {
    public static final long UNDEFINED_CAPTURE_LATENCY = -1L;
    public static final long UNDEFINED_PROCESSING_LATENCY = -1L;
    @NonNull
    public static final ImageCaptureLatencyEstimate UNDEFINED_IMAGE_CAPTURE_LATENCY = new ImageCaptureLatencyEstimate(-1L, -1L);
    private final long mCaptureLatencyMillis;
    private final long mProcessingLatencyMillis;
    private final long mTotalCaptureLatencyMillis;

    public ImageCaptureLatencyEstimate(long captureLatencyMillis, long processingLatencyMillis) {
        this.mCaptureLatencyMillis = captureLatencyMillis;
        this.mProcessingLatencyMillis = processingLatencyMillis;
        this.mTotalCaptureLatencyMillis = this.computeTotalCaptureLatencyMillis(captureLatencyMillis, processingLatencyMillis);
    }

    public long getCaptureLatencyMillis() {
        return this.mCaptureLatencyMillis;
    }

    public long getProcessingLatencyMillis() {
        return this.mProcessingLatencyMillis;
    }

    public long getTotalCaptureLatencyMillis() {
        return this.mTotalCaptureLatencyMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageCaptureLatencyEstimate)) {
            return false;
        }
        ImageCaptureLatencyEstimate that = (ImageCaptureLatencyEstimate)o;
        return this.mCaptureLatencyMillis == that.getCaptureLatencyMillis() && this.mProcessingLatencyMillis == that.getProcessingLatencyMillis() && this.mTotalCaptureLatencyMillis == that.getTotalCaptureLatencyMillis();
    }

    public int hashCode() {
        return Objects.hash(this.mCaptureLatencyMillis, this.mProcessingLatencyMillis, this.mTotalCaptureLatencyMillis);
    }

    @NonNull
    public String toString() {
        return "captureLatencyMillis=" + this.mCaptureLatencyMillis + ", processingLatencyMillis=" + this.mProcessingLatencyMillis + ", totalCaptureLatencyMillis=" + this.mTotalCaptureLatencyMillis;
    }

    private long computeTotalCaptureLatencyMillis(long captureLatencyMillis, long processingLatencyMillis) {
        if (captureLatencyMillis == -1L || processingLatencyMillis == -1L) {
            return -1L;
        }
        return captureLatencyMillis + processingLatencyMillis;
    }
}

