/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Range;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraState;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.DynamicRanges;
import androidx.camera.core.internal.compat.MediaActionSoundCompat;
import androidx.lifecycle.LiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;

public interface CameraInfo {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final float INTRINSIC_ZOOM_RATIO_UNKNOWN = 1.0f;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_UNKNOWN = "<unknown>";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_CAMERA2 = "androidx.camera.camera2";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_CAMERA2_LEGACY = "androidx.camera.camera2.legacy";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_FAKE = "androidx.camera.fake";

    public static boolean mustPlayShutterSound() {
        return MediaActionSoundCompat.mustPlayShutterSound();
    }

    public int getSensorRotationDegrees();

    public int getSensorRotationDegrees(int var1);

    public boolean hasFlashUnit();

    @NonNull
    public LiveData<Integer> getTorchState();

    @NonNull
    public LiveData<ZoomState> getZoomState();

    @NonNull
    public ExposureState getExposureState();

    @NonNull
    public LiveData<CameraState> getCameraState();

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getImplementationType();

    @NonNull
    public CameraSelector getCameraSelector();

    default public int getLensFacing() {
        return -1;
    }

    @FloatRange(from=0.0, fromInclusive=false)
    default public float getIntrinsicZoomRatio() {
        return 1.0f;
    }

    default public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        return false;
    }

    @ExperimentalZeroShutterLag
    default public boolean isZslSupported() {
        return false;
    }

    @NonNull
    default public Set<Range<Integer>> getSupportedFrameRateRanges() {
        return Collections.emptySet();
    }

    default public boolean isLogicalMultiCameraSupported() {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public boolean isPrivateReprocessingSupported() {
        return false;
    }

    @NonNull
    default public Set<DynamicRange> querySupportedDynamicRanges(@NonNull Set<DynamicRange> candidateDynamicRanges) {
        return DynamicRanges.findAllPossibleMatches(candidateDynamicRanges, Collections.singleton(DynamicRange.SDR));
    }

    @NonNull
    default public Set<CameraInfo> getPhysicalCameraInfos() {
        return Collections.emptySet();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImplementationType {
    }
}

