/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.Logger;
import androidx.camera.core.ProcessingException;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceProcessor;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.core.util.Consumer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class SurfaceProcessorWithExecutor
implements SurfaceProcessorInternal {
    private static final String TAG = "SurfaceProcessor";
    @NonNull
    private final SurfaceProcessor mSurfaceProcessor;
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final Consumer<Throwable> mErrorListener;

    public SurfaceProcessorWithExecutor(@NonNull CameraEffect cameraEffect) {
        this.mSurfaceProcessor = Objects.requireNonNull(cameraEffect.getSurfaceProcessor());
        this.mExecutor = cameraEffect.getExecutor();
        this.mErrorListener = cameraEffect.getErrorListener();
    }

    @NonNull
    @VisibleForTesting
    public SurfaceProcessor getProcessor() {
        return this.mSurfaceProcessor;
    }

    @NonNull
    @VisibleForTesting
    public Executor getExecutor() {
        return this.mExecutor;
    }

    @Override
    public void onInputSurface(@NonNull SurfaceRequest request) {
        this.mExecutor.execute(() -> {
            try {
                this.mSurfaceProcessor.onInputSurface(request);
            }
            catch (ProcessingException e) {
                Logger.e(TAG, "Failed to setup SurfaceProcessor input.", e);
                this.mErrorListener.accept((Object)e);
            }
        });
    }

    @Override
    public void onOutputSurface(@NonNull SurfaceOutput surfaceOutput) {
        this.mExecutor.execute(() -> {
            try {
                this.mSurfaceProcessor.onOutputSurface(surfaceOutput);
            }
            catch (ProcessingException e) {
                Logger.e(TAG, "Failed to setup SurfaceProcessor output.", e);
                this.mErrorListener.accept((Object)e);
            }
        });
    }

    @Override
    @NonNull
    public ListenableFuture<Void> snapshot(@IntRange(from=0L, to=100L) int jpegQuality, @IntRange(from=0L, to=359L) int rotationDegrees) {
        return Futures.immediateFailedFuture(new Exception("Snapshot not supported by external SurfaceProcessor"));
    }

    @Override
    public void release() {
    }
}

