/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.util.List;

final class AutoValue_AttachedSurfaceInfo
extends AttachedSurfaceInfo {
    private final SurfaceConfig surfaceConfig;
    private final int imageFormat;
    private final Size size;
    private final DynamicRange dynamicRange;
    private final List<UseCaseConfigFactory.CaptureType> captureTypes;
    private final Config implementationOptions;
    private final Range<Integer> targetFrameRate;

    AutoValue_AttachedSurfaceInfo(SurfaceConfig surfaceConfig, int imageFormat, Size size, DynamicRange dynamicRange, List<UseCaseConfigFactory.CaptureType> captureTypes, @Nullable Config implementationOptions, @Nullable Range<Integer> targetFrameRate) {
        if (surfaceConfig == null) {
            throw new NullPointerException("Null surfaceConfig");
        }
        this.surfaceConfig = surfaceConfig;
        this.imageFormat = imageFormat;
        if (size == null) {
            throw new NullPointerException("Null size");
        }
        this.size = size;
        if (dynamicRange == null) {
            throw new NullPointerException("Null dynamicRange");
        }
        this.dynamicRange = dynamicRange;
        if (captureTypes == null) {
            throw new NullPointerException("Null captureTypes");
        }
        this.captureTypes = captureTypes;
        this.implementationOptions = implementationOptions;
        this.targetFrameRate = targetFrameRate;
    }

    @Override
    @NonNull
    public SurfaceConfig getSurfaceConfig() {
        return this.surfaceConfig;
    }

    @Override
    public int getImageFormat() {
        return this.imageFormat;
    }

    @Override
    @NonNull
    public Size getSize() {
        return this.size;
    }

    @Override
    @NonNull
    public DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    @Override
    @NonNull
    public List<UseCaseConfigFactory.CaptureType> getCaptureTypes() {
        return this.captureTypes;
    }

    @Override
    @Nullable
    public Config getImplementationOptions() {
        return this.implementationOptions;
    }

    @Override
    @Nullable
    public Range<Integer> getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public String toString() {
        return "AttachedSurfaceInfo{surfaceConfig=" + this.surfaceConfig + ", imageFormat=" + this.imageFormat + ", size=" + this.size + ", dynamicRange=" + this.dynamicRange + ", captureTypes=" + this.captureTypes + ", implementationOptions=" + this.implementationOptions + ", targetFrameRate=" + this.targetFrameRate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttachedSurfaceInfo) {
            AttachedSurfaceInfo that = (AttachedSurfaceInfo)o;
            return this.surfaceConfig.equals(that.getSurfaceConfig()) && this.imageFormat == that.getImageFormat() && this.size.equals((Object)that.getSize()) && this.dynamicRange.equals(that.getDynamicRange()) && this.captureTypes.equals(that.getCaptureTypes()) && (this.implementationOptions == null ? that.getImplementationOptions() == null : this.implementationOptions.equals(that.getImplementationOptions())) && (this.targetFrameRate == null ? that.getTargetFrameRate() == null : this.targetFrameRate.equals(that.getTargetFrameRate()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.surfaceConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.imageFormat;
        h$ *= 1000003;
        h$ ^= this.size.hashCode();
        h$ *= 1000003;
        h$ ^= this.dynamicRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.captureTypes.hashCode();
        h$ *= 1000003;
        h$ ^= this.implementationOptions == null ? 0 : this.implementationOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.targetFrameRate == null ? 0 : this.targetFrameRate.hashCode();
    }
}

