/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.Comparator;

@RequiresApi(value=21)
public final class AspectRatioUtil {
    public static final Rational ASPECT_RATIO_4_3 = new Rational(4, 3);
    public static final Rational ASPECT_RATIO_3_4 = new Rational(3, 4);
    public static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);
    public static final Rational ASPECT_RATIO_9_16 = new Rational(9, 16);
    private static final int ALIGN16 = 16;

    private AspectRatioUtil() {
    }

    public static boolean hasMatchingAspectRatio(@NonNull Size resolution, @Nullable Rational aspectRatio) {
        boolean isMatch = false;
        if (aspectRatio == null) {
            isMatch = false;
        } else if (aspectRatio.equals((Object)new Rational(resolution.getWidth(), resolution.getHeight()))) {
            isMatch = true;
        } else if (SizeUtil.getArea(resolution) >= SizeUtil.getArea(SizeUtil.RESOLUTION_VGA)) {
            isMatch = AspectRatioUtil.isPossibleMod16FromAspectRatio(resolution, aspectRatio);
        }
        return isMatch;
    }

    private static boolean isPossibleMod16FromAspectRatio(@NonNull Size resolution, @NonNull Rational aspectRatio) {
        int width = resolution.getWidth();
        int height = resolution.getHeight();
        Rational invAspectRatio = new Rational(aspectRatio.getDenominator(), aspectRatio.getNumerator());
        if (width % 16 == 0 && height % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(Math.max(0, height - 16), width, aspectRatio) || AspectRatioUtil.ratioIntersectsMod16Segment(Math.max(0, width - 16), height, invAspectRatio);
        }
        if (width % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(height, width, aspectRatio);
        }
        if (height % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(width, height, invAspectRatio);
        }
        return false;
    }

    private static boolean ratioIntersectsMod16Segment(int height, int mod16Width, Rational aspectRatio) {
        Preconditions.checkArgument((mod16Width % 16 == 0 ? 1 : 0) != 0);
        double aspectRatioWidth = (double)(height * aspectRatio.getNumerator()) / (double)aspectRatio.getDenominator();
        return aspectRatioWidth > (double)Math.max(0, mod16Width - 16) && aspectRatioWidth < (double)(mod16Width + 16);
    }

    @RequiresApi(value=21)
    public static final class CompareAspectRatiosByDistanceToTargetRatio
    implements Comparator<Rational> {
        private Rational mTargetRatio;

        public CompareAspectRatiosByDistanceToTargetRatio(@NonNull Rational targetRatio) {
            this.mTargetRatio = targetRatio;
        }

        @Override
        public int compare(Rational lhs, Rational rhs) {
            if (lhs.equals((Object)rhs)) {
                return 0;
            }
            Float lhsRatioDelta = Float.valueOf(Math.abs(lhs.floatValue() - this.mTargetRatio.floatValue()));
            Float rhsRatioDelta = Float.valueOf(Math.abs(rhs.floatValue() - this.mTargetRatio.floatValue()));
            int result = (int)Math.signum(lhsRatioDelta.floatValue() - rhsRatioDelta.floatValue());
            return result;
        }
    }
}

