/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;

@RequiresApi(value=21)
public final class VideoCaptureConfig
implements UseCaseConfig<VideoCapture>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<Integer> OPTION_VIDEO_FRAME_RATE = Config.Option.create("camerax.core.videoCapture.recordingFrameRate", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_BIT_RATE = Config.Option.create("camerax.core.videoCapture.bitRate", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_INTRA_FRAME_INTERVAL = Config.Option.create("camerax.core.videoCapture.intraFrameInterval", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_AUDIO_BIT_RATE = Config.Option.create("camerax.core.videoCapture.audioBitRate", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_AUDIO_SAMPLE_RATE = Config.Option.create("camerax.core.videoCapture.audioSampleRate", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_AUDIO_CHANNEL_COUNT = Config.Option.create("camerax.core.videoCapture.audioChannelCount", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_AUDIO_MIN_BUFFER_SIZE = Config.Option.create("camerax.core.videoCapture.audioMinBufferSize", Integer.TYPE);
    private final OptionsBundle mConfig;

    public VideoCaptureConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    public int getVideoFrameRate(int valueIfMissing) {
        return this.retrieveOption(OPTION_VIDEO_FRAME_RATE, valueIfMissing);
    }

    public int getVideoFrameRate() {
        return this.retrieveOption(OPTION_VIDEO_FRAME_RATE);
    }

    public int getBitRate(int valueIfMissing) {
        return this.retrieveOption(OPTION_BIT_RATE, valueIfMissing);
    }

    public int getBitRate() {
        return this.retrieveOption(OPTION_BIT_RATE);
    }

    public int getIFrameInterval(int valueIfMissing) {
        return this.retrieveOption(OPTION_INTRA_FRAME_INTERVAL, valueIfMissing);
    }

    public int getIFrameInterval() {
        return this.retrieveOption(OPTION_INTRA_FRAME_INTERVAL);
    }

    public int getAudioBitRate(int valueIfMissing) {
        return this.retrieveOption(OPTION_AUDIO_BIT_RATE, valueIfMissing);
    }

    public int getAudioBitRate() {
        return this.retrieveOption(OPTION_AUDIO_BIT_RATE);
    }

    public int getAudioSampleRate(int valueIfMissing) {
        return this.retrieveOption(OPTION_AUDIO_SAMPLE_RATE, valueIfMissing);
    }

    public int getAudioSampleRate() {
        return this.retrieveOption(OPTION_AUDIO_SAMPLE_RATE);
    }

    public int getAudioChannelCount(int valueIfMissing) {
        return this.retrieveOption(OPTION_AUDIO_CHANNEL_COUNT, valueIfMissing);
    }

    public int getAudioChannelCount() {
        return this.retrieveOption(OPTION_AUDIO_CHANNEL_COUNT);
    }

    public int getAudioMinBufferSize(int valueIfMissing) {
        return this.retrieveOption(OPTION_AUDIO_MIN_BUFFER_SIZE, valueIfMissing);
    }

    public int getAudioMinBufferSize() {
        return this.retrieveOption(OPTION_AUDIO_MIN_BUFFER_SIZE);
    }

    @Override
    public int getInputFormat() {
        return 34;
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }
}

