/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.OptionsBundle;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@RequiresApi(value=21)
public final class MutableOptionsBundle
extends OptionsBundle
implements MutableConfig {
    @NonNull
    private static final Config.OptionPriority DEFAULT_PRIORITY = Config.OptionPriority.OPTIONAL;

    private MutableOptionsBundle(TreeMap<Config.Option<?>, Map<Config.OptionPriority, Object>> persistentOptions) {
        super(persistentOptions);
    }

    @NonNull
    public static MutableOptionsBundle create() {
        return new MutableOptionsBundle(new TreeMap(ID_COMPARE));
    }

    @NonNull
    public static MutableOptionsBundle from(@NonNull Config otherConfig) {
        TreeMap persistentOptions = new TreeMap(ID_COMPARE);
        for (Config.Option<?> opt : otherConfig.listOptions()) {
            Set<Config.OptionPriority> priorities = otherConfig.getPriorities(opt);
            ArrayMap valuesMap = new ArrayMap();
            for (Config.OptionPriority priority : priorities) {
                valuesMap.put(priority, otherConfig.retrieveOptionWithPriority(opt, priority));
            }
            persistentOptions.put(opt, (Map<Config.OptionPriority, Object>)valuesMap);
        }
        return new MutableOptionsBundle(persistentOptions);
    }

    @Override
    @Nullable
    public <ValueT> ValueT removeOption(@NonNull Config.Option<ValueT> opt) {
        Object value = this.mOptions.remove(opt);
        return (ValueT)value;
    }

    @Override
    public <ValueT> void insertOption(@NonNull Config.Option<ValueT> opt, @Nullable ValueT value) {
        this.insertOption(opt, DEFAULT_PRIORITY, value);
    }

    @Override
    public <ValueT> void insertOption(@NonNull Config.Option<ValueT> opt, @NonNull Config.OptionPriority priority, @Nullable ValueT value) {
        ValueT value2;
        Map values = (Map)this.mOptions.get(opt);
        if (values == null) {
            values = new ArrayMap();
            this.mOptions.put(opt, values);
            values.put(priority, value);
            return;
        }
        Config.OptionPriority priority1 = (Config.OptionPriority)((Object)Collections.min(values.keySet()));
        Config.OptionPriority priority2 = priority;
        Object value1 = values.get((Object)priority1);
        if (!Objects.equals(value1, value2 = value) && Config.hasConflict(priority1, priority2)) {
            throw new IllegalArgumentException("Option values conflicts: " + opt.getId() + ", existing value (" + (Object)((Object)priority1) + ")=" + values.get((Object)priority1) + ", conflicting (" + (Object)((Object)priority2) + ")=" + value);
        }
        values.put(priority, value);
    }
}

