/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.utils.Threads;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;

@RequiresApi(api=21)
class RequestWithCallback
implements TakePictureCallback {
    private final TakePictureRequest mTakePictureRequest;
    private final ListenableFuture<Void> mCaptureFuture;
    private CallbackToFutureAdapter.Completer<Void> mCaptureCompleter;
    private boolean mIsComplete = false;
    private boolean mIsAborted = false;

    RequestWithCallback(@NonNull TakePictureRequest takePictureRequest) {
        this.mTakePictureRequest = takePictureRequest;
        this.mCaptureFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCaptureCompleter = completer;
            return "CaptureCompleteFuture";
        });
    }

    @Override
    @MainThread
    public void onImageCaptured() {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.mCaptureCompleter.set(null);
    }

    @Override
    @MainThread
    public void onFinalResult(@NonNull ImageCapture.OutputFileResults outputFileResults) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.mTakePictureRequest.onResult(outputFileResults);
    }

    @Override
    @MainThread
    public void onFinalResult(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.mTakePictureRequest.onResult(imageProxy);
    }

    @Override
    @MainThread
    public void onProcessFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.onFailure(imageCaptureException);
    }

    @Override
    public boolean isAborted() {
        return this.mIsAborted;
    }

    @Override
    @MainThread
    public void onCaptureFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.markComplete();
        this.mCaptureCompleter.set(null);
        this.onFailure(imageCaptureException);
    }

    @MainThread
    void abort(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        this.mIsAborted = true;
        this.mCaptureCompleter.set(null);
        this.onFailure(imageCaptureException);
    }

    @MainThread
    @NonNull
    ListenableFuture<Void> getCaptureFuture() {
        Threads.checkMainThread();
        return this.mCaptureFuture;
    }

    private void checkOnImageCaptured() {
        Preconditions.checkState((boolean)this.mCaptureFuture.isDone(), (String)"onImageCaptured() must be called before onFinalResult()");
    }

    private void markComplete() {
        Preconditions.checkState((!this.mIsComplete ? 1 : 0) != 0, (String)"The callback can only complete once.");
        this.mIsComplete = true;
    }

    @MainThread
    private void onFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        this.mTakePictureRequest.onError(imageCaptureException);
    }
}

