/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SettableImageProxy
extends ForwardingImageProxy {
    private final Object mLock = new Object();
    private final ImageInfo mImageInfo;
    @GuardedBy(value="mLock")
    @Nullable
    private Rect mCropRect;
    private final int mWidth;
    private final int mHeight;

    SettableImageProxy(ImageProxy imageProxy, ImageInfo imageInfo) {
        this(imageProxy, null, imageInfo);
    }

    public SettableImageProxy(@NonNull ImageProxy imageProxy, @Nullable Size resolution, @NonNull ImageInfo imageInfo) {
        super(imageProxy);
        if (resolution == null) {
            this.mWidth = super.getWidth();
            this.mHeight = super.getHeight();
        } else {
            this.mWidth = resolution.getWidth();
            this.mHeight = resolution.getHeight();
        }
        this.mImageInfo = imageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Rect getCropRect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCropRect == null) {
                return new Rect(0, 0, this.getWidth(), this.getHeight());
            }
            return new Rect(this.mCropRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCropRect(@Nullable Rect cropRect) {
        if (cropRect != null && !(cropRect = new Rect(cropRect)).intersect(0, 0, this.getWidth(), this.getHeight())) {
            cropRect.setEmpty();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCropRect = cropRect;
        }
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    @NonNull
    public ImageInfo getImageInfo() {
        return this.mImageInfo;
    }
}

