/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.media.Image;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public abstract class ForwardingImageProxy
implements ImageProxy {
    private final Object mLock = new Object();
    protected final ImageProxy mImage;
    @GuardedBy(value="mLock")
    private final Set<OnImageCloseListener> mOnImageCloseListeners = new HashSet<OnImageCloseListener>();

    protected ForwardingImageProxy(@NonNull ImageProxy image) {
        this.mImage = image;
    }

    @Override
    public void close() {
        this.mImage.close();
        this.notifyOnImageCloseListeners();
    }

    @Override
    @NonNull
    public Rect getCropRect() {
        return this.mImage.getCropRect();
    }

    @Override
    public void setCropRect(@Nullable Rect rect) {
        this.mImage.setCropRect(rect);
    }

    @Override
    public int getFormat() {
        return this.mImage.getFormat();
    }

    @Override
    public int getHeight() {
        return this.mImage.getHeight();
    }

    @Override
    public int getWidth() {
        return this.mImage.getWidth();
    }

    @Override
    @NonNull
    public ImageProxy.PlaneProxy[] getPlanes() {
        return this.mImage.getPlanes();
    }

    @Override
    @NonNull
    public ImageInfo getImageInfo() {
        return this.mImage.getImageInfo();
    }

    @Override
    @Nullable
    @ExperimentalGetImage
    public Image getImage() {
        return this.mImage.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnImageCloseListener(@NonNull OnImageCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnImageCloseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnImageCloseListeners() {
        HashSet<OnImageCloseListener> onImageCloseListeners;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            onImageCloseListeners = new HashSet<OnImageCloseListener>(this.mOnImageCloseListeners);
        }
        for (OnImageCloseListener listener : onImageCloseListeners) {
            listener.onImageClose(this);
        }
    }

    public static interface OnImageCloseListener {
        public void onImageClose(@NonNull ImageProxy var1);
    }
}

