/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.ArrayMap;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public class TagBundle {
    protected final Map<String, Object> mTagMap;
    private static final TagBundle EMPTY_TAGBUNDLE = new TagBundle((Map<String, Object>)new ArrayMap());

    protected TagBundle(@NonNull Map<String, Object> tagMap) {
        this.mTagMap = tagMap;
    }

    @NonNull
    public static TagBundle emptyBundle() {
        return EMPTY_TAGBUNDLE;
    }

    @NonNull
    public static TagBundle create(@NonNull Pair<String, Object> source) {
        ArrayMap map = new ArrayMap();
        map.put((String)source.first, source.second);
        return new TagBundle((Map<String, Object>)map);
    }

    @NonNull
    public static TagBundle from(@NonNull TagBundle otherTagBundle) {
        ArrayMap tags = new ArrayMap();
        for (String key : otherTagBundle.listKeys()) {
            tags.put(key, otherTagBundle.getTag(key));
        }
        return new TagBundle((Map<String, Object>)tags);
    }

    @Nullable
    public Object getTag(@NonNull String key) {
        return this.mTagMap.get(key);
    }

    @NonNull
    public Set<String> listKeys() {
        return this.mTagMap.keySet();
    }
}

