/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
public interface CameraControlInternal
extends CameraControl {
    public static final CameraControlInternal DEFAULT_EMPTY_INSTANCE = new CameraControlInternal(){

        @Override
        public int getFlashMode() {
            return 2;
        }

        @Override
        public void setFlashMode(int flashMode) {
        }

        @Override
        public void setZslDisabled(boolean disabled) {
        }

        @Override
        public void addZslConfig(@NonNull Size resolution, @NonNull SessionConfig.Builder sessionConfigBuilder) {
        }

        @Override
        @NonNull
        public ListenableFuture<Void> enableTorch(boolean torch) {
            return Futures.immediateFuture(null);
        }

        @Override
        @NonNull
        public ListenableFuture<Integer> setExposureCompensationIndex(int exposure) {
            return Futures.immediateFuture(0);
        }

        @Override
        @NonNull
        public ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashType) {
            return Futures.immediateFuture(Collections.emptyList());
        }

        @Override
        @NonNull
        public SessionConfig getSessionConfig() {
            return SessionConfig.defaultEmptySessionConfig();
        }

        @Override
        @NonNull
        public Rect getSensorRect() {
            return new Rect();
        }

        @Override
        @NonNull
        public ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
            return Futures.immediateFuture(FocusMeteringResult.emptyInstance());
        }

        @Override
        @NonNull
        public ListenableFuture<Void> cancelFocusAndMetering() {
            return Futures.immediateFuture(null);
        }

        @Override
        @NonNull
        public ListenableFuture<Void> setZoomRatio(float ratio) {
            return Futures.immediateFuture(null);
        }

        @Override
        @NonNull
        public ListenableFuture<Void> setLinearZoom(float linearZoom) {
            return Futures.immediateFuture(null);
        }

        @Override
        public void addInteropConfig(@NonNull Config config) {
        }

        @Override
        public void clearInteropConfig() {
        }

        @Override
        @NonNull
        public Config getInteropConfig() {
            return null;
        }
    };

    public int getFlashMode();

    public void setFlashMode(int var1);

    public void addZslConfig(@NonNull Size var1, @NonNull SessionConfig.Builder var2);

    public void setZslDisabled(boolean var1);

    @NonNull
    public ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> var1, int var2, int var3);

    @NonNull
    public SessionConfig getSessionConfig();

    @NonNull
    public Rect getSensorRect();

    public void addInteropConfig(@NonNull Config var1);

    public void clearInteropConfig();

    @NonNull
    public Config getInteropConfig();

    public static final class CameraControlException
    extends Exception {
        @NonNull
        private CameraCaptureFailure mCameraCaptureFailure;

        public CameraControlException(@NonNull CameraCaptureFailure failure) {
            this.mCameraCaptureFailure = failure;
        }

        public CameraControlException(@NonNull CameraCaptureFailure failure, @NonNull Throwable cause) {
            super(cause);
            this.mCameraCaptureFailure = failure;
        }

        @NonNull
        public CameraCaptureFailure getCameraCaptureFailure() {
            return this.mCameraCaptureFailure;
        }
    }

    public static interface ControlUpdateCallback {
        public void onCameraControlUpdateSessionConfig();

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> var1);
    }
}

