/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.interop;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.Camera2PhysicalCameraInfoImpl;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.Map;

@ExperimentalCamera2Interop
public final class Camera2CameraInfo {
    private static final String TAG = "Camera2CameraInfo";
    @Nullable
    private Camera2CameraInfoImpl mCamera2CameraInfoImpl;
    @Nullable
    private Camera2PhysicalCameraInfoImpl mCamera2PhysicalCameraInfo;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2CameraInfo(@NonNull Camera2CameraInfoImpl camera2CameraInfoImpl) {
        this.mCamera2CameraInfoImpl = camera2CameraInfoImpl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2CameraInfo(@NonNull Camera2PhysicalCameraInfoImpl camera2PhysicalCameraInfo) {
        this.mCamera2PhysicalCameraInfo = camera2PhysicalCameraInfo;
    }

    @NonNull
    public static Camera2CameraInfo from(@NonNull CameraInfo cameraInfo) {
        if (cameraInfo instanceof Camera2PhysicalCameraInfoImpl) {
            return ((Camera2PhysicalCameraInfoImpl)cameraInfo).getCamera2CameraInfo();
        }
        CameraInfoInternal cameraInfoImpl = ((CameraInfoInternal)cameraInfo).getImplementation();
        Preconditions.checkArgument((boolean)(cameraInfoImpl instanceof Camera2CameraInfoImpl), (Object)"CameraInfo doesn't contain Camera2 implementation.");
        return ((Camera2CameraInfoImpl)cameraInfoImpl).getCamera2CameraInfo();
    }

    @NonNull
    public String getCameraId() {
        if (this.mCamera2PhysicalCameraInfo != null) {
            return this.mCamera2PhysicalCameraInfo.getCameraId();
        }
        return this.mCamera2CameraInfoImpl.getCameraId();
    }

    @Nullable
    public <T> T getCameraCharacteristic(@NonNull CameraCharacteristics.Key<T> key) {
        if (this.mCamera2PhysicalCameraInfo != null) {
            return this.mCamera2PhysicalCameraInfo.getCameraCharacteristicsCompat().get(key);
        }
        return this.mCamera2CameraInfoImpl.getCameraCharacteristicsCompat().get(key);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static CameraCharacteristics extractCameraCharacteristics(@NonNull CameraInfo cameraInfo) {
        if (cameraInfo instanceof Camera2PhysicalCameraInfoImpl) {
            return ((Camera2PhysicalCameraInfoImpl)cameraInfo).getCameraCharacteristicsCompat().toCameraCharacteristics();
        }
        CameraInfoInternal cameraInfoImpl = ((CameraInfoInternal)cameraInfo).getImplementation();
        Preconditions.checkState((boolean)(cameraInfoImpl instanceof Camera2CameraInfoImpl), (String)"CameraInfo does not contain any Camera2 information.");
        Camera2CameraInfoImpl impl = (Camera2CameraInfoImpl)cameraInfoImpl;
        return impl.getCameraCharacteristicsCompat().toCameraCharacteristics();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Map<String, CameraCharacteristics> getCameraCharacteristicsMap() {
        if (this.mCamera2PhysicalCameraInfo != null) {
            return Collections.emptyMap();
        }
        return this.mCamera2CameraInfoImpl.getCameraCharacteristicsMap();
    }
}

