/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.interop;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraControl;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@ExperimentalCamera2Interop
public final class Camera2CameraControl {
    private boolean mIsActive = false;
    private boolean mPendingUpdate = false;
    private final Camera2CameraControlImpl mCamera2CameraControlImpl;
    final Executor mExecutor;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private Camera2ImplConfig.Builder mBuilder = new Camera2ImplConfig.Builder();
    CallbackToFutureAdapter.Completer<Void> mCompleter;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2CameraControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl, @NonNull Executor executor) {
        this.mCamera2CameraControlImpl = camera2CameraControlImpl;
        this.mExecutor = executor;
    }

    @NonNull
    public static Camera2CameraControl from(@NonNull CameraControl cameraControl) {
        CameraControlInternal cameraControlImpl = ((CameraControlInternal)cameraControl).getImplementation();
        Preconditions.checkArgument((boolean)(cameraControlImpl instanceof Camera2CameraControlImpl), (Object)"CameraControl doesn't contain Camera2 implementation.");
        return ((Camera2CameraControlImpl)cameraControlImpl).getCamera2CameraControl();
    }

    @NonNull
    public ListenableFuture<Void> setCaptureRequestOptions(@NonNull CaptureRequestOptions bundle) {
        this.clearCaptureRequestOptionsInternal();
        this.addCaptureRequestOptionsInternal(bundle);
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "setCaptureRequestOptions";
        }));
    }

    @NonNull
    public ListenableFuture<Void> addCaptureRequestOptions(@NonNull CaptureRequestOptions bundle) {
        this.addCaptureRequestOptionsInternal(bundle);
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "addCaptureRequestOptions";
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CaptureRequestOptions getCaptureRequestOptions() {
        Object object = this.mLock;
        synchronized (object) {
            return CaptureRequestOptions.Builder.from((Config)this.mBuilder.build()).build();
        }
    }

    @NonNull
    public ListenableFuture<Void> clearCaptureRequestOptions() {
        this.clearCaptureRequestOptionsInternal();
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "clearCaptureRequestOptions";
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Camera2ImplConfig getCamera2ImplConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void applyOptionsToBuilder(@NonNull Camera2ImplConfig.Builder builder) {
        Object object = this.mLock;
        synchronized (object) {
            builder.insertAllOptions((Config)this.mBuilder.getMutableConfig(), Config.OptionPriority.ALWAYS_OVERRIDE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCaptureRequestOptionsInternal(@NonNull CaptureRequestOptions bundle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mBuilder.insertAllOptions((Config)bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaptureRequestOptionsInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mBuilder = new Camera2ImplConfig.Builder();
        }
    }

    private void updateConfig(@NonNull CallbackToFutureAdapter.Completer<Void> completer) {
        this.mPendingUpdate = true;
        this.failInFlightUpdate((Exception)new CameraControl.OperationCanceledException("Camera2CameraControl was updated with new options."));
        this.mCompleter = completer;
        if (this.mIsActive) {
            this.updateSession();
        }
    }

    private void updateSession() {
        this.mCamera2CameraControlImpl.updateSessionConfigAsync().addListener(this::completeInFlightUpdate, this.mExecutor);
        this.mPendingUpdate = false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setActive(boolean isActive) {
        this.mExecutor.execute(() -> this.setActiveInternal(isActive));
    }

    private void setActiveInternal(boolean isActive) {
        if (this.mIsActive == isActive) {
            return;
        }
        this.mIsActive = isActive;
        if (this.mIsActive) {
            if (this.mPendingUpdate) {
                this.updateSession();
            }
        } else {
            this.failInFlightUpdate((Exception)new CameraControl.OperationCanceledException("The camera control has became inactive."));
        }
    }

    private void completeInFlightUpdate() {
        if (this.mCompleter != null) {
            this.mCompleter.set(null);
            this.mCompleter = null;
        }
    }

    private void failInFlightUpdate(@Nullable Exception exception) {
        if (this.mCompleter != null) {
            this.mCompleter.setException((Throwable)(exception != null ? exception : new Exception("Camera2CameraControl failed with unknown error.")));
            this.mCompleter = null;
        }
    }
}

