/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.os.Build;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExtraCroppingQuirk
implements Quirk {
    private static final Map<String, Range<Integer>> SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP = new HashMap<String, Range<Integer>>();

    static boolean load() {
        return ExtraCroppingQuirk.isSamsungDistortion();
    }

    @Nullable
    public Size getVerifiedResolution(@NonNull SurfaceConfig.ConfigType configType) {
        if (ExtraCroppingQuirk.isSamsungDistortion()) {
            switch (configType) {
                case PRIV: {
                    return new Size(1920, 1080);
                }
                case YUV: {
                    return new Size(1280, 720);
                }
                case JPEG: {
                    return new Size(3264, 1836);
                }
            }
            return null;
        }
        return null;
    }

    private static boolean isSamsungDistortion() {
        boolean isDeviceModelContained;
        boolean bl = isDeviceModelContained = "samsung".equalsIgnoreCase(Build.BRAND) && SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.containsKey(Build.MODEL.toUpperCase(Locale.US));
        if (!isDeviceModelContained) {
            return false;
        }
        Range<Integer> apiLevelRange = SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.get(Build.MODEL.toUpperCase(Locale.US));
        return apiLevelRange == null ? true : apiLevelRange.contains((Comparable)Integer.valueOf(Build.VERSION.SDK_INT));
    }

    static {
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-T580", null);
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-J710MN", (Range<Integer>)new Range((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(26)));
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-A320FL", null);
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-G570M", null);
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-G610F", null);
        SAMSUNG_DISTORTION_MODELS_TO_API_LEVEL_MAP.put("SM-G610M", (Range<Integer>)new Range((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(26)));
    }
}

