/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExcludedSupportedSizesQuirk
implements Quirk {
    private static final String TAG = "ExcludedSupportedSizesQuirk";
    private static final int UNKNOWN_IMAGE_FORMAT = -1;

    static boolean load() {
        return ExcludedSupportedSizesQuirk.isOnePlus6() || ExcludedSupportedSizesQuirk.isOnePlus6T() || ExcludedSupportedSizesQuirk.isHuaweiP20Lite() || ExcludedSupportedSizesQuirk.isSamsungJ7PrimeApi27Above() || ExcludedSupportedSizesQuirk.isSamsungJ7Api27Above() || ExcludedSupportedSizesQuirk.isRedmiNote9Pro();
    }

    private static boolean isOnePlus6() {
        return "OnePlus".equalsIgnoreCase(Build.BRAND) && "OnePlus6".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isOnePlus6T() {
        return "OnePlus".equalsIgnoreCase(Build.BRAND) && "OnePlus6T".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isHuaweiP20Lite() {
        return "HUAWEI".equalsIgnoreCase(Build.BRAND) && "HWANE".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isSamsungJ7PrimeApi27Above() {
        return "SAMSUNG".equalsIgnoreCase(Build.BRAND) && "ON7XELTE".equalsIgnoreCase(Build.DEVICE) && Build.VERSION.SDK_INT >= 27;
    }

    private static boolean isSamsungJ7Api27Above() {
        return "SAMSUNG".equalsIgnoreCase(Build.BRAND) && "J7XELTE".equalsIgnoreCase(Build.DEVICE) && Build.VERSION.SDK_INT >= 27;
    }

    private static boolean isRedmiNote9Pro() {
        return "REDMI".equalsIgnoreCase(Build.BRAND) && "joyeuse".equalsIgnoreCase(Build.DEVICE);
    }

    @NonNull
    public List<Size> getExcludedSizes(@NonNull String cameraId, int imageFormat) {
        if (ExcludedSupportedSizesQuirk.isOnePlus6()) {
            return this.getOnePlus6ExcludedSizes(cameraId, imageFormat);
        }
        if (ExcludedSupportedSizesQuirk.isOnePlus6T()) {
            return this.getOnePlus6TExcludedSizes(cameraId, imageFormat);
        }
        if (ExcludedSupportedSizesQuirk.isHuaweiP20Lite()) {
            return this.getHuaweiP20LiteExcludedSizes(cameraId, imageFormat, null);
        }
        if (ExcludedSupportedSizesQuirk.isSamsungJ7PrimeApi27Above()) {
            return this.getSamsungJ7PrimeApi27AboveExcludedSizes(cameraId, imageFormat, null);
        }
        if (ExcludedSupportedSizesQuirk.isSamsungJ7Api27Above()) {
            return this.getSamsungJ7Api27AboveExcludedSizes(cameraId, imageFormat, null);
        }
        if (ExcludedSupportedSizesQuirk.isRedmiNote9Pro()) {
            return this.getRedmiNote9ProExcludedSizes(cameraId, imageFormat);
        }
        Logger.w((String)TAG, (String)"Cannot retrieve list of supported sizes to exclude on this device.");
        return Collections.emptyList();
    }

    @NonNull
    public List<Size> getExcludedSizes(@NonNull String cameraId, @NonNull Class<?> klass) {
        if (ExcludedSupportedSizesQuirk.isHuaweiP20Lite()) {
            return this.getHuaweiP20LiteExcludedSizes(cameraId, -1, klass);
        }
        if (ExcludedSupportedSizesQuirk.isSamsungJ7PrimeApi27Above()) {
            return this.getSamsungJ7PrimeApi27AboveExcludedSizes(cameraId, -1, klass);
        }
        if (ExcludedSupportedSizesQuirk.isSamsungJ7Api27Above()) {
            return this.getSamsungJ7Api27AboveExcludedSizes(cameraId, -1, klass);
        }
        Logger.w((String)TAG, (String)"Cannot retrieve list of supported sizes to exclude on this device.");
        return Collections.emptyList();
    }

    @NonNull
    private List<Size> getOnePlus6ExcludedSizes(@NonNull String cameraId, int imageFormat) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && imageFormat == 256) {
            sizes.add(new Size(4160, 3120));
            sizes.add(new Size(4000, 3000));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getOnePlus6TExcludedSizes(@NonNull String cameraId, int imageFormat) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && imageFormat == 256) {
            sizes.add(new Size(4160, 3120));
            sizes.add(new Size(4000, 3000));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getHuaweiP20LiteExcludedSizes(@NonNull String cameraId, int imageFormat, @Nullable Class<?> klass) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && (imageFormat == 34 || imageFormat == 35 || klass != null)) {
            sizes.add(new Size(720, 720));
            sizes.add(new Size(400, 400));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getSamsungJ7PrimeApi27AboveExcludedSizes(@NonNull String cameraId, int imageFormat, @Nullable Class<?> klass) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0")) {
            if (imageFormat == 34 || klass != null) {
                sizes.add(new Size(4128, 3096));
                sizes.add(new Size(4128, 2322));
                sizes.add(new Size(3088, 3088));
                sizes.add(new Size(3264, 2448));
                sizes.add(new Size(3264, 1836));
                sizes.add(new Size(2048, 1536));
                sizes.add(new Size(2048, 1152));
                sizes.add(new Size(1920, 1080));
            } else if (imageFormat == 35) {
                sizes.add(new Size(4128, 2322));
                sizes.add(new Size(3088, 3088));
                sizes.add(new Size(3264, 2448));
                sizes.add(new Size(3264, 1836));
                sizes.add(new Size(2048, 1536));
                sizes.add(new Size(2048, 1152));
                sizes.add(new Size(1920, 1080));
            }
        } else if (cameraId.equals("1") && (imageFormat == 34 || imageFormat == 35 || klass != null)) {
            sizes.add(new Size(3264, 2448));
            sizes.add(new Size(3264, 1836));
            sizes.add(new Size(2448, 2448));
            sizes.add(new Size(1920, 1920));
            sizes.add(new Size(2048, 1536));
            sizes.add(new Size(2048, 1152));
            sizes.add(new Size(1920, 1080));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getSamsungJ7Api27AboveExcludedSizes(@NonNull String cameraId, int imageFormat, @Nullable Class<?> klass) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0")) {
            if (imageFormat == 34 || klass != null) {
                sizes.add(new Size(4128, 3096));
                sizes.add(new Size(4128, 2322));
                sizes.add(new Size(3088, 3088));
                sizes.add(new Size(3264, 2448));
                sizes.add(new Size(3264, 1836));
                sizes.add(new Size(2048, 1536));
                sizes.add(new Size(2048, 1152));
                sizes.add(new Size(1920, 1080));
            } else if (imageFormat == 35) {
                sizes.add(new Size(2048, 1536));
                sizes.add(new Size(2048, 1152));
                sizes.add(new Size(1920, 1080));
            }
        } else if (cameraId.equals("1") && (imageFormat == 34 || imageFormat == 35 || klass != null)) {
            sizes.add(new Size(2576, 1932));
            sizes.add(new Size(2560, 1440));
            sizes.add(new Size(1920, 1920));
            sizes.add(new Size(2048, 1536));
            sizes.add(new Size(2048, 1152));
            sizes.add(new Size(1920, 1080));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getRedmiNote9ProExcludedSizes(@NonNull String cameraId, int imageFormat) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && imageFormat == 256) {
            sizes.add(new Size(9280, 6944));
        }
        return sizes;
    }
}

