/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.core.Logger;

class StreamConfigurationMapCompatBaseImpl
implements StreamConfigurationMapCompat.StreamConfigurationMapCompatImpl {
    private static final String TAG = "StreamConfigurationMapCompatBaseImpl";
    final StreamConfigurationMap mStreamConfigurationMap;

    StreamConfigurationMapCompatBaseImpl(@NonNull StreamConfigurationMap map) {
        this.mStreamConfigurationMap = map;
    }

    @Override
    @Nullable
    public int[] getOutputFormats() {
        try {
            return this.mStreamConfigurationMap.getOutputFormats();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Logger.w((String)TAG, (String)"Failed to get output formats from StreamConfigurationMap", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Size[] getOutputSizes(int format) {
        Size[] sizes = format == 34 ? this.mStreamConfigurationMap.getOutputSizes(SurfaceTexture.class) : this.mStreamConfigurationMap.getOutputSizes(format);
        return sizes;
    }

    @Override
    @Nullable
    public <T> Size[] getOutputSizes(@NonNull Class<T> klass) {
        return this.mStreamConfigurationMap.getOutputSizes(klass);
    }

    @Override
    @Nullable
    public Size[] getHighResolutionOutputSizes(int format) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getHighResolutionOutputSizes(this.mStreamConfigurationMap, format);
        }
        return null;
    }

    @Override
    @NonNull
    public StreamConfigurationMap unwrap() {
        return this.mStreamConfigurationMap;
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        static Size[] getHighResolutionOutputSizes(StreamConfigurationMap streamConfigurationMap, int format) {
            return streamConfigurationMap.getHighResolutionOutputSizes(format);
        }
    }
}

