/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Size;
import android.util.SizeF;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.LensFacingUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.core.util.Preconditions;

public class FovUtil {
    private static final String TAG = "FovUtil";

    private FovUtil() {
    }

    @IntRange(from=0L, to=360L)
    public static int focalLengthToViewAngleDegrees(float focalLength, float sensorLength) {
        Preconditions.checkArgument((focalLength > 0.0f ? 1 : 0) != 0, (Object)"Focal length should be positive.");
        Preconditions.checkArgument((sensorLength > 0.0f ? 1 : 0) != 0, (Object)"Sensor length should be positive.");
        int viewAngleDegrees = (int)Math.toDegrees(2.0 * Math.atan(sensorLength / (2.0f * focalLength)));
        Preconditions.checkArgumentInRange((int)viewAngleDegrees, (int)0, (int)360, (String)"The provided focal length and sensor length result in an invalid view angle degrees.");
        return viewAngleDegrees;
    }

    public static int getDeviceDefaultViewAngleDegrees(@NonNull CameraManagerCompat cameraManager, int lensFacing) {
        try {
            String[] cameraIds;
            for (String cameraId : cameraIds = cameraManager.getCameraIdList()) {
                CameraCharacteristicsCompat cameraCharacteristics = cameraManager.getCameraCharacteristicsCompat(cameraId);
                Integer cameraCharacteristicsLensFacing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                Preconditions.checkNotNull((Object)cameraCharacteristicsLensFacing, (Object)"Lens facing can not be null");
                if (cameraCharacteristicsLensFacing != LensFacingUtil.getLensFacingInt(lensFacing)) continue;
                return FovUtil.focalLengthToViewAngleDegrees(FovUtil.getDefaultFocalLength(cameraCharacteristics), FovUtil.getSensorHorizontalLength(cameraCharacteristics));
            }
        }
        catch (CameraAccessExceptionCompat e) {
            throw new IllegalArgumentException("Unable to get the default focal length.");
        }
        throw new IllegalArgumentException("Unable to get the default focal length with the specified lens facing.");
    }

    public static float getSensorHorizontalLength(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        SizeF sensorSize = (SizeF)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
        Rect activeArrayRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        Size pixelArraySize = (Size)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
        Integer sensorOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorSize, (Object)"The sensor size can't be null.");
        Preconditions.checkNotNull((Object)sensorOrientation, (Object)"The sensor orientation can't be null.");
        Preconditions.checkNotNull((Object)activeArrayRect, (Object)"The active array size can't be null.");
        Preconditions.checkNotNull((Object)pixelArraySize, (Object)"The pixel array size can't be null.");
        Size activeArraySize = TransformUtils.rectToSize((Rect)activeArrayRect);
        if (TransformUtils.is90or270((int)sensorOrientation)) {
            sensorSize = TransformUtils.reverseSizeF((SizeF)sensorSize);
            activeArraySize = TransformUtils.reverseSize((Size)activeArraySize);
            pixelArraySize = TransformUtils.reverseSize((Size)pixelArraySize);
        }
        return sensorSize.getWidth() * (float)activeArraySize.getWidth() / (float)pixelArraySize.getWidth();
    }

    public static float getDefaultFocalLength(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        float[] focalLengths = (float[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        Preconditions.checkNotNull((Object)focalLengths, (Object)"The focal lengths can not be empty.");
        return focalLengths[0];
    }
}

