/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

class CaptureSessionRepository {
    @NonNull
    final Executor mExecutor;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mCaptureSessions = new LinkedHashSet<SynchronizedCaptureSession>();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mClosingCaptureSession = new LinkedHashSet<SynchronizedCaptureSession>();
    @GuardedBy(value="mLock")
    final Set<SynchronizedCaptureSession> mCreatingCaptureSessions = new LinkedHashSet<SynchronizedCaptureSession>();
    private final CameraDevice.StateCallback mCameraStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            this.forceOnClosedCaptureSessions();
            this.dispatchOnError(error);
            this.cameraClosed();
        }

        public void onClosed(@NonNull CameraDevice camera) {
            this.forceOnClosedCaptureSessions();
            this.cameraClosed();
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            this.forceOnClosedCaptureSessions();
            this.cameraClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceOnClosedCaptureSessions() {
            LinkedHashSet<SynchronizedCaptureSession> sessions = new LinkedHashSet<SynchronizedCaptureSession>();
            Object object = CaptureSessionRepository.this.mLock;
            synchronized (object) {
                sessions.addAll(CaptureSessionRepository.this.mCreatingCaptureSessions);
                sessions.addAll(CaptureSessionRepository.this.mCaptureSessions);
            }
            CaptureSessionRepository.this.mExecutor.execute(() -> CaptureSessionRepository.forceOnClosed(sessions));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchOnError(int error) {
            LinkedHashSet<SynchronizedCaptureSession> sessions = new LinkedHashSet<SynchronizedCaptureSession>();
            Object object = CaptureSessionRepository.this.mLock;
            synchronized (object) {
                sessions.addAll(CaptureSessionRepository.this.mCreatingCaptureSessions);
                sessions.addAll(CaptureSessionRepository.this.mCaptureSessions);
            }
            CaptureSessionRepository.this.mExecutor.execute(() -> {
                for (SynchronizedCaptureSession session : sessions) {
                    session.onCameraDeviceError(error);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cameraClosed() {
            List<SynchronizedCaptureSession> sessions;
            Iterator<SynchronizedCaptureSession> iterator = CaptureSessionRepository.this.mLock;
            synchronized (iterator) {
                sessions = CaptureSessionRepository.this.getSessionsInOrder();
                CaptureSessionRepository.this.mCreatingCaptureSessions.clear();
                CaptureSessionRepository.this.mCaptureSessions.clear();
                CaptureSessionRepository.this.mClosingCaptureSession.clear();
            }
            for (SynchronizedCaptureSession s : sessions) {
                s.finishClose();
            }
        }
    };

    CaptureSessionRepository(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    @NonNull
    CameraDevice.StateCallback getCameraStateCallback() {
        return this.mCameraStateCallback;
    }

    static void forceOnClosed(@NonNull Set<SynchronizedCaptureSession> sessions) {
        for (SynchronizedCaptureSession session : sessions) {
            session.getStateCallback().onClosed(session);
        }
    }

    private void forceFinishCloseStaleSessions(@NonNull SynchronizedCaptureSession session) {
        List<SynchronizedCaptureSession> sessions = this.getSessionsInOrder();
        for (SynchronizedCaptureSession s : sessions) {
            if (s == session) break;
            s.finishClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getCaptureSessions() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mCaptureSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getClosingCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mClosingCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getCreatingCaptureSessions() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<SynchronizedCaptureSession>(this.mCreatingCaptureSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<SynchronizedCaptureSession> getSessionsInOrder() {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<SynchronizedCaptureSession> sessions = new ArrayList<SynchronizedCaptureSession>();
            sessions.addAll(this.getCaptureSessions());
            sessions.addAll(this.getCreatingCaptureSessions());
            return sessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCreateCaptureSession(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCreatingCaptureSessions.add(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionConfigureFail(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        this.forceFinishCloseStaleSessions(synchronizedCaptureSession);
        Object object = this.mLock;
        synchronized (object) {
            this.mCreatingCaptureSessions.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionCreated(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCaptureSessions.add(synchronizedCaptureSession);
            this.mCreatingCaptureSessions.remove(synchronizedCaptureSession);
        }
        this.forceFinishCloseStaleSessions(synchronizedCaptureSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionClosed(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCaptureSessions.remove(synchronizedCaptureSession);
            this.mClosingCaptureSession.remove(synchronizedCaptureSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCaptureSessionClosing(@NonNull SynchronizedCaptureSession synchronizedCaptureSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClosingCaptureSession.add(synchronizedCaptureSession);
        }
    }
}

