/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.TagBundle;
import androidx.core.util.Preconditions;

final class CaptureCallbackAdapter
extends CameraCaptureSession.CaptureCallback {
    private final CameraCaptureCallback mCameraCaptureCallback;

    CaptureCallbackAdapter(CameraCaptureCallback cameraCaptureCallback) {
        if (cameraCaptureCallback == null) {
            throw new NullPointerException("cameraCaptureCallback is null");
        }
        this.mCameraCaptureCallback = cameraCaptureCallback;
    }

    public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
        super.onCaptureStarted(session, request, timestamp, frameNumber);
        this.mCameraCaptureCallback.onCaptureStarted(this.getCaptureConfigId(request));
    }

    private int getCaptureConfigId(CaptureRequest captureRequest) {
        if (!(captureRequest.getTag() instanceof TagBundle)) {
            return -1;
        }
        TagBundle tagbundle = (TagBundle)captureRequest.getTag();
        Integer captureConfigId = (Integer)tagbundle.getTag("CAPTURE_CONFIG_ID_KEY");
        if (captureConfigId == null) {
            return -1;
        }
        return captureConfigId;
    }

    public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        TagBundle tagBundle;
        super.onCaptureCompleted(session, request, result);
        Object captureRequestTag = request.getTag();
        if (captureRequestTag != null) {
            Preconditions.checkArgument((boolean)(captureRequestTag instanceof TagBundle), (Object)"The tagBundle object from the CaptureResult is not a TagBundle object.");
            tagBundle = (TagBundle)captureRequestTag;
        } else {
            tagBundle = TagBundle.emptyBundle();
        }
        this.mCameraCaptureCallback.onCaptureCompleted(this.getCaptureConfigId(request), (CameraCaptureResult)new Camera2CameraCaptureResult(tagBundle, (CaptureResult)result));
    }

    public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
        super.onCaptureFailed(session, request, failure);
        CameraCaptureFailure cameraFailure = new CameraCaptureFailure(CameraCaptureFailure.Reason.ERROR);
        this.mCameraCaptureCallback.onCaptureFailed(this.getCaptureConfigId(request), cameraFailure);
    }
}

