/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.LensFacingUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraState;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import java.util.Set;

@ExperimentalCamera2Interop
public class Camera2PhysicalCameraInfoImpl
implements CameraInfo {
    @NonNull
    private final String mCameraId;
    @NonNull
    private final CameraCharacteristicsCompat mCameraCharacteristicsCompat;
    @NonNull
    private final Camera2CameraInfo mCamera2CameraInfo;

    public Camera2PhysicalCameraInfoImpl(@NonNull String cameraId, @NonNull CameraManagerCompat cameraManager) throws CameraAccessExceptionCompat {
        this.mCameraId = cameraId;
        this.mCameraCharacteristicsCompat = cameraManager.getCameraCharacteristicsCompat(this.mCameraId);
        this.mCamera2CameraInfo = new Camera2CameraInfo(this);
    }

    @NonNull
    public Camera2CameraInfo getCamera2CameraInfo() {
        return this.mCamera2CameraInfo;
    }

    @NonNull
    public String getCameraId() {
        return this.mCameraId;
    }

    @NonNull
    public CameraCharacteristicsCompat getCameraCharacteristicsCompat() {
        return this.mCameraCharacteristicsCompat;
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        int sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        int lensFacing = this.getLensFacing();
        boolean isOppositeFacingScreen = 1 == lensFacing;
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    public boolean hasFlashUnit() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public LiveData<Integer> getTorchState() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public LiveData<ZoomState> getZoomState() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public ExposureState getExposureState() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public LiveData<CameraState> getCameraState() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public String getImplementationType() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public CameraSelector getCameraSelector() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    public int getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkArgument((lensFacing != null ? 1 : 0) != 0, (Object)"Unable to get the lens facing of the camera.");
        return LensFacingUtil.getCameraSelectorLensFacing(lensFacing);
    }

    public float getIntrinsicZoomRatio() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @SuppressLint(value={"NullAnnotationGroup"})
    @ExperimentalZeroShutterLag
    public boolean isZslSupported() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public Set<Range<Integer>> getSupportedFrameRateRanges() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    public boolean isLogicalMultiCameraSupported() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    public boolean isPrivateReprocessingSupported() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public Set<DynamicRange> querySupportedDynamicRanges(@NonNull Set<DynamicRange> candidateDynamicRanges) {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    @NonNull
    public Set<CameraInfo> getPhysicalCameraInfos() {
        throw new UnsupportedOperationException("Physical camera doesn't support this function");
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }
}

