/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.media.CamcorderProfile;
import android.media.EncoderProfiles;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.CamcorderProfileResolutionQuirk;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.InvalidVideoProfilesQuirk;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.compat.EncoderProfilesProxyCompat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Camera2EncoderProfilesProvider
implements EncoderProfilesProvider {
    private static final String TAG = "Camera2EncoderProfilesProvider";
    private final boolean mHasValidCameraId;
    private final String mCameraId;
    private final int mIntCameraId;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();
    private final Quirks mCameraQuirks;

    public Camera2EncoderProfilesProvider(@NonNull String cameraId, @NonNull Quirks cameraQuirks) {
        this.mCameraId = cameraId;
        boolean hasValidCameraId = false;
        int intCameraId = -1;
        try {
            intCameraId = Integer.parseInt(cameraId);
            hasValidCameraId = true;
        }
        catch (NumberFormatException e) {
            Logger.w((String)TAG, (String)("Camera id is not an integer: " + cameraId + ", unable to create Camera2EncoderProfilesProvider"));
        }
        this.mHasValidCameraId = hasValidCameraId;
        this.mIntCameraId = intCameraId;
        this.mCameraQuirks = cameraQuirks;
    }

    public boolean hasProfile(int quality) {
        if (!this.mHasValidCameraId) {
            return false;
        }
        return this.getAll(quality) != null;
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        if (!this.mHasValidCameraId) {
            return null;
        }
        if (!CamcorderProfile.hasProfile((int)this.mIntCameraId, (int)quality)) {
            return null;
        }
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        Object profiles = this.getProfilesInternal(quality);
        if (profiles != null && !this.isEncoderProfilesResolutionValidInQuirk((EncoderProfilesProxy)profiles)) {
            profiles = quality == 1 ? this.findHighestQualityProfiles() : (quality == 0 ? this.findLowestQualityProfiles() : null);
        }
        this.mEncoderProfilesCache.put(quality, (EncoderProfilesProxy)profiles);
        return profiles;
    }

    @Nullable
    private EncoderProfilesProxy findHighestQualityProfiles() {
        Iterator iterator = QUALITY_HIGH_TO_LOW.iterator();
        while (iterator.hasNext()) {
            int quality = (Integer)iterator.next();
            EncoderProfilesProxy profiles = this.getAll(quality);
            if (profiles == null) continue;
            return profiles;
        }
        return null;
    }

    @Nullable
    private EncoderProfilesProxy findLowestQualityProfiles() {
        for (int quality = QUALITY_HIGH_TO_LOW.size() - 1; quality >= 0; --quality) {
            EncoderProfilesProxy profiles = this.getAll(quality);
            if (profiles == null) continue;
            return profiles;
        }
        return null;
    }

    @Nullable
    private EncoderProfilesProxy getProfilesInternal(int quality) {
        if (Build.VERSION.SDK_INT >= 31) {
            boolean isVideoProfilesInvalid;
            EncoderProfiles profiles = Api31Impl.getAll(this.mCameraId, quality);
            if (profiles == null) {
                return null;
            }
            boolean bl = isVideoProfilesInvalid = DeviceQuirks.get(InvalidVideoProfilesQuirk.class) != null;
            if (isVideoProfilesInvalid) {
                Logger.d((String)TAG, (String)"EncoderProfiles contains invalid video profiles, use CamcorderProfile to create EncoderProfilesProxy.");
            } else {
                try {
                    return EncoderProfilesProxyCompat.from((EncoderProfiles)profiles);
                }
                catch (NullPointerException e) {
                    Logger.w((String)TAG, (String)"Failed to create EncoderProfilesProxy, EncoderProfiles might  contain invalid video profiles. Use CamcorderProfile instead.", (Throwable)e);
                }
            }
        }
        return this.createProfilesFromCamcorderProfile(quality);
    }

    @Nullable
    private EncoderProfilesProxy createProfilesFromCamcorderProfile(int quality) {
        CamcorderProfile profile = null;
        try {
            profile = CamcorderProfile.get((int)this.mIntCameraId, (int)quality);
        }
        catch (RuntimeException e) {
            Logger.w((String)TAG, (String)("Unable to get CamcorderProfile by quality: " + quality), (Throwable)e);
        }
        return profile != null ? EncoderProfilesProxyCompat.from((CamcorderProfile)profile) : null;
    }

    private boolean isEncoderProfilesResolutionValidInQuirk(@NonNull EncoderProfilesProxy profiles) {
        CamcorderProfileResolutionQuirk camcorderProfileResolutionQuirk = (CamcorderProfileResolutionQuirk)this.mCameraQuirks.get(CamcorderProfileResolutionQuirk.class);
        if (camcorderProfileResolutionQuirk == null) {
            return true;
        }
        List videoProfiles = profiles.getVideoProfiles();
        if (videoProfiles.isEmpty()) {
            return true;
        }
        EncoderProfilesProxy.VideoProfileProxy videoProfile = (EncoderProfilesProxy.VideoProfileProxy)videoProfiles.get(0);
        return camcorderProfileResolutionQuirk.getSupportedResolutions().contains(new Size(videoProfile.getWidth(), videoProfile.getHeight()));
    }

    @RequiresApi(value=31)
    static class Api31Impl {
        static EncoderProfiles getAll(String cameraId, int quality) {
            return CamcorderProfile.getAll((String)cameraId, (int)quality);
        }

        private Api31Impl() {
        }
    }
}

