/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraCaptureResult;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.workaround.FlashAvailabilityChecker;
import androidx.camera.camera2.internal.compat.workaround.OverrideAeModeForStillCapture;
import androidx.camera.camera2.internal.compat.workaround.UseFlashModeTorchFor3aUpdate;
import androidx.camera.camera2.internal.compat.workaround.UseTorchAsFlash;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.imagecapture.CameraCapturePipeline;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConvergenceUtils;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class Camera2CapturePipeline {
    private static final String TAG = "Camera2CapturePipeline";
    @NonNull
    private final Camera2CameraControlImpl mCameraControl;
    @NonNull
    private final UseTorchAsFlash mUseTorchAsFlash;
    private final boolean mHasFlashUnit;
    @NonNull
    private final Quirks mCameraQuirk;
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final ScheduledExecutorService mScheduler;
    private final boolean mIsLegacyDevice;
    private int mTemplate = 1;

    Camera2CapturePipeline(@NonNull Camera2CameraControlImpl cameraControl, @NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull Quirks cameraQuirks, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduler) {
        this.mCameraControl = cameraControl;
        Integer level = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        this.mIsLegacyDevice = level != null && level == 2;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
        this.mCameraQuirk = cameraQuirks;
        this.mUseTorchAsFlash = new UseTorchAsFlash(cameraQuirks);
        this.mHasFlashUnit = FlashAvailabilityChecker.isFlashAvailable(cameraCharacteristics::get);
    }

    public void setTemplate(int template) {
        this.mTemplate = template;
    }

    @NonNull
    public ListenableFuture<List<Void>> submitStillCaptures(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashMode, int flashType) {
        Pipeline pipeline = this.createPipeline(captureMode, flashMode, flashType);
        return Futures.nonCancellationPropagating(pipeline.executeCapture(captureConfigs, flashMode));
    }

    @VisibleForTesting
    Pipeline createPipeline(int captureMode, int flashMode, int flashType) {
        OverrideAeModeForStillCapture aeQuirk = new OverrideAeModeForStillCapture(this.mCameraQuirk);
        Pipeline pipeline = new Pipeline(this.mTemplate, this.mExecutor, this.mScheduler, this.mCameraControl, this.mIsLegacyDevice, aeQuirk);
        if (captureMode == 0) {
            pipeline.addTask(new AfTask(this.mCameraControl));
        }
        if (flashMode == 3) {
            pipeline.addTask(new ScreenFlashTask(this.mCameraControl, this.mExecutor, this.mScheduler, new UseFlashModeTorchFor3aUpdate(this.mCameraQuirk)));
        } else if (this.mHasFlashUnit) {
            if (this.isTorchAsFlash(flashType)) {
                boolean triggerAePrecapture = !this.mUseTorchAsFlash.shouldUseTorchAsFlash() && !this.mCameraControl.isInVideoUsage();
                pipeline.addTask(new TorchTask(this.mCameraControl, flashMode, this.mExecutor, this.mScheduler, triggerAePrecapture));
            } else {
                pipeline.addTask(new AePreCaptureTask(this.mCameraControl, flashMode, aeQuirk));
            }
        }
        Logger.d((String)TAG, (String)("createPipeline: captureMode = " + captureMode + ", flashMode = " + flashMode + ", flashType = " + flashType + ", pipeline tasks = " + pipeline.mTasks));
        return pipeline;
    }

    @NonNull
    CameraCapturePipeline getCameraCapturePipeline(int captureMode, int flashMode, int flashType) {
        return new CameraCapturePipelineImpl(this.createPipeline(captureMode, flashMode, flashType), this.mExecutor, flashMode);
    }

    @NonNull
    static ListenableFuture<TotalCaptureResult> waitForResult(long timeoutNanos, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Camera2CameraControlImpl cameraControl, @Nullable ResultListener.Checker checker) {
        return Futures.makeTimeoutFuture((long)TimeUnit.NANOSECONDS.toMillis(timeoutNanos), (ScheduledExecutorService)scheduledExecutorService, null, (boolean)true, Camera2CapturePipeline.waitForResult(cameraControl, checker));
    }

    @NonNull
    static ListenableFuture<TotalCaptureResult> waitForResult(@NonNull Camera2CameraControlImpl cameraControl, @Nullable ResultListener.Checker checker) {
        ResultListener resultListener = new ResultListener(checker);
        cameraControl.addCaptureResultListener(resultListener);
        ListenableFuture<TotalCaptureResult> future = resultListener.getFuture();
        future.addListener(() -> cameraControl.removeCaptureResultListener(resultListener), cameraControl.mExecutor);
        return future;
    }

    static boolean is3AConverged(@Nullable TotalCaptureResult totalCaptureResult, boolean isTorchAsFlash) {
        if (totalCaptureResult == null) {
            return false;
        }
        Camera2CameraCaptureResult captureResult = new Camera2CameraCaptureResult((CaptureResult)totalCaptureResult);
        return ConvergenceUtils.is3AConverged((CameraCaptureResult)captureResult, (boolean)isTorchAsFlash);
    }

    static boolean isFlashRequired(int flashMode, @Nullable TotalCaptureResult result) {
        Logger.d((String)TAG, (String)("isFlashRequired: flashMode = " + flashMode));
        switch (flashMode) {
            case 1: 
            case 3: {
                return true;
            }
            case 0: {
                Integer aeState = result != null ? (Integer)result.get(CaptureResult.CONTROL_AE_STATE) : null;
                Logger.d((String)TAG, (String)("isFlashRequired: aeState = " + aeState));
                return aeState != null && aeState == 4;
            }
            case 2: {
                return false;
            }
        }
        throw new AssertionError(flashMode);
    }

    private boolean isTorchAsFlash(int flashType) {
        return this.mUseTorchAsFlash.shouldUseTorchAsFlash() || this.mTemplate == 3 || flashType == 1;
    }

    @VisibleForTesting
    static class Pipeline {
        private static final long CHECK_3A_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(1L);
        private static final long CHECK_3A_WITH_FLASH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(5L);
        private final int mTemplate;
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private final Camera2CameraControlImpl mCameraControl;
        private final OverrideAeModeForStillCapture mOverrideAeModeForStillCapture;
        private final boolean mIsLegacyDevice;
        private long mTimeout3A = CHECK_3A_TIMEOUT_IN_NS;
        final List<PipelineTask> mTasks = new ArrayList<PipelineTask>();
        private final PipelineTask mPipelineSubTask = new PipelineTask(){

            @Override
            @NonNull
            public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
                ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>();
                for (PipelineTask task : mTasks) {
                    futures.add(task.preCapture(captureResult));
                }
                return Futures.transform((ListenableFuture)Futures.allAsList(futures), results -> results.contains(true), (Executor)CameraXExecutors.directExecutor());
            }

            @Override
            public boolean isCaptureResultNeeded() {
                for (PipelineTask task : mTasks) {
                    if (!task.isCaptureResultNeeded()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void postCapture() {
                for (PipelineTask task : mTasks) {
                    task.postCapture();
                }
            }
        };

        Pipeline(int template, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduler, @NonNull Camera2CameraControlImpl cameraControl, boolean isLegacyDevice, @NonNull OverrideAeModeForStillCapture overrideAeModeForStillCapture) {
            this.mTemplate = template;
            this.mExecutor = executor;
            this.mScheduler = scheduler;
            this.mCameraControl = cameraControl;
            this.mIsLegacyDevice = isLegacyDevice;
            this.mOverrideAeModeForStillCapture = overrideAeModeForStillCapture;
        }

        void addTask(@NonNull PipelineTask task) {
            this.mTasks.add(task);
        }

        private void setTimeout3A(long timeout3A) {
            this.mTimeout3A = timeout3A;
        }

        @NonNull
        ListenableFuture<List<Void>> executeCapture(@NonNull List<CaptureConfig> captureConfigs, int flashMode) {
            FutureChain future = FutureChain.from(this.executePreCapture(flashMode)).transformAsync(v -> this.submitConfigsInternal(captureConfigs, flashMode), this.mExecutor);
            future.addListener(this::executePostCapture, this.mExecutor);
            return future;
        }

        @NonNull
        public ListenableFuture<TotalCaptureResult> executePreCapture(int flashMode) {
            ListenableFuture preCapture = Futures.immediateFuture(null);
            if (!this.mTasks.isEmpty()) {
                ListenableFuture<TotalCaptureResult> getResult = this.mPipelineSubTask.isCaptureResultNeeded() ? Camera2CapturePipeline.waitForResult(this.mCameraControl, null) : Futures.immediateFuture(null);
                preCapture = FutureChain.from(getResult).transformAsync(captureResult -> {
                    if (Camera2CapturePipeline.isFlashRequired(flashMode, captureResult)) {
                        this.setTimeout3A(CHECK_3A_WITH_FLASH_TIMEOUT_IN_NS);
                    }
                    return this.mPipelineSubTask.preCapture((TotalCaptureResult)captureResult);
                }, this.mExecutor).transformAsync(is3aConvergeRequired -> {
                    if (Boolean.TRUE.equals(is3aConvergeRequired)) {
                        return Camera2CapturePipeline.waitForResult(this.mTimeout3A, this.mScheduler, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, false));
                    }
                    return Futures.immediateFuture(null);
                }, this.mExecutor);
            }
            return preCapture;
        }

        public void executePostCapture() {
            this.mPipelineSubTask.postCapture();
        }

        @NonNull
        ListenableFuture<List<Void>> submitConfigsInternal(@NonNull List<CaptureConfig> captureConfigs, int flashMode) {
            ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>();
            ArrayList<CaptureConfig> configsToSubmit = new ArrayList<CaptureConfig>();
            for (CaptureConfig captureConfig : captureConfigs) {
                CaptureConfig.Builder configBuilder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
                CameraCaptureResult cameraCaptureResult = null;
                if (captureConfig.getTemplateType() == 5 && !this.mCameraControl.getZslControl().isZslDisabledByFlashMode() && !this.mCameraControl.getZslControl().isZslDisabledByUserCaseConfig()) {
                    boolean isSuccess;
                    ImageProxy imageProxy = this.mCameraControl.getZslControl().dequeueImageFromBuffer();
                    boolean bl = isSuccess = imageProxy != null && this.mCameraControl.getZslControl().enqueueImageToImageWriter(imageProxy);
                    if (isSuccess) {
                        cameraCaptureResult = CameraCaptureResults.retrieveCameraCaptureResult((ImageInfo)imageProxy.getImageInfo());
                    }
                }
                if (cameraCaptureResult != null) {
                    configBuilder.setCameraCaptureResult(cameraCaptureResult);
                } else {
                    this.applyStillCaptureTemplate(configBuilder, captureConfig);
                }
                if (this.mOverrideAeModeForStillCapture.shouldSetAeModeAlwaysFlash(flashMode)) {
                    this.applyAeModeQuirk(configBuilder);
                }
                futureList.add(CallbackToFutureAdapter.getFuture(completer -> {
                    configBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

                        public void onCaptureCompleted(int captureConfigId, @NonNull CameraCaptureResult result) {
                            completer.set(null);
                        }

                        public void onCaptureFailed(int captureConfigId, @NonNull CameraCaptureFailure failure) {
                            String msg = "Capture request failed with reason " + failure.getReason();
                            completer.setException((Throwable)new ImageCaptureException(2, msg, null));
                        }

                        public void onCaptureCancelled(int captureConfigId) {
                            String msg = "Capture request is cancelled because camera is closed";
                            completer.setException((Throwable)new ImageCaptureException(3, msg, null));
                        }
                    });
                    return "submitStillCapture";
                }));
                configsToSubmit.add(configBuilder.build());
            }
            this.mCameraControl.submitCaptureRequestsInternal(configsToSubmit);
            return Futures.allAsList(futureList);
        }

        private void applyStillCaptureTemplate(@NonNull CaptureConfig.Builder configBuilder, @NonNull CaptureConfig captureConfig) {
            int templateToModify = -1;
            if (this.mTemplate == 3 && !this.mIsLegacyDevice) {
                templateToModify = 4;
            } else if (captureConfig.getTemplateType() == -1 || captureConfig.getTemplateType() == 5) {
                templateToModify = 2;
            }
            if (templateToModify != -1) {
                configBuilder.setTemplateType(templateToModify);
            }
        }

        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        private void applyAeModeQuirk(@NonNull CaptureConfig.Builder configBuilder) {
            Camera2ImplConfig.Builder impBuilder = new Camera2ImplConfig.Builder();
            impBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, 3);
            configBuilder.addImplementationOptions((Config)impBuilder.build());
        }
    }

    static class AfTask
    implements PipelineTask {
        private final Camera2CameraControlImpl mCameraControl;
        private boolean mIsExecuted = false;

        AfTask(@NonNull Camera2CameraControlImpl cameraControl) {
            this.mCameraControl = cameraControl;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            ListenableFuture ret = Futures.immediateFuture((Object)true);
            if (captureResult == null) {
                return ret;
            }
            Integer afMode = (Integer)captureResult.get(CaptureResult.CONTROL_AF_MODE);
            if (afMode == null) {
                return ret;
            }
            switch (afMode) {
                case 1: 
                case 2: {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"TriggerAf? AF mode auto");
                    Integer afState = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null || afState != 0) break;
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Trigger AF");
                    this.mIsExecuted = true;
                    this.mCameraControl.getFocusMeteringControl().triggerAf(null, false);
                    return ret;
                }
            }
            return ret;
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return true;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"cancel TriggerAF");
                this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(true, false);
            }
        }
    }

    static interface PipelineTask {
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult var1);

        public boolean isCaptureResultNeeded();

        public void postCapture();
    }

    static class ScreenFlashTask
    implements PipelineTask {
        private static final long CHECK_3A_WITH_SCREEN_FLASH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(2L);
        private final Camera2CameraControlImpl mCameraControl;
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private final ImageCapture.ScreenFlash mScreenFlash;
        private final UseFlashModeTorchFor3aUpdate mUseFlashModeTorchFor3aUpdate;

        ScreenFlashTask(@NonNull Camera2CameraControlImpl cameraControl, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduler, @NonNull UseFlashModeTorchFor3aUpdate useFlashModeTorchFor3aUpdate) {
            this.mCameraControl = cameraControl;
            this.mExecutor = executor;
            this.mScheduler = scheduler;
            this.mUseFlashModeTorchFor3aUpdate = useFlashModeTorchFor3aUpdate;
            this.mScreenFlash = Objects.requireNonNull(this.mCameraControl.getScreenFlash());
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture");
            AtomicReference screenFlashListener = new AtomicReference();
            ListenableFuture uiAppliedFuture = CallbackToFutureAdapter.getFuture(completer -> {
                screenFlashListener.set(() -> {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: UI change applied");
                    completer.set(null);
                });
                return "OnScreenFlashUiApplied";
            });
            ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: invoking applyScreenFlashUi");
                    this.mScreenFlash.apply(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(3L), (ImageCapture.ScreenFlashListener)screenFlashListener.get());
                    completer.set(null);
                });
                return "OnScreenFlashStart";
            });
            return FutureChain.from((ListenableFuture)future).transformAsync(input -> this.mCameraControl.getFocusMeteringControl().enableExternalFlashAeMode(true), this.mExecutor).transformAsync(input -> CallbackToFutureAdapter.getFuture(completer -> {
                if (!this.mUseFlashModeTorchFor3aUpdate.shouldUseFlashModeTorch()) {
                    completer.set(null);
                    return "EnableTorchInternal";
                }
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#preCapture: enable torch");
                this.mCameraControl.enableTorchInternal(true);
                completer.set(null);
                return "EnableTorchInternal";
            }), this.mExecutor).transformAsync(input -> Futures.makeTimeoutFuture((long)TimeUnit.SECONDS.toMillis(3L), (ScheduledExecutorService)this.mScheduler, null, (boolean)true, (ListenableFuture)uiAppliedFuture), this.mExecutor).transformAsync(input -> this.mCameraControl.getFocusMeteringControl().triggerAePrecapture(), this.mExecutor).transformAsync(input -> Camera2CapturePipeline.waitForResult(CHECK_3A_WITH_SCREEN_FLASH_TIMEOUT_IN_NS, this.mScheduler, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, false)), this.mExecutor).transform(input -> false, CameraXExecutors.directExecutor());
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return false;
        }

        @Override
        public void postCapture() {
            Logger.d((String)Camera2CapturePipeline.TAG, (String)"ScreenFlashTask#postCapture");
            if (this.mUseFlashModeTorchFor3aUpdate.shouldUseFlashModeTorch()) {
                this.mCameraControl.enableTorchInternal(false);
            }
            this.mCameraControl.getFocusMeteringControl().enableExternalFlashAeMode(false).addListener(() -> Log.d((String)Camera2CapturePipeline.TAG, (String)"enableExternalFlashAeMode disabled"), this.mExecutor);
            this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(false, true);
            CameraXExecutors.mainThreadExecutor().execute(() -> ((ImageCapture.ScreenFlash)this.mScreenFlash).clear());
        }
    }

    static class TorchTask
    implements PipelineTask {
        private static final long CHECK_3A_WITH_TORCH_TIMEOUT_IN_NS = TimeUnit.SECONDS.toNanos(2L);
        private final Camera2CameraControlImpl mCameraControl;
        private final int mFlashMode;
        private boolean mIsExecuted = false;
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private final boolean mTriggerAePrecapture;

        TorchTask(@NonNull Camera2CameraControlImpl cameraControl, int flashMode, @NonNull Executor executor, ScheduledExecutorService scheduler, boolean triggerAePrecapture) {
            this.mCameraControl = cameraControl;
            this.mFlashMode = flashMode;
            this.mExecutor = executor;
            this.mScheduler = scheduler;
            this.mTriggerAePrecapture = triggerAePrecapture;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            boolean isFlashRequired = Camera2CapturePipeline.isFlashRequired(this.mFlashMode, captureResult);
            Logger.d((String)Camera2CapturePipeline.TAG, (String)("TorchTask#preCapture: isFlashRequired = " + isFlashRequired));
            if (Camera2CapturePipeline.isFlashRequired(this.mFlashMode, captureResult)) {
                if (this.mCameraControl.isTorchOn()) {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Torch already on, not turn on");
                } else {
                    Logger.d((String)Camera2CapturePipeline.TAG, (String)"Turn on torch");
                    this.mIsExecuted = true;
                    ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                        this.mCameraControl.getTorchControl().enableTorchInternal((CallbackToFutureAdapter.Completer<Void>)completer, true);
                        return "TorchOn";
                    });
                    return FutureChain.from((ListenableFuture)future).transformAsync(input -> {
                        if (this.mTriggerAePrecapture) {
                            return this.mCameraControl.getFocusMeteringControl().triggerAePrecapture();
                        }
                        return Futures.immediateFuture(null);
                    }, this.mExecutor).transformAsync(input -> Camera2CapturePipeline.waitForResult(CHECK_3A_WITH_TORCH_TIMEOUT_IN_NS, this.mScheduler, this.mCameraControl, result -> Camera2CapturePipeline.is3AConverged(result, true)), this.mExecutor).transform(input -> false, CameraXExecutors.directExecutor());
                }
            }
            return Futures.immediateFuture((Object)false);
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return this.mFlashMode == 0;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                this.mCameraControl.getTorchControl().enableTorchInternal(null, false);
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"Turning off torch");
                if (this.mTriggerAePrecapture) {
                    this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(false, true);
                }
            }
        }
    }

    static class AePreCaptureTask
    implements PipelineTask {
        private final Camera2CameraControlImpl mCameraControl;
        private final OverrideAeModeForStillCapture mOverrideAeModeForStillCapture;
        private final int mFlashMode;
        private boolean mIsExecuted = false;

        AePreCaptureTask(@NonNull Camera2CameraControlImpl cameraControl, int flashMode, @NonNull OverrideAeModeForStillCapture overrideAeModeForStillCapture) {
            this.mCameraControl = cameraControl;
            this.mFlashMode = flashMode;
            this.mOverrideAeModeForStillCapture = overrideAeModeForStillCapture;
        }

        @Override
        @NonNull
        public ListenableFuture<Boolean> preCapture(@Nullable TotalCaptureResult captureResult) {
            if (Camera2CapturePipeline.isFlashRequired(this.mFlashMode, captureResult)) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"Trigger AE");
                this.mIsExecuted = true;
                ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                    this.mCameraControl.getFocusMeteringControl().triggerAePrecapture((CallbackToFutureAdapter.Completer<Void>)completer);
                    this.mOverrideAeModeForStillCapture.onAePrecaptureStarted();
                    return "AePreCapture";
                });
                return FutureChain.from((ListenableFuture)future).transform(input -> true, CameraXExecutors.directExecutor());
            }
            return Futures.immediateFuture((Object)false);
        }

        @Override
        public boolean isCaptureResultNeeded() {
            return this.mFlashMode == 0;
        }

        @Override
        public void postCapture() {
            if (this.mIsExecuted) {
                Logger.d((String)Camera2CapturePipeline.TAG, (String)"cancel TriggerAePreCapture");
                this.mCameraControl.getFocusMeteringControl().cancelAfAeTrigger(false, true);
                this.mOverrideAeModeForStillCapture.onAePrecaptureFinished();
            }
        }
    }

    static class CameraCapturePipelineImpl
    implements CameraCapturePipeline {
        private final Executor mExecutor;
        private final Pipeline mPipelineDelegate;
        private int mFlashMode;

        CameraCapturePipelineImpl(Pipeline pipeline, Executor executor, int flashMode) {
            this.mPipelineDelegate = pipeline;
            this.mExecutor = executor;
            this.mFlashMode = flashMode;
        }

        @NonNull
        public ListenableFuture<Void> invokePreCapture() {
            Logger.d((String)Camera2CapturePipeline.TAG, (String)"invokePreCapture");
            return FutureChain.from(this.mPipelineDelegate.executePreCapture(this.mFlashMode)).transform(result -> null, this.mExecutor);
        }

        @NonNull
        public ListenableFuture<Void> invokePostCapture() {
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.mPipelineDelegate.executePostCapture();
                completer.set(null);
                return "invokePostCaptureFuture";
            });
        }
    }

    static class ResultListener
    implements Camera2CameraControlImpl.CaptureResultListener {
        private CallbackToFutureAdapter.Completer<TotalCaptureResult> mCompleter;
        private final ListenableFuture<TotalCaptureResult> mFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCompleter = completer;
            return "waitFor3AResult";
        });
        private final Checker mChecker;

        ResultListener(@Nullable Checker checker) {
            this.mChecker = checker;
        }

        @NonNull
        public ListenableFuture<TotalCaptureResult> getFuture() {
            return this.mFuture;
        }

        @Override
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            if (this.mChecker != null && !this.mChecker.check(captureResult)) {
                return false;
            }
            this.mCompleter.set((Object)captureResult);
            return true;
        }

        static interface Checker {
            public boolean check(@NonNull TotalCaptureResult var1);
        }
    }
}

