/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.media.CamcorderProfile;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.AutoValue_Camera2CameraImpl_UseCaseInfo;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.CameraDeviceStateCallbacks;
import androidx.camera.camera2.internal.CameraStateMachine;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.camera2.internal.CaptureSessionInterface;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.MeteringRepeatingSession;
import androidx.camera.camera2.internal.ProcessingCaptureSession;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.compat.ApiCompat;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompat;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.LegacyCameraOutputConfigNullPointerQuirk;
import androidx.camera.camera2.internal.compat.quirk.LegacyCameraSurfaceCleanupQuirk;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraState;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraStateRegistry;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseAttachState;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.tracing.Trace;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class Camera2CameraImpl
implements CameraInternal {
    private static final String TAG = "Camera2CameraImpl";
    private static final int ERROR_NONE = 0;
    private final UseCaseAttachState mUseCaseAttachState;
    private final CameraManagerCompat mCameraManager;
    private final Executor mExecutor;
    private final ScheduledExecutorService mScheduledExecutorService;
    volatile InternalState mState = InternalState.INITIALIZED;
    private final LiveDataObservable<CameraInternal.State> mObservableState = new LiveDataObservable();
    private final CameraStateMachine mCameraStateMachine;
    private final Camera2CameraControlImpl mCameraControlInternal;
    private final StateCallback mStateCallback;
    @NonNull
    final Camera2CameraInfoImpl mCameraInfoInternal;
    @Nullable
    CameraDevice mCameraDevice;
    int mCameraDeviceError = 0;
    CaptureSessionInterface mCaptureSession;
    final AtomicInteger mReleaseRequestCount = new AtomicInteger(0);
    ListenableFuture<Void> mUserReleaseFuture;
    CallbackToFutureAdapter.Completer<Void> mUserReleaseNotifier;
    final Map<CaptureSessionInterface, ListenableFuture<Void>> mReleasedCaptureSessions = new LinkedHashMap<CaptureSessionInterface, ListenableFuture<Void>>();
    private int mTraceStateErrorCount = 0;
    @NonNull
    final CameraAvailability mCameraAvailability;
    @NonNull
    final CameraConfigureAvailable mCameraConfigureAvailable;
    @NonNull
    final CameraCoordinator mCameraCoordinator;
    @NonNull
    final CameraStateRegistry mCameraStateRegistry;
    private final boolean mCloseCameraBeforeCreateNewSessionQuirk;
    private final boolean mConfigAndCloseQuirk;
    private boolean mIsConfigAndCloseRequired = false;
    private boolean mIsConfiguringForClose = false;
    private boolean mIsPrimary = true;
    private MeteringRepeatingSession mMeteringRepeatingSession;
    @NonNull
    private final CaptureSessionRepository mCaptureSessionRepository;
    @NonNull
    private final SynchronizedCaptureSession.OpenerBuilder mCaptureSessionOpenerBuilder;
    private final Set<String> mNotifyStateAttachedSet = new HashSet<String>();
    @NonNull
    private CameraConfig mCameraConfig = CameraConfigs.defaultConfig();
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private SessionProcessor mSessionProcessor;
    boolean mIsActiveResumingMode = false;
    @NonNull
    private final DisplayInfoManager mDisplayInfoManager;
    @NonNull
    private final CameraCharacteristicsCompat mCameraCharacteristicsCompat;
    @NonNull
    private final DynamicRangesCompat mDynamicRangesCompat;
    @NonNull
    private final SupportedSurfaceCombination mSupportedSurfaceCombination;
    private final ErrorTimeoutReopenScheduler mErrorTimeoutReopenScheduler = new ErrorTimeoutReopenScheduler();

    Camera2CameraImpl(@NonNull Context context, @NonNull CameraManagerCompat cameraManager, @NonNull String cameraId, @NonNull Camera2CameraInfoImpl cameraInfoImpl, @NonNull CameraCoordinator cameraCoordinator, @NonNull CameraStateRegistry cameraStateRegistry, @NonNull Executor executor, @NonNull Handler schedulerHandler, @NonNull DisplayInfoManager displayInfoManager, long cameraOpenRetryMaxTimeoutInMs) throws CameraUnavailableException {
        this.mCameraManager = cameraManager;
        this.mCameraCoordinator = cameraCoordinator;
        this.mCameraStateRegistry = cameraStateRegistry;
        this.mScheduledExecutorService = CameraXExecutors.newHandlerExecutor((Handler)schedulerHandler);
        this.mExecutor = CameraXExecutors.newSequentialExecutor((Executor)executor);
        this.mStateCallback = new StateCallback(this.mExecutor, this.mScheduledExecutorService, cameraOpenRetryMaxTimeoutInMs);
        this.mUseCaseAttachState = new UseCaseAttachState(cameraId);
        this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
        this.mCameraStateMachine = new CameraStateMachine(cameraStateRegistry);
        this.mCaptureSessionRepository = new CaptureSessionRepository(this.mExecutor);
        this.mDisplayInfoManager = displayInfoManager;
        try {
            this.mCameraCharacteristicsCompat = this.mCameraManager.getCameraCharacteristicsCompat(cameraId);
            this.mCameraControlInternal = new Camera2CameraControlImpl(this.mCameraCharacteristicsCompat, this.mScheduledExecutorService, this.mExecutor, new ControlUpdateListenerInternal(), cameraInfoImpl.getCameraQuirks());
            this.mCameraInfoInternal = cameraInfoImpl;
            this.mCameraInfoInternal.linkWithCameraControl(this.mCameraControlInternal);
            this.mCameraInfoInternal.setCameraStateSource(this.mCameraStateMachine.getStateLiveData());
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
        this.mDynamicRangesCompat = DynamicRangesCompat.fromCameraCharacteristics(this.mCameraCharacteristicsCompat);
        this.mCaptureSession = this.newCaptureSession();
        this.mCaptureSessionOpenerBuilder = new SynchronizedCaptureSession.OpenerBuilder(this.mExecutor, this.mScheduledExecutorService, schedulerHandler, this.mCaptureSessionRepository, cameraInfoImpl.getCameraQuirks(), DeviceQuirks.getAll());
        this.mCloseCameraBeforeCreateNewSessionQuirk = cameraInfoImpl.getCameraQuirks().contains(LegacyCameraOutputConfigNullPointerQuirk.class);
        this.mConfigAndCloseQuirk = cameraInfoImpl.getCameraQuirks().contains(LegacyCameraSurfaceCleanupQuirk.class);
        this.mCameraAvailability = new CameraAvailability(cameraId);
        this.mCameraConfigureAvailable = new CameraConfigureAvailable();
        this.mCameraStateRegistry.registerCamera((Camera)this, this.mExecutor, (CameraStateRegistry.OnConfigureAvailableListener)this.mCameraConfigureAvailable, (CameraStateRegistry.OnOpenAvailableListener)this.mCameraAvailability);
        this.mCameraManager.registerAvailabilityCallback(this.mExecutor, this.mCameraAvailability);
        this.mSupportedSurfaceCombination = new SupportedSurfaceCombination(context, cameraId, cameraManager, new CamcorderProfileHelper(){

            @Override
            public boolean hasProfile(int cameraId, int quality) {
                return CamcorderProfile.hasProfile((int)cameraId, (int)quality);
            }

            @Override
            public CamcorderProfile get(int cameraId, int quality) {
                return CamcorderProfile.get((int)cameraId, (int)quality);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private CaptureSessionInterface newCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionProcessor == null) {
                return new CaptureSession(this.mDynamicRangesCompat, this.mCameraInfoInternal.getCameraQuirks());
            }
            return new ProcessingCaptureSession(this.mSessionProcessor, this.mCameraInfoInternal, this.mDynamicRangesCompat, this.mExecutor, this.mScheduledExecutorService);
        }
    }

    public void open() {
        this.mExecutor.execute(this::openInternal);
    }

    private void openInternal() {
        switch (this.mState.ordinal()) {
            case 2: 
            case 3: {
                this.tryForceOpenCameraDevice(false);
                break;
            }
            case 4: {
                this.setState(InternalState.REOPENING);
                if (this.isSessionCloseComplete() || this.mIsConfiguringForClose || this.mCameraDeviceError != 0) break;
                Preconditions.checkState((this.mCameraDevice != null ? 1 : 0) != 0, (String)"Camera Device should be open if session close is not complete");
                this.setState(InternalState.OPENED);
                this.openCaptureSession();
                break;
            }
            default: {
                this.debugLog("open() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
    }

    public void close() {
        this.mExecutor.execute(this::closeInternal);
    }

    private void closeInternal() {
        this.debugLog("Closing camera.");
        switch (this.mState.ordinal()) {
            case 8: 
            case 9: {
                this.setState(InternalState.CLOSING);
                this.closeCamera(false);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                boolean canFinish = this.mStateCallback.cancelScheduledReopen() || this.mErrorTimeoutReopenScheduler.isErrorHandling();
                this.mErrorTimeoutReopenScheduler.cancel();
                this.setState(InternalState.CLOSING);
                if (!canFinish) break;
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.configAndCloseIfNeeded();
                break;
            }
            case 3: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.INITIALIZED);
                break;
            }
            default: {
                this.debugLog("close() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
    }

    private void configAndCloseIfNeeded() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        if (!this.mIsConfigAndCloseRequired) {
            this.finishClose();
            return;
        }
        if (this.mIsConfiguringForClose) {
            this.debugLog("Ignored since configAndClose is processing");
            return;
        }
        if (!this.mCameraAvailability.isCameraAvailable()) {
            this.mIsConfigAndCloseRequired = false;
            this.finishClose();
            this.debugLog("Ignore configAndClose and finish the close flow directly since camera is unavailable.");
            return;
        }
        this.debugLog("Open camera to configAndClose");
        ListenableFuture<Void> configAndCloseFuture = this.openCameraConfigAndClose();
        this.mIsConfiguringForClose = true;
        configAndCloseFuture.addListener(() -> {
            this.mIsConfiguringForClose = false;
            this.mIsConfigAndCloseRequired = false;
            this.debugLog("OpenCameraConfigAndClose is done, state: " + (Object)((Object)this.mState));
            switch (this.mState.ordinal()) {
                case 6: {
                    if (this.mCameraDeviceError != 0) {
                        this.debugLog("OpenCameraConfigAndClose in error: " + Camera2CameraImpl.getErrorMessage(this.mCameraDeviceError));
                        this.mStateCallback.scheduleCameraReopen();
                        break;
                    }
                    this.tryOpenCameraDevice(false);
                    break;
                }
                case 1: 
                case 4: {
                    Preconditions.checkState((boolean)this.isSessionCloseComplete());
                    this.finishClose();
                    break;
                }
                default: {
                    this.debugLog("OpenCameraConfigAndClose finished while in state: " + (Object)((Object)this.mState));
                }
            }
        }, this.mExecutor);
    }

    @SuppressLint(value={"MissingPermission"})
    @NonNull
    private ListenableFuture<Void> openCameraConfigAndClose() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            try {
                SessionConfig config = this.mUseCaseAttachState.getAttachedBuilder().build();
                ArrayList<CameraDevice.StateCallback> allStateCallbacks = new ArrayList<CameraDevice.StateCallback>(config.getDeviceStateCallbacks());
                allStateCallbacks.add(this.mCaptureSessionRepository.getCameraStateCallback());
                allStateCallbacks.add(new CameraDevice.StateCallback(){

                    public void onOpened(@NonNull CameraDevice camera) {
                        Camera2CameraImpl.this.debugLog("openCameraConfigAndClose camera opened");
                        Camera2CameraImpl.this.configAndClose(camera).addListener(() -> ((CameraDevice)camera).close(), Camera2CameraImpl.this.mExecutor);
                    }

                    public void onDisconnected(@NonNull CameraDevice camera) {
                        Camera2CameraImpl.this.debugLog("openCameraConfigAndClose camera disconnected");
                        completer.set(null);
                    }

                    public void onError(@NonNull CameraDevice camera, int error) {
                        Camera2CameraImpl.this.debugLog("openCameraConfigAndClose camera error " + error);
                        completer.set(null);
                    }

                    public void onClosed(@NonNull CameraDevice camera) {
                        Camera2CameraImpl.this.debugLog("openCameraConfigAndClose camera closed");
                        completer.set(null);
                    }
                });
                this.mCameraManager.openCamera(this.mCameraInfoInternal.getCameraId(), this.mExecutor, CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks));
            }
            catch (CameraAccessExceptionCompat | SecurityException e) {
                this.debugLog("Unable to open camera for configAndClose: " + e.getMessage(), e);
                completer.setException((Throwable)e);
            }
            return "configAndCloseTask";
        });
    }

    @NonNull
    private ListenableFuture<Void> configAndClose(@NonNull CameraDevice cameraDevice) {
        CaptureSession noOpSession = new CaptureSession(this.mDynamicRangesCompat);
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(640, 480);
        Surface surface = new Surface(surfaceTexture);
        ImmediateSurface deferrableSurface = new ImmediateSurface(surface);
        deferrableSurface.getTerminationFuture().addListener(() -> {
            surface.release();
            surfaceTexture.release();
        }, CameraXExecutors.directExecutor());
        SessionConfig.Builder builder = new SessionConfig.Builder();
        builder.addNonRepeatingSurface((DeferrableSurface)deferrableSurface);
        builder.setTemplateType(1);
        this.debugLog("Start configAndClose.");
        ListenableFuture<Void> openSessionFuture = noOpSession.open(builder.build(), cameraDevice, this.mCaptureSessionOpenerBuilder.build());
        return FutureChain.from((ListenableFuture)Futures.transformAsyncOnCompletion(openSessionFuture)).transformAsync(arg_0 -> Camera2CameraImpl.lambda$configAndClose$3(noOpSession, (DeferrableSurface)deferrableSurface, arg_0), this.mExecutor);
    }

    boolean isSessionCloseComplete() {
        return this.mReleasedCaptureSessions.isEmpty();
    }

    void finishClose() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        this.mCameraDevice = null;
        if (this.mState == InternalState.CLOSING) {
            this.setState(InternalState.INITIALIZED);
        } else {
            this.mCameraManager.unregisterAvailabilityCallback(this.mCameraAvailability);
            this.setState(InternalState.RELEASED);
            if (this.mUserReleaseNotifier != null) {
                this.mUserReleaseNotifier.set(null);
                this.mUserReleaseNotifier = null;
            }
        }
    }

    void closeCamera(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mState == InternalState.CLOSING || this.mState == InternalState.RELEASING || this.mState == InternalState.REOPENING && this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)("closeCamera should only be called in a CLOSING, RELEASING or REOPENING (with error) state. Current state: " + (Object)((Object)this.mState) + " (error: " + Camera2CameraImpl.getErrorMessage(this.mCameraDeviceError) + ")"));
        this.resetCaptureSession(abortInFlightCaptures);
        this.mCaptureSession.cancelIssuedCaptureRequests();
    }

    @NonNull
    public ListenableFuture<Void> release() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> Futures.propagate(this.releaseInternal(), (CallbackToFutureAdapter.Completer)completer));
            return "Release[request=" + this.mReleaseRequestCount.getAndIncrement() + "]";
        });
    }

    private ListenableFuture<Void> releaseInternal() {
        ListenableFuture<Void> future = this.getOrCreateUserReleaseFuture();
        switch (this.mState.ordinal()) {
            case 2: 
            case 3: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.RELEASING);
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.configAndCloseIfNeeded();
                break;
            }
            case 8: 
            case 9: {
                this.setState(InternalState.RELEASING);
                this.closeCamera(false);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                boolean canFinish = this.mStateCallback.cancelScheduledReopen() || this.mErrorTimeoutReopenScheduler.isErrorHandling();
                this.mErrorTimeoutReopenScheduler.cancel();
                this.setState(InternalState.RELEASING);
                if (!canFinish) break;
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.configAndCloseIfNeeded();
                break;
            }
            default: {
                this.debugLog("release() ignored due to being in state: " + (Object)((Object)this.mState));
            }
        }
        return future;
    }

    private ListenableFuture<Void> getOrCreateUserReleaseFuture() {
        if (this.mUserReleaseFuture == null) {
            this.mUserReleaseFuture = this.mState != InternalState.RELEASED ? CallbackToFutureAdapter.getFuture(completer -> {
                Preconditions.checkState((this.mUserReleaseNotifier == null ? 1 : 0) != 0, (String)"Camera can only be released once, so release completer should be null on creation.");
                this.mUserReleaseNotifier = completer;
                return "Release[camera=" + this + "]";
            }) : Futures.immediateFuture(null);
        }
        return this.mUserReleaseFuture;
    }

    ListenableFuture<Void> releaseSession(final @NonNull CaptureSessionInterface captureSession, boolean abortInFlightCaptures) {
        captureSession.close();
        ListenableFuture<Void> releaseFuture = captureSession.release(abortInFlightCaptures);
        this.debugLog("Releasing session in state " + this.mState.name());
        this.mReleasedCaptureSessions.put(captureSession, releaseFuture);
        Futures.addCallback(releaseFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.mReleasedCaptureSessions.remove(captureSession);
                switch (Camera2CameraImpl.this.mState.ordinal()) {
                    case 6: {
                        if (Camera2CameraImpl.this.mCameraDeviceError == 0) break;
                    }
                    case 5: {
                        Camera2CameraImpl.this.debugLog("Camera reopen required. Checking if the current camera can be closed safely.");
                    }
                    case 1: 
                    case 4: {
                        if (!Camera2CameraImpl.this.isSessionCloseComplete() || Camera2CameraImpl.this.mCameraDevice == null) break;
                        Camera2CameraImpl.this.debugLog("closing camera");
                        ApiCompat.Api21Impl.close(Camera2CameraImpl.this.mCameraDevice);
                        Camera2CameraImpl.this.mCameraDevice = null;
                        break;
                    }
                }
            }

            public void onFailure(@NonNull Throwable t) {
            }
        }, (Executor)CameraXExecutors.directExecutor());
        return releaseFuture;
    }

    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mObservableState;
    }

    public void onUseCaseActive(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        SessionConfig sessionConfig = this.mIsPrimary ? useCase.getSessionConfig() : useCase.getSecondarySessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        StreamSpec streamSpec = useCase.getAttachedStreamSpec();
        List<UseCaseConfigFactory.CaptureType> captureTypes = Camera2CameraImpl.getCaptureTypes(useCase);
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " ACTIVE");
            this.mUseCaseAttachState.setUseCaseActive(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " INACTIVE");
            this.mUseCaseAttachState.setUseCaseInactive(useCaseId);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
        SessionConfig sessionConfig = this.mIsPrimary ? useCase.getSessionConfig() : useCase.getSecondarySessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        StreamSpec streamSpec = useCase.getAttachedStreamSpec();
        List<UseCaseConfigFactory.CaptureType> captureTypes = Camera2CameraImpl.getCaptureTypes(useCase);
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " UPDATED");
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
            this.updateCaptureSessionConfig();
        });
    }

    public void onUseCaseReset(@NonNull UseCase useCase) {
        Preconditions.checkNotNull((Object)useCase);
        SessionConfig sessionConfig = this.mIsPrimary ? useCase.getSessionConfig() : useCase.getSecondarySessionConfig();
        UseCaseConfig useCaseConfig = useCase.getCurrentConfig();
        StreamSpec streamSpec = useCase.getAttachedStreamSpec();
        List<UseCaseConfigFactory.CaptureType> captureTypes = Camera2CameraImpl.getCaptureTypes(useCase);
        this.resetUseCase(Camera2CameraImpl.getUseCaseId(useCase), sessionConfig, useCaseConfig, streamSpec, captureTypes);
    }

    private void resetUseCase(@NonNull String useCaseId, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
        this.mExecutor.execute(() -> {
            this.debugLog("Use case " + useCaseId + " RESET");
            this.mUseCaseAttachState.updateUseCase(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
            this.addOrRemoveMeteringRepeatingUseCase();
            this.resetCaptureSession(false);
            this.updateCaptureSessionConfig();
            if (this.mState == InternalState.OPENED) {
                this.openCaptureSession();
            }
        });
    }

    @VisibleForTesting
    boolean isUseCaseAttached(@NonNull UseCase useCase) {
        try {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            return (Boolean)CallbackToFutureAdapter.getFuture(completer -> {
                try {
                    this.mExecutor.execute(() -> completer.set((Object)this.mUseCaseAttachState.isUseCaseAttached(useCaseId)));
                }
                catch (RejectedExecutionException e) {
                    completer.setException((Throwable)new RuntimeException("Unable to check if use case is attached. Camera executor shut down."));
                }
                return "isUseCaseAttached";
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to check if use case is attached.", e);
        }
    }

    @VisibleForTesting
    boolean isMeteringRepeatingAttached() {
        try {
            return (Boolean)CallbackToFutureAdapter.getFuture(completer -> {
                try {
                    this.mExecutor.execute(() -> {
                        if (this.mMeteringRepeatingSession == null) {
                            completer.set((Object)false);
                            return;
                        }
                        String id = Camera2CameraImpl.getMeteringRepeatingId(this.mMeteringRepeatingSession);
                        completer.set((Object)this.mUseCaseAttachState.isUseCaseAttached(id));
                    });
                }
                catch (RejectedExecutionException e) {
                    completer.setException((Throwable)new RuntimeException("Unable to check if MeteringRepeating is attached. Camera executor shut down."));
                }
                return "isMeteringRepeatingAttached";
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to check if MeteringRepeating is attached.", e);
        }
    }

    public void attachUseCases(@NonNull Collection<UseCase> inputUseCases) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(inputUseCases);
        if (useCases.isEmpty()) {
            return;
        }
        this.mCameraControlInternal.incrementUseCount();
        this.notifyStateAttachedAndCameraControlReady(new ArrayList<UseCase>(useCases));
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>(this.toUseCaseInfos(useCases));
        try {
            this.mExecutor.execute(() -> {
                try {
                    this.tryAttachUseCases(useCaseInfos);
                }
                finally {
                    this.mCameraControlInternal.decrementUseCount();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.debugLog("Unable to attach use cases.", e);
            this.mCameraControlInternal.decrementUseCount();
        }
    }

    private void tryAttachUseCases(@NonNull Collection<UseCaseInfo> useCaseInfos) {
        boolean attachUseCaseFromEmpty = this.mUseCaseAttachState.getAttachedSessionConfigs().isEmpty();
        ArrayList<String> useCaseIdsToAttach = new ArrayList<String>();
        Rational previewAspectRatio = null;
        for (UseCaseInfo useCaseInfo : useCaseInfos) {
            Size resolution;
            if (this.mUseCaseAttachState.isUseCaseAttached(useCaseInfo.getUseCaseId())) continue;
            this.mUseCaseAttachState.setUseCaseAttached(useCaseInfo.getUseCaseId(), useCaseInfo.getSessionConfig(), useCaseInfo.getUseCaseConfig(), useCaseInfo.getStreamSpec(), useCaseInfo.getCaptureTypes());
            useCaseIdsToAttach.add(useCaseInfo.getUseCaseId());
            if (useCaseInfo.getUseCaseType() != Preview.class || (resolution = useCaseInfo.getSurfaceResolution()) == null) continue;
            previewAspectRatio = new Rational(resolution.getWidth(), resolution.getHeight());
        }
        if (useCaseIdsToAttach.isEmpty()) {
            return;
        }
        this.debugLog("Use cases [" + TextUtils.join((CharSequence)", ", useCaseIdsToAttach) + "] now ATTACHED");
        if (attachUseCaseFromEmpty) {
            this.mCameraControlInternal.setActive(true);
            this.mCameraControlInternal.incrementUseCount();
        }
        this.addOrRemoveMeteringRepeatingUseCase();
        this.updateZslDisabledByUseCaseConfigStatus();
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        } else {
            this.openInternal();
        }
        if (previewAspectRatio != null) {
            this.mCameraControlInternal.setPreviewAspectRatio(previewAspectRatio);
        }
    }

    @NonNull
    private Collection<UseCaseInfo> toUseCaseInfos(@NonNull Collection<UseCase> useCases) {
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>();
        for (UseCase useCase : useCases) {
            useCaseInfos.add(UseCaseInfo.from(useCase, this.mIsPrimary));
        }
        return useCaseInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
        cameraConfig = cameraConfig != null ? cameraConfig : CameraConfigs.defaultConfig();
        SessionProcessor sessionProcessor = cameraConfig.getSessionProcessor(null);
        this.mCameraConfig = cameraConfig;
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionProcessor = sessionProcessor;
        }
    }

    @NonNull
    public CameraConfig getExtendedConfig() {
        return this.mCameraConfig;
    }

    private void notifyStateAttachedAndCameraControlReady(List<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            if (this.mNotifyStateAttachedSet.contains(useCaseId)) continue;
            this.mNotifyStateAttachedSet.add(useCaseId);
            useCase.onStateAttached();
            useCase.onCameraControlReady();
        }
    }

    private void notifyStateDetachedToUseCases(List<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            String useCaseId = Camera2CameraImpl.getUseCaseId(useCase);
            if (!this.mNotifyStateAttachedSet.contains(useCaseId)) continue;
            useCase.onStateDetached();
            this.mNotifyStateAttachedSet.remove(useCaseId);
        }
    }

    public void detachUseCases(@NonNull Collection<UseCase> inputUseCases) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(inputUseCases);
        if (useCases.isEmpty()) {
            return;
        }
        ArrayList<UseCaseInfo> useCaseInfos = new ArrayList<UseCaseInfo>(this.toUseCaseInfos(useCases));
        this.notifyStateDetachedToUseCases(new ArrayList<UseCase>(useCases));
        this.mExecutor.execute(() -> this.tryDetachUseCases(useCaseInfos));
    }

    private void tryDetachUseCases(@NonNull Collection<UseCaseInfo> useCaseInfos) {
        ArrayList<String> useCaseIdsToDetach = new ArrayList<String>();
        boolean clearPreviewAspectRatio = false;
        for (UseCaseInfo useCaseInfo : useCaseInfos) {
            if (!this.mUseCaseAttachState.isUseCaseAttached(useCaseInfo.getUseCaseId())) continue;
            this.mUseCaseAttachState.removeUseCase(useCaseInfo.getUseCaseId());
            useCaseIdsToDetach.add(useCaseInfo.getUseCaseId());
            if (useCaseInfo.getUseCaseType() != Preview.class) continue;
            clearPreviewAspectRatio = true;
        }
        if (useCaseIdsToDetach.isEmpty()) {
            return;
        }
        this.debugLog("Use cases [" + TextUtils.join((CharSequence)", ", useCaseIdsToDetach) + "] now DETACHED for camera");
        if (clearPreviewAspectRatio) {
            this.mCameraControlInternal.setPreviewAspectRatio(null);
        }
        this.addOrRemoveMeteringRepeatingUseCase();
        if (this.mUseCaseAttachState.getAttachedUseCaseConfigs().isEmpty()) {
            this.mCameraControlInternal.setZslDisabledByUserCaseConfig(false);
        } else {
            this.updateZslDisabledByUseCaseConfigStatus();
        }
        boolean allUseCasesDetached = this.mUseCaseAttachState.getAttachedSessionConfigs().isEmpty();
        if (allUseCasesDetached) {
            this.mCameraControlInternal.decrementUseCount();
            this.resetCaptureSession(false);
            this.mCameraControlInternal.setActive(false);
            this.mCaptureSession = this.newCaptureSession();
            this.closeInternal();
        } else {
            this.updateCaptureSessionConfig();
            this.resetCaptureSession(false);
            if (this.mState == InternalState.OPENED) {
                this.openCaptureSession();
            }
        }
    }

    private void updateZslDisabledByUseCaseConfigStatus() {
        boolean isZslDisabledByUseCaseConfig = false;
        for (UseCaseConfig useCaseConfig : this.mUseCaseAttachState.getAttachedUseCaseConfigs()) {
            isZslDisabledByUseCaseConfig |= useCaseConfig.isZslDisabled(false);
        }
        this.mCameraControlInternal.setZslDisabledByUserCaseConfig(isZslDisabledByUseCaseConfig);
    }

    private void addOrRemoveMeteringRepeatingUseCase() {
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getAttachedBuilder();
        SessionConfig sessionConfig = validatingBuilder.build();
        CaptureConfig captureConfig = sessionConfig.getRepeatingCaptureConfig();
        int sizeRepeatingSurfaces = captureConfig.getSurfaces().size();
        int sizeSessionSurfaces = sessionConfig.getSurfaces().size();
        if (!sessionConfig.getSurfaces().isEmpty()) {
            if (captureConfig.getSurfaces().isEmpty()) {
                if (this.mMeteringRepeatingSession == null) {
                    this.mMeteringRepeatingSession = new MeteringRepeatingSession(this.mCameraInfoInternal.getCameraCharacteristicsCompat(), this.mDisplayInfoManager, () -> {
                        if (!this.isMeteringRepeatingAttached()) {
                            return;
                        }
                        SessionConfig sessionConfigMeteringRepeating = this.mMeteringRepeatingSession.getSessionConfig();
                        UseCaseConfig<?> useCaseConfig = this.mMeteringRepeatingSession.getUseCaseConfig();
                        this.resetUseCase(Camera2CameraImpl.getMeteringRepeatingId(this.mMeteringRepeatingSession), sessionConfigMeteringRepeating, useCaseConfig, null, Collections.singletonList(UseCaseConfigFactory.CaptureType.METERING_REPEATING));
                    });
                }
                if (this.isSurfaceCombinationWithMeteringRepeatingSupported()) {
                    this.addMeteringRepeating();
                } else {
                    Logger.e((String)TAG, (String)"Failed to add a repeating surface, CameraControl and ImageCapture may encounter issues due to the absence of repeating surface. Please add a UseCase (Preview or ImageAnalysis) that can provide a repeating surface for CameraControl and ImageCapture to function properly.");
                }
            } else if (sizeSessionSurfaces == 1 && sizeRepeatingSurfaces == 1) {
                this.removeMeteringRepeating();
            } else if (sizeRepeatingSurfaces >= 2) {
                this.removeMeteringRepeating();
            } else if (this.mMeteringRepeatingSession != null && !this.isSurfaceCombinationWithMeteringRepeatingSupported()) {
                this.removeMeteringRepeating();
            } else {
                Logger.d((String)TAG, (String)("No need to remove a previous mMeteringRepeating, SessionConfig Surfaces: " + sizeSessionSurfaces + ", CaptureConfig Surfaces: " + sizeRepeatingSurfaces));
            }
        }
    }

    private boolean isSurfaceCombinationWithMeteringRepeatingSupported() {
        ArrayList<AttachedSurfaceInfo> attachedSurfaces = new ArrayList<AttachedSurfaceInfo>();
        int cameraMode = this.getCameraMode();
        for (UseCaseAttachState.UseCaseAttachInfo useCaseInfo : this.mUseCaseAttachState.getAttachedUseCaseInfo()) {
            if (useCaseInfo.getCaptureTypes() != null && useCaseInfo.getCaptureTypes().get(0) == UseCaseConfigFactory.CaptureType.METERING_REPEATING) continue;
            if (useCaseInfo.getStreamSpec() == null || useCaseInfo.getCaptureTypes() == null) {
                Logger.w((String)TAG, (String)("Invalid stream spec or capture types in " + useCaseInfo));
                return false;
            }
            SessionConfig sessionConfig = useCaseInfo.getSessionConfig();
            UseCaseConfig useCaseConfig = useCaseInfo.getUseCaseConfig();
            for (DeferrableSurface surface : sessionConfig.getSurfaces()) {
                SurfaceConfig surfaceConfig = this.mSupportedSurfaceCombination.transformSurfaceConfig(cameraMode, useCaseConfig.getInputFormat(), surface.getPrescribedSize());
                AttachedSurfaceInfo attachedSurfaceInfo = AttachedSurfaceInfo.create((SurfaceConfig)surfaceConfig, (int)useCaseConfig.getInputFormat(), (Size)surface.getPrescribedSize(), (DynamicRange)useCaseInfo.getStreamSpec().getDynamicRange(), (List)useCaseInfo.getCaptureTypes(), (Config)useCaseInfo.getStreamSpec().getImplementationOptions(), (Range)useCaseConfig.getTargetFrameRate(null));
                attachedSurfaces.add(attachedSurfaceInfo);
            }
        }
        Preconditions.checkNotNull((Object)this.mMeteringRepeatingSession);
        HashMap useCaseConfigToSizeMap = new HashMap();
        useCaseConfigToSizeMap.put(this.mMeteringRepeatingSession.getUseCaseConfig(), Collections.singletonList(this.mMeteringRepeatingSession.getMeteringRepeatingSize()));
        try {
            this.mSupportedSurfaceCombination.getSuggestedStreamSpecifications(cameraMode, attachedSurfaces, useCaseConfigToSizeMap, false, false);
        }
        catch (IllegalArgumentException e) {
            this.debugLog("Surface combination with metering repeating  not supported!", e);
            return false;
        }
        this.debugLog("Surface combination with metering repeating supported!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraCoordinator.getCameraOperatingMode() == 2) {
                return 1;
            }
        }
        return 0;
    }

    private void removeMeteringRepeating() {
        if (this.mMeteringRepeatingSession != null) {
            this.mUseCaseAttachState.setUseCaseDetached(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode());
            this.mUseCaseAttachState.setUseCaseInactive(this.mMeteringRepeatingSession.getName() + this.mMeteringRepeatingSession.hashCode());
            this.mMeteringRepeatingSession.clear();
            this.mMeteringRepeatingSession = null;
        }
    }

    private void addMeteringRepeating() {
        if (this.mMeteringRepeatingSession != null) {
            String id = Camera2CameraImpl.getMeteringRepeatingId(this.mMeteringRepeatingSession);
            this.mUseCaseAttachState.setUseCaseAttached(id, this.mMeteringRepeatingSession.getSessionConfig(), this.mMeteringRepeatingSession.getUseCaseConfig(), null, Collections.singletonList(UseCaseConfigFactory.CaptureType.METERING_REPEATING));
            this.mUseCaseAttachState.setUseCaseActive(id, this.mMeteringRepeatingSession.getSessionConfig(), this.mMeteringRepeatingSession.getUseCaseConfig(), null, Collections.singletonList(UseCaseConfigFactory.CaptureType.METERING_REPEATING));
        }
    }

    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mCameraInfoInternal;
    }

    @NonNull
    @VisibleForTesting
    public CameraAvailability getCameraAvailability() {
        return this.mCameraAvailability;
    }

    void tryForceOpenCameraDevice(boolean fromScheduledCameraReopen) {
        this.debugLog("Attempting to force open the camera.");
        boolean shouldTryOpenCamera = this.mCameraStateRegistry.tryOpenCamera((Camera)this);
        if (!shouldTryOpenCamera) {
            this.debugLog("No cameras available. Waiting for available camera before opening camera.");
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.openCameraDevice(fromScheduledCameraReopen);
    }

    void tryOpenCameraDevice(boolean fromScheduledCameraReopen) {
        boolean shouldTryOpenCamera;
        this.debugLog("Attempting to open the camera.");
        boolean bl = shouldTryOpenCamera = this.mCameraAvailability.isCameraAvailable() && this.mCameraStateRegistry.tryOpenCamera((Camera)this);
        if (!shouldTryOpenCamera) {
            this.debugLog("No cameras available. Waiting for available camera before opening camera.");
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.openCameraDevice(fromScheduledCameraReopen);
    }

    public void setPrimary(boolean isPrimary) {
        this.mIsPrimary = isPrimary;
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mExecutor.execute(() -> {
            this.mIsActiveResumingMode = enabled;
            if (enabled && this.mState == InternalState.PENDING_OPEN) {
                this.tryForceOpenCameraDevice(false);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void openCameraDevice(boolean fromScheduledCameraReopen) {
        if (!fromScheduledCameraReopen) {
            this.mStateCallback.resetReopenMonitor();
        }
        this.mStateCallback.cancelScheduledReopen();
        this.mErrorTimeoutReopenScheduler.cancel();
        this.debugLog("Opening camera.");
        this.setState(InternalState.OPENING);
        try {
            this.mCameraManager.openCamera(this.mCameraInfoInternal.getCameraId(), this.mExecutor, this.createDeviceStateCallback());
        }
        catch (CameraAccessExceptionCompat e) {
            this.debugLog("Unable to open camera due to " + e.getMessage());
            switch (e.getReason()) {
                case 10001: {
                    this.setState(InternalState.INITIALIZED, CameraState.StateError.create((int)7, (Throwable)e));
                    break;
                }
                default: {
                    this.mErrorTimeoutReopenScheduler.start();
                    break;
                }
            }
        }
        catch (SecurityException e) {
            this.debugLog("Unable to open camera due to " + e.getMessage());
            this.setState(InternalState.REOPENING);
            this.mStateCallback.scheduleCameraReopen();
        }
    }

    void updateCaptureSessionConfig() {
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getActiveAndAttachedBuilder();
        if (validatingBuilder.isValid()) {
            SessionConfig useCaseSessionConfig = validatingBuilder.build();
            this.mCameraControlInternal.setTemplate(useCaseSessionConfig.getTemplateType());
            validatingBuilder.add(this.mCameraControlInternal.getSessionConfig());
            SessionConfig sessionConfig = validatingBuilder.build();
            this.mCaptureSession.setSessionConfig(sessionConfig);
        } else {
            this.mCameraControlInternal.resetTemplate();
            this.mCaptureSession.setSessionConfig(this.mCameraControlInternal.getSessionConfig());
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    void openCaptureSession() {
        Preconditions.checkState((this.mState == InternalState.OPENED ? 1 : 0) != 0);
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getAttachedBuilder();
        if (!validatingBuilder.isValid()) {
            this.debugLog("Unable to create capture session due to conflicting configurations");
            return;
        }
        if (!this.mCameraStateRegistry.tryOpenCaptureSession(this.mCameraDevice.getId(), this.mCameraCoordinator.getPairedConcurrentCameraId(this.mCameraDevice.getId()))) {
            this.debugLog("Unable to create capture session in camera operating mode = " + this.mCameraCoordinator.getCameraOperatingMode());
            return;
        }
        HashMap<DeferrableSurface, Long> streamUseCaseMap = new HashMap<DeferrableSurface, Long>();
        StreamUseCaseUtil.populateSurfaceToStreamUseCaseMapping(this.mUseCaseAttachState.getAttachedSessionConfigs(), this.mUseCaseAttachState.getAttachedUseCaseConfigs(), streamUseCaseMap);
        this.mCaptureSession.setStreamUseCaseMap(streamUseCaseMap);
        final CaptureSessionInterface captureSession = this.mCaptureSession;
        ListenableFuture<Void> openCaptureSession = captureSession.open(validatingBuilder.build(), (CameraDevice)Preconditions.checkNotNull((Object)this.mCameraDevice), this.mCaptureSessionOpenerBuilder.build());
        Futures.addCallback(openCaptureSession, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                if (Camera2CameraImpl.this.mCameraCoordinator.getCameraOperatingMode() == 2 && Camera2CameraImpl.this.mState == InternalState.OPENED) {
                    Camera2CameraImpl.this.setState(InternalState.CONFIGURED);
                }
            }

            public void onFailure(@NonNull Throwable t) {
                if (t instanceof DeferrableSurface.SurfaceClosedException) {
                    SessionConfig sessionConfig = Camera2CameraImpl.this.findSessionConfigForSurface(((DeferrableSurface.SurfaceClosedException)t).getDeferrableSurface());
                    if (sessionConfig != null) {
                        Camera2CameraImpl.this.postSurfaceClosedError(sessionConfig);
                    }
                    return;
                }
                if (t instanceof CancellationException) {
                    Camera2CameraImpl.this.debugLog("Unable to configure camera cancelled");
                    return;
                }
                if (Camera2CameraImpl.this.mState == InternalState.OPENED) {
                    Camera2CameraImpl.this.setState(InternalState.OPENED, CameraState.StateError.create((int)4, (Throwable)t));
                }
                Logger.e((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this), (Throwable)t);
                if (Camera2CameraImpl.this.mCaptureSession == captureSession) {
                    Camera2CameraImpl.this.resetCaptureSession(false);
                }
            }
        }, (Executor)this.mExecutor);
    }

    @Nullable
    SessionConfig findSessionConfigForSurface(@NonNull DeferrableSurface surface) {
        for (SessionConfig sessionConfig : this.mUseCaseAttachState.getAttachedSessionConfigs()) {
            if (!sessionConfig.getSurfaces().contains(surface)) continue;
            return sessionConfig;
        }
        return null;
    }

    void postSurfaceClosedError(@NonNull SessionConfig sessionConfig) {
        ScheduledExecutorService executor = CameraXExecutors.mainThreadExecutor();
        SessionConfig.ErrorListener errorListener = sessionConfig.getErrorListener();
        if (errorListener != null) {
            this.debugLog("Posting surface closed", new Throwable());
            executor.execute(() -> errorListener.onError(sessionConfig, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET));
        }
    }

    void resetCaptureSession(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mCaptureSession != null ? 1 : 0) != 0);
        this.debugLog("Resetting Capture Session");
        CaptureSessionInterface oldCaptureSession = this.mCaptureSession;
        SessionConfig previousSessionConfig = oldCaptureSession.getSessionConfig();
        List<CaptureConfig> unissuedCaptureConfigs = oldCaptureSession.getCaptureConfigs();
        this.mCaptureSession = this.newCaptureSession();
        this.mCaptureSession.setSessionConfig(previousSessionConfig);
        this.mCaptureSession.issueCaptureRequests(unissuedCaptureConfigs);
        switch (this.mState.ordinal()) {
            case 8: {
                if (!this.mCloseCameraBeforeCreateNewSessionQuirk || !oldCaptureSession.isInOpenState()) break;
                this.debugLog("Close camera before creating new session");
                this.setState(InternalState.REOPENING_QUIRK);
                break;
            }
            default: {
                this.debugLog("Skipping Capture Session state check due to current camera state: " + (Object)((Object)this.mState) + " and previous session status: " + oldCaptureSession.isInOpenState());
            }
        }
        if (this.mConfigAndCloseQuirk && oldCaptureSession.isInOpenState()) {
            this.debugLog("ConfigAndClose is required when close the camera.");
            this.mIsConfigAndCloseRequired = true;
        }
        this.releaseSession(oldCaptureSession, abortInFlightCaptures);
    }

    private CameraDevice.StateCallback createDeviceStateCallback() {
        SessionConfig config = this.mUseCaseAttachState.getAttachedBuilder().build();
        List configuredStateCallbacks = config.getDeviceStateCallbacks();
        ArrayList<CameraDevice.StateCallback> allStateCallbacks = new ArrayList<CameraDevice.StateCallback>(configuredStateCallbacks);
        allStateCallbacks.add(this.mCaptureSessionRepository.getCameraStateCallback());
        allStateCallbacks.add(this.mStateCallback);
        return CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks);
    }

    private boolean checkAndAttachRepeatingSurface(CaptureConfig.Builder captureConfigBuilder) {
        if (!captureConfigBuilder.getSurfaces().isEmpty()) {
            Logger.w((String)TAG, (String)"The capture config builder already has surface inside.");
            return false;
        }
        for (SessionConfig sessionConfig : this.mUseCaseAttachState.getActiveAndAttachedSessionConfigs()) {
            CaptureConfig repeatingCaptureConfig = sessionConfig.getRepeatingCaptureConfig();
            List surfaces = repeatingCaptureConfig.getSurfaces();
            if (surfaces.isEmpty()) continue;
            if (repeatingCaptureConfig.getPreviewStabilizationMode() != 0) {
                captureConfigBuilder.setPreviewStabilization(repeatingCaptureConfig.getPreviewStabilizationMode());
            }
            if (repeatingCaptureConfig.getVideoStabilizationMode() != 0) {
                captureConfigBuilder.setVideoStabilization(repeatingCaptureConfig.getVideoStabilizationMode());
            }
            for (DeferrableSurface surface : surfaces) {
                captureConfigBuilder.addSurface(surface);
            }
        }
        if (captureConfigBuilder.getSurfaces().isEmpty()) {
            Logger.w((String)TAG, (String)"Unable to find a repeating surface to attach to CaptureConfig");
            return false;
        }
        return true;
    }

    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mCameraControlInternal;
    }

    void submitCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        ArrayList<CaptureConfig> captureConfigsWithSurface = new ArrayList<CaptureConfig>();
        for (CaptureConfig captureConfig : captureConfigs) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            if (captureConfig.getTemplateType() == 5 && captureConfig.getCameraCaptureResult() != null) {
                builder.setCameraCaptureResult(captureConfig.getCameraCaptureResult());
            }
            if (captureConfig.getSurfaces().isEmpty() && captureConfig.isUseRepeatingSurface() && !this.checkAndAttachRepeatingSurface(builder)) continue;
            captureConfigsWithSurface.add(builder.build());
        }
        this.debugLog("Issue capture request");
        this.mCaptureSession.issueCaptureRequests(captureConfigsWithSurface);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "Camera@%x[id=%s]", this.hashCode(), this.mCameraInfoInternal.getCameraId());
    }

    @NonNull
    static String getUseCaseId(@NonNull UseCase useCase) {
        return useCase.getName() + useCase.hashCode();
    }

    @Nullable
    static List<UseCaseConfigFactory.CaptureType> getCaptureTypes(@NonNull UseCase useCase) {
        if (useCase.getCamera() == null) {
            return null;
        }
        return StreamSharing.getCaptureTypes((UseCase)useCase);
    }

    @NonNull
    static String getMeteringRepeatingId(@NonNull MeteringRepeatingSession meteringRepeating) {
        return meteringRepeating.getName() + meteringRepeating.hashCode();
    }

    void debugLog(@NonNull String msg) {
        this.debugLog(msg, null);
    }

    private void debugLog(@NonNull String msg, @Nullable Throwable throwable) {
        String msgString = String.format("{%s} %s", this.toString(), msg);
        Logger.d((String)TAG, (String)msgString, (Throwable)throwable);
    }

    void setState(@NonNull InternalState state) {
        this.setState(state, null);
    }

    void setState(@NonNull InternalState state, @Nullable CameraState.StateError stateError) {
        this.setState(state, stateError, true);
    }

    void setState(@NonNull InternalState state, @Nullable CameraState.StateError stateError, boolean notifyImmediately) {
        CameraInternal.State publicState;
        this.debugLog("Transitioning camera internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state));
        this.traceInternalState(state, stateError);
        this.mState = state;
        switch (state.ordinal()) {
            case 2: {
                publicState = CameraInternal.State.CLOSED;
                break;
            }
            case 3: {
                publicState = CameraInternal.State.PENDING_OPEN;
                break;
            }
            case 6: 
            case 7: {
                publicState = CameraInternal.State.OPENING;
                break;
            }
            case 8: {
                publicState = CameraInternal.State.OPEN;
                break;
            }
            case 9: {
                publicState = CameraInternal.State.CONFIGURED;
                break;
            }
            case 4: 
            case 5: {
                publicState = CameraInternal.State.CLOSING;
                break;
            }
            case 1: {
                publicState = CameraInternal.State.RELEASING;
                break;
            }
            case 0: {
                publicState = CameraInternal.State.RELEASED;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
            }
        }
        this.mCameraStateRegistry.markCameraState((Camera)this, publicState, notifyImmediately);
        this.mObservableState.postValue((Object)publicState);
        this.mCameraStateMachine.updateState(publicState, stateError);
    }

    void traceInternalState(@NonNull InternalState state, @Nullable CameraState.StateError stateError) {
        if (Trace.isEnabled()) {
            String counterName = "CX:C2State[" + this + "]";
            Trace.setCounter((String)counterName, (int)state.ordinal());
            if (stateError != null) {
                ++this.mTraceStateErrorCount;
            }
            if (this.mTraceStateErrorCount > 0) {
                String errorCounterName = "CX:C2StateErrorCode[" + this + "]";
                int errorCode = stateError != null ? stateError.getCode() : 0;
                Trace.setCounter((String)errorCounterName, (int)errorCode);
            }
        }
    }

    static String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "ERROR_NONE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return "UNKNOWN ERROR";
    }

    private static /* synthetic */ ListenableFuture lambda$configAndClose$3(CaptureSession noOpSession, DeferrableSurface deferrableSurface, Void v) throws Exception {
        noOpSession.close();
        deferrableSurface.close();
        return noOpSession.release(false);
    }

    private class ErrorTimeoutReopenScheduler {
        private static final long ERROR_TIMEOUT_MILLIS = 2000L;
        @Nullable
        private ScheduleNode mScheduleNode = null;

        private ErrorTimeoutReopenScheduler() {
        }

        public void start() {
            if (Camera2CameraImpl.this.mState != InternalState.OPENING) {
                Camera2CameraImpl.this.debugLog("Don't need the onError timeout handler.");
                return;
            }
            Camera2CameraImpl.this.debugLog("Camera waiting for onError.");
            this.cancel();
            this.mScheduleNode = new ScheduleNode();
        }

        public boolean isErrorHandling() {
            return this.mScheduleNode != null && !this.mScheduleNode.isDone();
        }

        public void deviceOnError() {
            Camera2CameraImpl.this.debugLog("Camera receive onErrorCallback");
            this.cancel();
        }

        public void cancel() {
            if (this.mScheduleNode != null) {
                this.mScheduleNode.cancel();
            }
            this.mScheduleNode = null;
        }

        private class ScheduleNode {
            private final ScheduledFuture<?> mScheduledFuture;
            private final AtomicBoolean mIsDone = new AtomicBoolean(false);

            ScheduleNode() {
                this.mScheduledFuture = Camera2CameraImpl.this.mScheduledExecutorService.schedule(this::execute, 2000L, TimeUnit.MILLISECONDS);
            }

            private void execute() {
                if (this.mIsDone.getAndSet(true)) {
                    return;
                }
                Camera2CameraImpl.this.mExecutor.execute(this::executeInternal);
            }

            private void executeInternal() {
                if (Camera2CameraImpl.this.mState != InternalState.OPENING) {
                    Camera2CameraImpl.this.debugLog("Camera skip reopen at state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                    return;
                }
                Camera2CameraImpl.this.debugLog("Camera onError timeout, reopen it.");
                Camera2CameraImpl.this.setState(InternalState.REOPENING);
                Camera2CameraImpl.this.mStateCallback.scheduleCameraReopen();
            }

            public void cancel() {
                this.mIsDone.set(true);
                this.mScheduledFuture.cancel(true);
            }

            public boolean isDone() {
                return this.mIsDone.get();
            }
        }
    }

    final class StateCallback
    extends CameraDevice.StateCallback {
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduler;
        private ScheduledReopen mScheduledReopenRunnable;
        ScheduledFuture<?> mScheduledReopenHandle;
        @NonNull
        private final CameraReopenMonitor mCameraReopenMonitor;

        StateCallback(@NonNull Executor executor, ScheduledExecutorService scheduler, long cameraOpenRetryMaxTimeoutInMs) {
            this.mExecutor = executor;
            this.mScheduler = scheduler;
            this.mCameraReopenMonitor = new CameraReopenMonitor(cameraOpenRetryMaxTimeoutInMs);
        }

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onOpened()");
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = 0;
            this.resetReopenMonitor();
            switch (Camera2CameraImpl.this.mState.ordinal()) {
                case 1: 
                case 4: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.mCameraDevice.close();
                    Camera2CameraImpl.this.mCameraDevice = null;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    Camera2CameraImpl.this.setState(InternalState.OPENED);
                    if (!Camera2CameraImpl.this.mCameraStateRegistry.tryOpenCaptureSession(cameraDevice.getId(), Camera2CameraImpl.this.mCameraCoordinator.getPairedConcurrentCameraId(Camera2CameraImpl.this.mCameraDevice.getId()))) break;
                    Camera2CameraImpl.this.openCaptureSession();
                    break;
                }
                default: {
                    throw new IllegalStateException("onOpened() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onClosed(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onClosed()");
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDevice == null ? 1 : 0) != 0, (String)("Unexpected onClose callback on camera device: " + cameraDevice));
            switch (Camera2CameraImpl.this.mState.ordinal()) {
                case 1: 
                case 4: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.configAndCloseIfNeeded();
                    break;
                }
                case 5: 
                case 6: {
                    if (Camera2CameraImpl.this.mCameraDeviceError != 0) {
                        Camera2CameraImpl.this.debugLog("Camera closed due to error: " + Camera2CameraImpl.getErrorMessage(Camera2CameraImpl.this.mCameraDeviceError));
                        this.scheduleCameraReopen();
                        break;
                    }
                    Camera2CameraImpl.this.tryOpenCameraDevice(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("Camera closed while in state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            Camera2CameraImpl.this.debugLog("CameraDevice.onDisconnected()");
            this.onError(cameraDevice, 1);
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = error;
            Camera2CameraImpl.this.mErrorTimeoutReopenScheduler.deviceOnError();
            switch (Camera2CameraImpl.this.mState.ordinal()) {
                case 1: 
                case 4: {
                    Logger.e((String)Camera2CameraImpl.TAG, (String)String.format("CameraDevice.onError(): %s failed with %s while in %s state. Will finish closing camera.", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error), Camera2CameraImpl.this.mState.name()));
                    Camera2CameraImpl.this.closeCamera(false);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    Logger.d((String)Camera2CameraImpl.TAG, (String)String.format("CameraDevice.onError(): %s failed with %s while in %s state. Will attempt recovering from error.", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error), Camera2CameraImpl.this.mState.name()));
                    this.handleErrorOnOpen(cameraDevice, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("onError() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        private void handleErrorOnOpen(@NonNull CameraDevice cameraDevice, int error) {
            Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.OPENING || Camera2CameraImpl.this.mState == InternalState.OPENED || Camera2CameraImpl.this.mState == InternalState.CONFIGURED || Camera2CameraImpl.this.mState == InternalState.REOPENING || Camera2CameraImpl.this.mState == InternalState.REOPENING_QUIRK ? 1 : 0) != 0, (String)("Attempt to handle open error from non open state: " + (Object)((Object)Camera2CameraImpl.this.mState)));
            switch (error) {
                case 1: 
                case 2: 
                case 4: {
                    Logger.d((String)Camera2CameraImpl.TAG, (String)String.format("Attempt to reopen camera[%s] after error[%s]", cameraDevice.getId(), Camera2CameraImpl.getErrorMessage(error)));
                    this.reopenCameraAfterError(error);
                    break;
                }
                default: {
                    Logger.e((String)Camera2CameraImpl.TAG, (String)("Error observed on open (or opening) camera device " + cameraDevice.getId() + ": " + Camera2CameraImpl.getErrorMessage(error) + " closing camera."));
                    int publicErrorCode = error == 3 ? 5 : 6;
                    Camera2CameraImpl.this.setState(InternalState.CLOSING, CameraState.StateError.create((int)publicErrorCode));
                    Camera2CameraImpl.this.closeCamera(false);
                }
            }
        }

        private void reopenCameraAfterError(int error) {
            int publicErrorCode;
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)"Can only reopen camera device after error if the camera device is actually in an error state.");
            switch (error) {
                case 1: {
                    publicErrorCode = 2;
                    break;
                }
                case 2: {
                    publicErrorCode = 1;
                    break;
                }
                default: {
                    publicErrorCode = 3;
                }
            }
            Camera2CameraImpl.this.setState(InternalState.REOPENING, CameraState.StateError.create((int)publicErrorCode));
            Camera2CameraImpl.this.closeCamera(false);
        }

        void scheduleCameraReopen() {
            Preconditions.checkState((this.mScheduledReopenRunnable == null ? 1 : 0) != 0);
            Preconditions.checkState((this.mScheduledReopenHandle == null ? 1 : 0) != 0);
            if (this.mCameraReopenMonitor.canScheduleCameraReopen()) {
                this.mScheduledReopenRunnable = new ScheduledReopen(this.mExecutor);
                Camera2CameraImpl.this.debugLog("Attempting camera re-open in " + this.mCameraReopenMonitor.getReopenDelayMs() + "ms: " + this.mScheduledReopenRunnable + " activeResuming = " + Camera2CameraImpl.this.mIsActiveResumingMode);
                this.mScheduledReopenHandle = this.mScheduler.schedule(this.mScheduledReopenRunnable, (long)this.mCameraReopenMonitor.getReopenDelayMs(), TimeUnit.MILLISECONDS);
            } else {
                Logger.e((String)Camera2CameraImpl.TAG, (String)("Camera reopening attempted for " + this.mCameraReopenMonitor.getReopenLimitMs() + "ms without success."));
                Camera2CameraImpl.this.setState(InternalState.PENDING_OPEN, null, false);
            }
        }

        boolean cancelScheduledReopen() {
            boolean cancelled = false;
            if (this.mScheduledReopenHandle != null) {
                Camera2CameraImpl.this.debugLog("Cancelling scheduled re-open: " + this.mScheduledReopenRunnable);
                this.mScheduledReopenRunnable.cancel();
                this.mScheduledReopenRunnable = null;
                this.mScheduledReopenHandle.cancel(false);
                this.mScheduledReopenHandle = null;
                cancelled = true;
            }
            return cancelled;
        }

        void resetReopenMonitor() {
            this.mCameraReopenMonitor.reset();
        }

        boolean shouldActiveResume() {
            return Camera2CameraImpl.this.mIsActiveResumingMode && (Camera2CameraImpl.this.mCameraDeviceError == 1 || Camera2CameraImpl.this.mCameraDeviceError == 2);
        }

        class CameraReopenMonitor {
            static final int REOPEN_DELAY_MS = 700;
            static final int REOPEN_LIMIT_MS = 10000;
            static final int ACTIVE_REOPEN_DELAY_BASE_MS = 1000;
            static final int ACTIVE_REOPEN_LIMIT_MS = 1800000;
            static final int INVALID_TIME = -1;
            private final long mCameraOpenRetryMaxTimeoutInMs;
            private long mFirstReopenTime = -1L;

            CameraReopenMonitor(long cameraOpenRetryMaxTimeoutInMs) {
                this.mCameraOpenRetryMaxTimeoutInMs = cameraOpenRetryMaxTimeoutInMs;
            }

            int getReopenDelayMs() {
                if (!StateCallback.this.shouldActiveResume()) {
                    return 700;
                }
                long elapsedTime = this.getElapsedTime();
                if (elapsedTime <= 120000L) {
                    return 1000;
                }
                if (elapsedTime <= 300000L) {
                    return 2000;
                }
                return 4000;
            }

            int getReopenLimitMs() {
                if (!StateCallback.this.shouldActiveResume()) {
                    return this.mCameraOpenRetryMaxTimeoutInMs > 0L ? Math.min((int)this.mCameraOpenRetryMaxTimeoutInMs, 10000) : 10000;
                }
                return this.mCameraOpenRetryMaxTimeoutInMs > 0L ? Math.min((int)this.mCameraOpenRetryMaxTimeoutInMs, 1800000) : 1800000;
            }

            long getElapsedTime() {
                long now = SystemClock.uptimeMillis();
                if (this.mFirstReopenTime == -1L) {
                    this.mFirstReopenTime = now;
                }
                return now - this.mFirstReopenTime;
            }

            boolean canScheduleCameraReopen() {
                boolean hasReachedLimit;
                boolean bl = hasReachedLimit = this.getElapsedTime() >= (long)this.getReopenLimitMs();
                if (hasReachedLimit) {
                    this.reset();
                    return false;
                }
                return true;
            }

            void reset() {
                this.mFirstReopenTime = -1L;
            }
        }

        class ScheduledReopen
        implements Runnable {
            private Executor mExecutor;
            private boolean mCancelled = false;

            ScheduledReopen(Executor executor) {
                this.mExecutor = executor;
            }

            void cancel() {
                this.mCancelled = true;
            }

            @Override
            public void run() {
                this.mExecutor.execute(() -> {
                    if (!this.mCancelled) {
                        Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.REOPENING || Camera2CameraImpl.this.mState == InternalState.REOPENING_QUIRK ? 1 : 0) != 0);
                        if (StateCallback.this.shouldActiveResume()) {
                            Camera2CameraImpl.this.tryForceOpenCameraDevice(true);
                        } else {
                            Camera2CameraImpl.this.tryOpenCameraDevice(true);
                        }
                    }
                });
            }
        }
    }

    static enum InternalState {
        RELEASED,
        RELEASING,
        INITIALIZED,
        PENDING_OPEN,
        CLOSING,
        REOPENING_QUIRK,
        REOPENING,
        OPENING,
        OPENED,
        CONFIGURED;

    }

    final class ControlUpdateListenerInternal
    implements CameraControlInternal.ControlUpdateCallback {
        ControlUpdateListenerInternal() {
        }

        public void onCameraControlUpdateSessionConfig() {
            Camera2CameraImpl.this.updateCaptureSessionConfig();
        }

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            Camera2CameraImpl.this.submitCaptureRequests((List)Preconditions.checkNotNull(captureConfigs));
        }
    }

    final class CameraAvailability
    extends CameraManager.AvailabilityCallback
    implements CameraStateRegistry.OnOpenAvailableListener {
        private final String mCameraId;
        private boolean mCameraAvailable = true;

        CameraAvailability(String cameraId) {
            this.mCameraId = cameraId;
        }

        public void onCameraAvailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = true;
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.tryOpenCameraDevice(false);
            }
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = false;
        }

        public void onOpenAvailable() {
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.tryOpenCameraDevice(false);
            }
        }

        boolean isCameraAvailable() {
            return this.mCameraAvailable;
        }
    }

    final class CameraConfigureAvailable
    implements CameraStateRegistry.OnConfigureAvailableListener {
        CameraConfigureAvailable() {
        }

        public void onConfigureAvailable() {
            if (Camera2CameraImpl.this.mState == InternalState.OPENED) {
                Camera2CameraImpl.this.openCaptureSession();
            }
        }
    }

    @AutoValue
    static abstract class UseCaseInfo {
        UseCaseInfo() {
        }

        @NonNull
        static UseCaseInfo create(@NonNull String useCaseId, @NonNull Class<?> useCaseType, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable Size surfaceResolution, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
            return new AutoValue_Camera2CameraImpl_UseCaseInfo(useCaseId, useCaseType, sessionConfig, useCaseConfig, surfaceResolution, streamSpec, captureTypes);
        }

        @NonNull
        static UseCaseInfo from(@NonNull UseCase useCase, boolean isPrimary) {
            return UseCaseInfo.create(Camera2CameraImpl.getUseCaseId(useCase), useCase.getClass(), isPrimary ? useCase.getSessionConfig() : useCase.getSecondarySessionConfig(), useCase.getCurrentConfig(), useCase.getAttachedSurfaceResolution(), useCase.getAttachedStreamSpec(), Camera2CameraImpl.getCaptureTypes(useCase));
        }

        @NonNull
        abstract String getUseCaseId();

        @NonNull
        abstract Class<?> getUseCaseType();

        @NonNull
        abstract SessionConfig getSessionConfig();

        @NonNull
        abstract UseCaseConfig<?> getUseCaseConfig();

        @Nullable
        abstract Size getSurfaceResolution();

        @Nullable
        abstract StreamSpec getStreamSpec();

        @Nullable
        abstract List<UseCaseConfigFactory.CaptureType> getCaptureTypes();
    }
}

