/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class RequestMonitor {
    private static final String TAG = "RequestMonitor";
    private final boolean mQuirkEnabled;
    private final List<ListenableFuture<Void>> mRequestTasks = Collections.synchronizedList(new ArrayList());

    public RequestMonitor(boolean quirkEnabled) {
        this.mQuirkEnabled = quirkEnabled;
    }

    public boolean shouldMonitorRequest() {
        return this.mQuirkEnabled;
    }

    @NonNull
    public ListenableFuture<Void> getRequestsProcessedFuture() {
        if (this.mRequestTasks.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        return Futures.nonCancellationPropagating((ListenableFuture)Futures.transform((ListenableFuture)Futures.successfulAsList(new ArrayList<ListenableFuture<Void>>(this.mRequestTasks)), input -> null, (Executor)CameraXExecutors.directExecutor()));
    }

    @NonNull
    public CameraCaptureSession.CaptureCallback createMonitorListener(@NonNull CameraCaptureSession.CaptureCallback originalListener) {
        if (this.shouldMonitorRequest()) {
            return Camera2CaptureCallbacks.createComboCallback(this.createMonitorListener(), originalListener);
        }
        return originalListener;
    }

    private CameraCaptureSession.CaptureCallback createMonitorListener() {
        RequestCompleteListener completeListener = new RequestCompleteListener();
        ListenableFuture<Void> future = completeListener.mStartRequestFuture;
        this.mRequestTasks.add(future);
        Log.d((String)TAG, (String)("RequestListener " + (Object)((Object)completeListener) + " monitoring " + this));
        future.addListener(() -> {
            Log.d((String)TAG, (String)("RequestListener " + (Object)((Object)completeListener) + " done " + this));
            this.mRequestTasks.remove(future);
        }, CameraXExecutors.directExecutor());
        return completeListener;
    }

    public void stop() {
        LinkedList<ListenableFuture<Void>> tasks = new LinkedList<ListenableFuture<Void>>(this.mRequestTasks);
        while (!tasks.isEmpty()) {
            Objects.requireNonNull(tasks.poll()).cancel(true);
        }
    }

    static class RequestCompleteListener
    extends CameraCaptureSession.CaptureCallback {
        @NonNull
        final ListenableFuture<Void> mStartRequestFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mStartRequestCompleter = completer;
            return "RequestCompleteListener[" + (Object)((Object)this) + "]";
        });
        CallbackToFutureAdapter.Completer<Void> mStartRequestCompleter;

        RequestCompleteListener() {
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            this.completeFuture();
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            this.completeFuture();
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.completeFuture();
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            this.completeFuture();
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            this.completeFuture();
        }

        private void completeFuture() {
            if (this.mStartRequestCompleter != null) {
                this.mStartRequestCompleter.set(null);
                this.mStartRequestCompleter = null;
            }
        }
    }
}

