/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.compat.quirk.ConfigureSurfaceToSecondarySessionFailQuirk;
import androidx.camera.camera2.internal.compat.quirk.PreviewOrientationIncorrectQuirk;
import androidx.camera.camera2.internal.compat.quirk.TextureViewIsClosedQuirk;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import java.util.List;

public class ForceCloseDeferrableSurface {
    private final boolean mHasTextureViewIsClosedQuirk;
    private final boolean mHasPreviewOrientationIncorrectQuirk;
    private final boolean mHasConfigureSurfaceToSecondarySessionFailQuirk;

    public ForceCloseDeferrableSurface(@NonNull Quirks cameraQuirks, @NonNull Quirks deviceQuirks) {
        this.mHasTextureViewIsClosedQuirk = deviceQuirks.contains(TextureViewIsClosedQuirk.class);
        this.mHasPreviewOrientationIncorrectQuirk = cameraQuirks.contains(PreviewOrientationIncorrectQuirk.class);
        this.mHasConfigureSurfaceToSecondarySessionFailQuirk = cameraQuirks.contains(ConfigureSurfaceToSecondarySessionFailQuirk.class);
    }

    public boolean shouldForceClose() {
        return this.mHasTextureViewIsClosedQuirk || this.mHasPreviewOrientationIncorrectQuirk || this.mHasConfigureSurfaceToSecondarySessionFailQuirk;
    }

    public void onSessionEnd(@Nullable List<DeferrableSurface> deferrableSurfaces) {
        if (this.shouldForceClose() && deferrableSurfaces != null) {
            for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
                deferrableSurface.close();
            }
            Logger.d((String)"ForceCloseDeferrableSurface", (String)"deferrableSurface closed");
        }
    }
}

