/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.impl.Quirk;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class TorchFlashRequiredFor3aUpdateQuirk
implements Quirk {
    private static final List<String> AFFECTED_PIXEL_MODELS = Arrays.asList("PIXEL 6A", "PIXEL 6 PRO", "PIXEL 7", "PIXEL 7A", "PIXEL 7 PRO", "PIXEL 8", "PIXEL 8 PRO");
    @NonNull
    private final CameraCharacteristicsCompat mCameraCharacteristics;

    public TorchFlashRequiredFor3aUpdateQuirk(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        this.mCameraCharacteristics = cameraCharacteristics;
    }

    static boolean load(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        return TorchFlashRequiredFor3aUpdateQuirk.isAffectedModel(cameraCharacteristics);
    }

    public boolean isFlashModeTorchRequired() {
        return !TorchFlashRequiredFor3aUpdateQuirk.isExternalFlashAeModeSupported(this.mCameraCharacteristics);
    }

    private static boolean isAffectedModel(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        return TorchFlashRequiredFor3aUpdateQuirk.isAffectedPixelModel() && TorchFlashRequiredFor3aUpdateQuirk.isFrontCamera(cameraCharacteristics);
    }

    private static boolean isAffectedPixelModel() {
        for (String model : AFFECTED_PIXEL_MODELS) {
            if (!Build.MODEL.toUpperCase(Locale.US).equals(model)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFrontCamera(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
    }

    private static boolean isExternalFlashAeModeSupported(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        return Camera2CameraControlImpl.getSupportedAeMode(cameraCharacteristics, 5) == 5;
    }
}

