/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirksLoader;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettingsHolder;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;

public class DeviceQuirks {
    private static final String TAG = "DeviceQuirks";
    @NonNull
    private static volatile Quirks sQuirks;

    private DeviceQuirks() {
    }

    @NonNull
    public static Quirks getAll() {
        return sQuirks;
    }

    @Nullable
    public static <T extends Quirk> T get(@NonNull Class<T> quirkClass) {
        return (T)sQuirks.get(quirkClass);
    }

    static {
        QuirkSettingsHolder.instance().observe(CameraXExecutors.directExecutor(), quirkSettings -> {
            sQuirks = new Quirks(DeviceQuirksLoader.loadQuirks(quirkSettings));
            Logger.d((String)TAG, (String)("camera2 DeviceQuirks = " + Quirks.toString((Quirks)sQuirks)));
        });
    }
}

