/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CamcorderProfileResolutionQuirk
implements Quirk {
    private static final String TAG = "CamcorderProfileResolutionQuirk";
    private final StreamConfigurationMapCompat mStreamConfigurationMapCompat;
    private List<Size> mSupportedResolutions = null;

    static boolean load(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        Integer level = (Integer)characteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        return level != null && level == 2;
    }

    public CamcorderProfileResolutionQuirk(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        this.mStreamConfigurationMapCompat = characteristicsCompat.getStreamConfigurationMapCompat();
    }

    @NonNull
    public List<Size> getSupportedResolutions() {
        if (this.mSupportedResolutions == null) {
            Size[] sizes = this.mStreamConfigurationMapCompat.getOutputSizes(34);
            this.mSupportedResolutions = sizes != null ? Arrays.asList((Size[])sizes.clone()) : Collections.emptyList();
            Logger.d((String)TAG, (String)("mSupportedResolutions = " + this.mSupportedResolutions));
        }
        return new ArrayList<Size>(this.mSupportedResolutions);
    }
}

