/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.DynamicRangeProfiles;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompatApi33Impl;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompatBaseImpl;
import androidx.camera.core.DynamicRange;
import androidx.core.util.Preconditions;
import java.util.Set;

public final class DynamicRangesCompat {
    private final DynamicRangeProfilesCompatImpl mImpl;

    DynamicRangesCompat(@NonNull DynamicRangeProfilesCompatImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public Set<DynamicRange> getDynamicRangeCaptureRequestConstraints(@NonNull DynamicRange dynamicRange) {
        return this.mImpl.getDynamicRangeCaptureRequestConstraints(dynamicRange);
    }

    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges() {
        return this.mImpl.getSupportedDynamicRanges();
    }

    public boolean isExtraLatencyPresent(@NonNull DynamicRange dynamicRange) {
        return this.mImpl.isExtraLatencyPresent(dynamicRange);
    }

    @NonNull
    public static DynamicRangesCompat fromCameraCharacteristics(@NonNull CameraCharacteristicsCompat characteristics) {
        DynamicRangesCompat rangesCompat = null;
        if (Build.VERSION.SDK_INT >= 33) {
            rangesCompat = DynamicRangesCompat.toDynamicRangesCompat((DynamicRangeProfiles)characteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES));
        }
        return rangesCompat == null ? DynamicRangesCompatBaseImpl.COMPAT_INSTANCE : rangesCompat;
    }

    @Nullable
    @RequiresApi(value=33)
    public static DynamicRangesCompat toDynamicRangesCompat(@Nullable DynamicRangeProfiles dynamicRangeProfiles) {
        if (dynamicRangeProfiles == null) {
            return null;
        }
        Preconditions.checkState((Build.VERSION.SDK_INT >= 33 ? 1 : 0) != 0, (String)"DynamicRangeProfiles can only be converted to DynamicRangesCompat on API 33 or higher.");
        return new DynamicRangesCompat(new DynamicRangesCompatApi33Impl(dynamicRangeProfiles));
    }

    @Nullable
    @RequiresApi(value=33)
    public DynamicRangeProfiles toDynamicRangeProfiles() {
        Preconditions.checkState((Build.VERSION.SDK_INT >= 33 ? 1 : 0) != 0, (String)"DynamicRangesCompat can only be converted to DynamicRangeProfiles on API 33 or higher.");
        return this.mImpl.unwrap();
    }

    static interface DynamicRangeProfilesCompatImpl {
        @NonNull
        public Set<DynamicRange> getDynamicRangeCaptureRequestConstraints(@NonNull DynamicRange var1);

        @NonNull
        public Set<DynamicRange> getSupportedDynamicRanges();

        public boolean isExtraLatencyPresent(@NonNull DynamicRange var1);

        @Nullable
        public DynamicRangeProfiles unwrap();
    }
}

