/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

class CameraManagerCompatBaseImpl
implements CameraManagerCompat.CameraManagerCompatImpl {
    final CameraManager mCameraManager;
    final Object mObject;

    CameraManagerCompatBaseImpl(@NonNull Context context, @Nullable Object cameraManagerParams) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mObject = cameraManagerParams;
    }

    static CameraManagerCompatBaseImpl create(@NonNull Context context, @NonNull Handler compatHandler) {
        return new CameraManagerCompatBaseImpl(context, new CameraManagerCompatParamsApi21(compatHandler));
    }

    @Override
    @NonNull
    public String[] getCameraIdList() throws CameraAccessExceptionCompat {
        try {
            return this.mCameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }

    @Override
    @NonNull
    public Set<Set<String>> getConcurrentCameraIds() throws CameraAccessExceptionCompat {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAvailabilityCallback(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        CameraManagerCompat.AvailabilityCallbackExecutorWrapper wrapper = null;
        CameraManagerCompatParamsApi21 params = (CameraManagerCompatParamsApi21)this.mObject;
        if (callback != null) {
            Map<CameraManager.AvailabilityCallback, CameraManagerCompat.AvailabilityCallbackExecutorWrapper> map = params.mWrapperMap;
            synchronized (map) {
                wrapper = params.mWrapperMap.get(callback);
                if (wrapper == null) {
                    wrapper = new CameraManagerCompat.AvailabilityCallbackExecutorWrapper(executor, callback);
                    params.mWrapperMap.put(callback, wrapper);
                }
            }
        }
        this.mCameraManager.registerAvailabilityCallback(wrapper, params.mCompatHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback callback) {
        CameraManagerCompat.AvailabilityCallbackExecutorWrapper wrapper = null;
        if (callback != null) {
            CameraManagerCompatParamsApi21 params = (CameraManagerCompatParamsApi21)this.mObject;
            Map<CameraManager.AvailabilityCallback, CameraManagerCompat.AvailabilityCallbackExecutorWrapper> map = params.mWrapperMap;
            synchronized (map) {
                wrapper = params.mWrapperMap.remove(callback);
            }
        }
        if (wrapper != null) {
            wrapper.setDisabled();
        }
        this.mCameraManager.unregisterAvailabilityCallback((CameraManager.AvailabilityCallback)wrapper);
    }

    @Override
    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId) throws CameraAccessExceptionCompat {
        try {
            return this.mCameraManager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessExceptionCompat {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)callback);
        CameraDeviceCompat.StateCallbackExecutorWrapper cb = new CameraDeviceCompat.StateCallbackExecutorWrapper(executor, callback);
        CameraManagerCompatParamsApi21 params = (CameraManagerCompatParamsApi21)this.mObject;
        try {
            this.mCameraManager.openCamera(cameraId, (CameraDevice.StateCallback)cb, params.mCompatHandler);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }

    @Override
    @NonNull
    public CameraManager getCameraManager() {
        return this.mCameraManager;
    }

    static final class CameraManagerCompatParamsApi21 {
        @GuardedBy(value="mWrapperMap")
        final Map<CameraManager.AvailabilityCallback, CameraManagerCompat.AvailabilityCallbackExecutorWrapper> mWrapperMap = new HashMap<CameraManager.AvailabilityCallback, CameraManagerCompat.AvailabilityCallbackExecutorWrapper>();
        final Handler mCompatHandler;

        CameraManagerCompatParamsApi21(@NonNull Handler compatHandler) {
            this.mCompatHandler = compatHandler;
        }
    }
}

