/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraDevice;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi23Impl;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi24Impl;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi28Impl;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatBaseImpl;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.concurrent.Executor;

public final class CameraDeviceCompat {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int SESSION_OPERATION_MODE_NORMAL = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int SESSION_OPERATION_MODE_CONSTRAINED_HIGH_SPEED = 1;
    private final CameraDeviceCompatImpl mImpl;

    private CameraDeviceCompat(@NonNull CameraDevice cameraDevice, @NonNull Handler compatHandler) {
        this.mImpl = Build.VERSION.SDK_INT >= 28 ? new CameraDeviceCompatApi28Impl(cameraDevice) : (Build.VERSION.SDK_INT >= 24 ? CameraDeviceCompatApi24Impl.create(cameraDevice, compatHandler) : (Build.VERSION.SDK_INT >= 23 ? CameraDeviceCompatApi23Impl.create(cameraDevice, compatHandler) : CameraDeviceCompatBaseImpl.create(cameraDevice, compatHandler)));
    }

    @NonNull
    public static CameraDeviceCompat toCameraDeviceCompat(@NonNull CameraDevice captureSession) {
        return CameraDeviceCompat.toCameraDeviceCompat(captureSession, MainThreadAsyncHandler.getInstance());
    }

    @NonNull
    public static CameraDeviceCompat toCameraDeviceCompat(@NonNull CameraDevice cameraDevice, @NonNull Handler compatHandler) {
        return new CameraDeviceCompat(cameraDevice, compatHandler);
    }

    @NonNull
    public CameraDevice toCameraDevice() {
        return this.mImpl.unwrap();
    }

    public void createCaptureSession(@NonNull SessionConfigurationCompat config) throws CameraAccessExceptionCompat {
        this.mImpl.createCaptureSession(config);
    }

    static interface CameraDeviceCompatImpl {
        public void createCaptureSession(@NonNull SessionConfigurationCompat var1) throws CameraAccessExceptionCompat;

        @NonNull
        public CameraDevice unwrap();
    }

    static final class StateCallbackExecutorWrapper
    extends CameraDevice.StateCallback {
        final CameraDevice.StateCallback mWrappedCallback;
        private final Executor mExecutor;

        StateCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraDevice.StateCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onOpened(@NonNull CameraDevice camera) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onOpened(camera));
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onDisconnected(camera));
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onError(camera, error));
        }

        public void onClosed(@NonNull CameraDevice camera) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onClosed(camera));
        }
    }
}

