/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionBaseImpl;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.camera2.internal.compat.quirk.CaptureSessionStuckQuirk;
import androidx.camera.camera2.internal.compat.quirk.IncorrectCaptureStateQuirk;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseCaptureSession;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseDeferrableSurface;
import androidx.camera.camera2.internal.compat.workaround.RequestMonitor;
import androidx.camera.camera2.internal.compat.workaround.SessionResetPolicy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

class SynchronizedCaptureSessionImpl
extends SynchronizedCaptureSessionBaseImpl {
    private static final String TAG = "SyncCaptureSessionImpl";
    @NonNull
    private final ScheduledExecutorService mScheduledExecutorService;
    private final Object mObjectLock = new Object();
    @Nullable
    @GuardedBy(value="mObjectLock")
    private List<DeferrableSurface> mDeferrableSurfaces;
    @Nullable
    @GuardedBy(value="mObjectLock")
    ListenableFuture<List<Void>> mOpenSessionBlockerFuture;
    private final ForceCloseDeferrableSurface mCloseSurfaceQuirk;
    private final ForceCloseCaptureSession mForceCloseSessionQuirk;
    private final RequestMonitor mRequestMonitor;
    private final SessionResetPolicy mSessionResetPolicy;
    private final AtomicBoolean mClosed = new AtomicBoolean(false);

    SynchronizedCaptureSessionImpl(@NonNull Quirks cameraQuirks, @NonNull Quirks deviceQuirks, @NonNull CaptureSessionRepository repository, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler) {
        super(repository, executor, scheduledExecutorService, compatHandler);
        this.mCloseSurfaceQuirk = new ForceCloseDeferrableSurface(cameraQuirks, deviceQuirks);
        this.mRequestMonitor = new RequestMonitor(cameraQuirks.contains(CaptureSessionStuckQuirk.class) || cameraQuirks.contains(IncorrectCaptureStateQuirk.class));
        this.mForceCloseSessionQuirk = new ForceCloseCaptureSession(deviceQuirks);
        this.mSessionResetPolicy = new SessionResetPolicy(deviceQuirks);
        this.mScheduledExecutorService = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat, @NonNull List<DeferrableSurface> deferrableSurfaces) {
        Object object = this.mObjectLock;
        synchronized (object) {
            List<SynchronizedCaptureSession> configured = this.mCaptureSessionRepository.getCaptureSessions();
            ArrayList<ListenableFuture<Void>> futureList = new ArrayList<ListenableFuture<Void>>();
            for (SynchronizedCaptureSession session : configured) {
                futureList.add(session.getOpeningBlocker());
            }
            this.mOpenSessionBlockerFuture = Futures.successfulAsList(futureList);
            return Futures.nonCancellationPropagating((ListenableFuture)FutureChain.from(this.mOpenSessionBlockerFuture).transformAsync(v -> {
                if (this.mSessionResetPolicy.needAbortCapture()) {
                    this.closeCreatedSession();
                }
                this.debugLog("start openCaptureSession");
                return super.openCaptureSession(cameraDevice, sessionConfigurationCompat, deferrableSurfaces);
            }, this.getExecutor()));
        }
    }

    private void closeCreatedSession() {
        List<SynchronizedCaptureSession> sessions = this.mCaptureSessionRepository.getCaptureSessions();
        for (SynchronizedCaptureSession session : sessions) {
            session.close();
        }
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getOpeningBlocker() {
        return Futures.makeTimeoutFuture((long)1500L, (ScheduledExecutorService)this.mScheduledExecutorService, this.mRequestMonitor.getRequestsProcessedFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mDeferrableSurfaces = deferrableSurfaces;
            return super.startWithDeferrableSurface(deferrableSurfaces, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        Object object = this.mObjectLock;
        synchronized (object) {
            if (this.isCameraCaptureSessionOpen()) {
                this.mCloseSurfaceQuirk.onSessionEnd(this.mDeferrableSurfaces);
            } else if (this.mOpenSessionBlockerFuture != null) {
                this.mOpenSessionBlockerFuture.cancel(true);
            }
            return super.stop();
        }
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return super.setSingleRepeatingRequest(request, this.mRequestMonitor.createMonitorListener(listener));
    }

    @Override
    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return super.captureBurstRequests(requests, this.mRequestMonitor.createMonitorListener(listener));
    }

    @Override
    public void onConfigured(@NonNull SynchronizedCaptureSession session) {
        this.debugLog("Session onConfigured()");
        this.mForceCloseSessionQuirk.onSessionConfigured(session, this.mCaptureSessionRepository.getCreatingCaptureSessions(), this.mCaptureSessionRepository.getCaptureSessions(), x$0 -> super.onConfigured(x$0));
    }

    @Override
    public void close() {
        if (!this.mClosed.compareAndSet(false, true)) {
            this.debugLog("close() has been called. Skip this invocation.");
            return;
        }
        if (this.mSessionResetPolicy.needAbortCapture()) {
            try {
                this.debugLog("Call abortCaptures() before closing session.");
                this.abortCaptures();
            }
            catch (Exception e) {
                this.debugLog("Exception when calling abortCaptures()" + e);
            }
        }
        this.debugLog("Session call close()");
        this.mRequestMonitor.getRequestsProcessedFuture().addListener(() -> {
            this.debugLog("Session call super.close()");
            super.close();
        }, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed(@NonNull SynchronizedCaptureSession session) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mCloseSurfaceQuirk.onSessionEnd(this.mDeferrableSurfaces);
        }
        this.debugLog("onClosed()");
        super.onClosed(session);
    }

    @Override
    public void finishClose() {
        super.finishClose();
        this.mRequestMonitor.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCameraDeviceError(int error) {
        super.onCameraDeviceError(error);
        if (error == 5) {
            Object object = this.mObjectLock;
            synchronized (object) {
                if (this.isCameraCaptureSessionOpen() && this.mDeferrableSurfaces != null) {
                    this.debugLog("Close DeferrableSurfaces for CameraDevice error.");
                    for (DeferrableSurface deferrableSurface : this.mDeferrableSurfaces) {
                        deferrableSurface.close();
                    }
                }
            }
        }
    }

    void debugLog(String message) {
        Logger.d((String)TAG, (String)("[" + this + "] " + message));
    }
}

