/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CaptureResult;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.utils.ExifData;
import java.nio.BufferUnderflowException;

public class Camera2CameraCaptureResult
implements CameraCaptureResult {
    private static final String TAG = "C2CameraCaptureResult";
    private final TagBundle mTagBundle;
    private final CaptureResult mCaptureResult;

    public Camera2CameraCaptureResult(@NonNull TagBundle tagBundle, @NonNull CaptureResult captureResult) {
        this.mTagBundle = tagBundle;
        this.mCaptureResult = captureResult;
    }

    public Camera2CameraCaptureResult(@NonNull CaptureResult captureResult) {
        this(TagBundle.emptyBundle(), captureResult);
    }

    @NonNull
    public CameraCaptureMetaData.AfMode getAfMode() {
        Integer mode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_MODE);
        if (mode == null) {
            return CameraCaptureMetaData.AfMode.UNKNOWN;
        }
        switch (mode) {
            case 0: 
            case 5: {
                return CameraCaptureMetaData.AfMode.OFF;
            }
            case 1: 
            case 2: {
                return CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO;
            }
        }
        Logger.e((String)TAG, (String)("Undefined af mode: " + mode));
        return CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AfState getAfState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AF_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AfState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AfState.INACTIVE;
            }
            case 1: 
            case 3: {
                return CameraCaptureMetaData.AfState.SCANNING;
            }
            case 4: {
                return CameraCaptureMetaData.AfState.LOCKED_FOCUSED;
            }
            case 5: {
                return CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
            }
            case 6: {
                return CameraCaptureMetaData.AfState.PASSIVE_NOT_FOCUSED;
            }
            case 2: {
                return CameraCaptureMetaData.AfState.PASSIVE_FOCUSED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined af state: " + state));
        return CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AeState getAeState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AE_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AeState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AeState.INACTIVE;
            }
            case 1: 
            case 5: {
                return CameraCaptureMetaData.AeState.SEARCHING;
            }
            case 4: {
                return CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return CameraCaptureMetaData.AeState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AeState.LOCKED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined ae state: " + state));
        return CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AwbState getAwbState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_STATE);
        if (state == null) {
            return CameraCaptureMetaData.AwbState.UNKNOWN;
        }
        switch (state) {
            case 0: {
                return CameraCaptureMetaData.AwbState.INACTIVE;
            }
            case 1: {
                return CameraCaptureMetaData.AwbState.METERING;
            }
            case 2: {
                return CameraCaptureMetaData.AwbState.CONVERGED;
            }
            case 3: {
                return CameraCaptureMetaData.AwbState.LOCKED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined awb state: " + state));
        return CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.FlashState getFlashState() {
        Integer state = (Integer)this.mCaptureResult.get(CaptureResult.FLASH_STATE);
        if (state == null) {
            return CameraCaptureMetaData.FlashState.UNKNOWN;
        }
        switch (state) {
            case 0: 
            case 1: {
                return CameraCaptureMetaData.FlashState.NONE;
            }
            case 2: {
                return CameraCaptureMetaData.FlashState.READY;
            }
            case 3: 
            case 4: {
                return CameraCaptureMetaData.FlashState.FIRED;
            }
        }
        Logger.e((String)TAG, (String)("Undefined flash state: " + state));
        return CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AeMode getAeMode() {
        Integer aeMode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AE_MODE);
        if (aeMode == null) {
            return CameraCaptureMetaData.AeMode.UNKNOWN;
        }
        switch (aeMode) {
            case 0: {
                return CameraCaptureMetaData.AeMode.OFF;
            }
            case 1: {
                return CameraCaptureMetaData.AeMode.ON;
            }
            case 2: {
                return CameraCaptureMetaData.AeMode.ON_AUTO_FLASH;
            }
            case 3: {
                return CameraCaptureMetaData.AeMode.ON_ALWAYS_FLASH;
            }
            case 4: {
                return CameraCaptureMetaData.AeMode.ON_AUTO_FLASH_REDEYE;
            }
            case 5: {
                if (Build.VERSION.SDK_INT >= 28) {
                    return CameraCaptureMetaData.AeMode.ON_EXTERNAL_FLASH;
                }
                return CameraCaptureMetaData.AeMode.UNKNOWN;
            }
        }
        return CameraCaptureMetaData.AeMode.UNKNOWN;
    }

    @NonNull
    public CameraCaptureMetaData.AwbMode getAwbMode() {
        Integer awbMode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_MODE);
        if (awbMode == null) {
            return CameraCaptureMetaData.AwbMode.UNKNOWN;
        }
        switch (awbMode) {
            case 0: {
                return CameraCaptureMetaData.AwbMode.OFF;
            }
            case 1: {
                return CameraCaptureMetaData.AwbMode.AUTO;
            }
            case 2: {
                return CameraCaptureMetaData.AwbMode.INCANDESCENT;
            }
            case 3: {
                return CameraCaptureMetaData.AwbMode.FLUORESCENT;
            }
            case 4: {
                return CameraCaptureMetaData.AwbMode.WARM_FLUORESCENT;
            }
            case 5: {
                return CameraCaptureMetaData.AwbMode.DAYLIGHT;
            }
            case 6: {
                return CameraCaptureMetaData.AwbMode.CLOUDY_DAYLIGHT;
            }
            case 7: {
                return CameraCaptureMetaData.AwbMode.TWILIGHT;
            }
            case 8: {
                return CameraCaptureMetaData.AwbMode.SHADE;
            }
        }
        return CameraCaptureMetaData.AwbMode.UNKNOWN;
    }

    public long getTimestamp() {
        Long timestamp = (Long)this.mCaptureResult.get(CaptureResult.SENSOR_TIMESTAMP);
        if (timestamp == null) {
            return -1L;
        }
        return timestamp;
    }

    @NonNull
    public TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    public void populateExifData(@NonNull ExifData.Builder exifData) {
        Integer whiteBalanceMode;
        Float focalLength;
        Integer iso;
        Float aperture;
        super.populateExifData(exifData);
        try {
            Integer jpegOrientation = (Integer)this.mCaptureResult.get(CaptureResult.JPEG_ORIENTATION);
            if (jpegOrientation != null) {
                exifData.setOrientationDegrees(jpegOrientation.intValue());
            }
        }
        catch (BufferUnderflowException exception) {
            Logger.w((String)TAG, (String)"Failed to get JPEG orientation.");
        }
        Long exposureTimeNs = (Long)this.mCaptureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME);
        if (exposureTimeNs != null) {
            exifData.setExposureTimeNanos(exposureTimeNs.longValue());
        }
        if ((aperture = (Float)this.mCaptureResult.get(CaptureResult.LENS_APERTURE)) != null) {
            exifData.setLensFNumber(aperture.floatValue());
        }
        if ((iso = (Integer)this.mCaptureResult.get(CaptureResult.SENSOR_SENSITIVITY)) != null) {
            Integer postRawSensitivityBoost;
            if (Build.VERSION.SDK_INT >= 24 && (postRawSensitivityBoost = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_POST_RAW_SENSITIVITY_BOOST)) != null) {
                iso = iso * (int)((float)postRawSensitivityBoost.intValue() / 100.0f);
            }
            exifData.setIso(iso.intValue());
        }
        if ((focalLength = (Float)this.mCaptureResult.get(CaptureResult.LENS_FOCAL_LENGTH)) != null) {
            exifData.setFocalLength(focalLength.floatValue());
        }
        if ((whiteBalanceMode = (Integer)this.mCaptureResult.get(CaptureResult.CONTROL_AWB_MODE)) != null) {
            ExifData.WhiteBalanceMode wbMode = ExifData.WhiteBalanceMode.AUTO;
            if (whiteBalanceMode == 0) {
                wbMode = ExifData.WhiteBalanceMode.MANUAL;
            }
            exifData.setWhiteBalanceMode(wbMode);
        }
    }

    @NonNull
    public CaptureResult getCaptureResult() {
        return this.mCaptureResult;
    }
}

