/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.ApiCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public final class CameraCaptureSessionStateCallbacks {
    private CameraCaptureSessionStateCallbacks() {
    }

    @NonNull
    public static CameraCaptureSession.StateCallback createNoOpCallback() {
        return new NoOpSessionStateCallback();
    }

    @NonNull
    public static CameraCaptureSession.StateCallback createComboCallback(@NonNull List<CameraCaptureSession.StateCallback> callbacks) {
        if (callbacks.isEmpty()) {
            return CameraCaptureSessionStateCallbacks.createNoOpCallback();
        }
        if (callbacks.size() == 1) {
            return callbacks.get(0);
        }
        return new ComboSessionStateCallback(callbacks);
    }

    @NonNull
    public static CameraCaptureSession.StateCallback createComboCallback(CameraCaptureSession.StateCallback ... callbacks) {
        return CameraCaptureSessionStateCallbacks.createComboCallback(Arrays.asList(callbacks));
    }

    static final class NoOpSessionStateCallback
    extends CameraCaptureSession.StateCallback {
        NoOpSessionStateCallback() {
        }

        public void onConfigured(@NonNull CameraCaptureSession session) {
        }

        public void onActive(@NonNull CameraCaptureSession session) {
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
        }

        public void onReady(@NonNull CameraCaptureSession session) {
        }

        public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
        }

        public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
        }
    }

    @RequiresApi(value=21)
    static final class ComboSessionStateCallback
    extends CameraCaptureSession.StateCallback {
        private final List<CameraCaptureSession.StateCallback> mCallbacks = new ArrayList<CameraCaptureSession.StateCallback>();

        ComboSessionStateCallback(@NonNull List<CameraCaptureSession.StateCallback> callbacks) {
            for (CameraCaptureSession.StateCallback callback : callbacks) {
                if (callback instanceof NoOpSessionStateCallback) continue;
                this.mCallbacks.add(callback);
            }
        }

        public void onConfigured(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                callback.onConfigured(session);
            }
        }

        public void onActive(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                callback.onActive(session);
            }
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                callback.onClosed(session);
            }
        }

        public void onReady(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                callback.onReady(session);
            }
        }

        @RequiresApi(api=26)
        public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                ApiCompat.Api26Impl.onCaptureQueueEmpty(callback, session);
            }
        }

        @RequiresApi(api=23)
        public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                ApiCompat.Api23Impl.onSurfacePrepared(callback, session, surface);
            }
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            for (CameraCaptureSession.StateCallback callback : this.mCallbacks) {
                callback.onConfigureFailed(session);
            }
        }
    }
}

