/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.interop;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.ReadableConfig;

@ExperimentalCamera2Interop
@RequiresApi(value=21)
public class CaptureRequestOptions
implements ReadableConfig {
    private final Config mConfig;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CaptureRequestOptions(@NonNull Config config) {
        this.mConfig = config;
    }

    @Nullable
    public <ValueT> ValueT getCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key) {
        Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
        return (ValueT)this.mConfig.retrieveOption(opt, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public <ValueT> ValueT getCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @Nullable ValueT valueIfMissing) {
        Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
        return (ValueT)this.mConfig.retrieveOption(opt, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    @RequiresApi(value=21)
    public static final class Builder
    implements ExtendableBuilder<CaptureRequestOptions> {
        private final MutableOptionsBundle mMutableOptionsBundle = MutableOptionsBundle.create();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public static Builder from(@NonNull Config config) {
            Builder bundleBuilder = new Builder();
            config.findOptions("camera2.captureRequest.option.", option -> {
                Config.Option objectOpt = option;
                bundleBuilder.getMutableConfig().insertOption(objectOpt, config.getOptionPriority(objectOpt), config.retrieveOption(objectOpt));
                return true;
            });
            return bundleBuilder;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableOptionsBundle;
        }

        @NonNull
        public <ValueT> Builder setCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value) {
            Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.insertOption(opt, value);
            return this;
        }

        @NonNull
        public <ValueT> Builder clearCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key) {
            Config.Option<Object> opt = Camera2ImplConfig.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.removeOption(opt);
            return this;
        }

        @NonNull
        public CaptureRequestOptions build() {
            return new CaptureRequestOptions((Config)OptionsBundle.from((Config)this.mMutableOptionsBundle));
        }
    }
}

