/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.impl.Quirk;

@RequiresApi(value=21)
public class AeFpsRangeLegacyQuirk
implements Quirk {
    @Nullable
    private final Range<Integer> mAeFpsRange;

    public AeFpsRangeLegacyQuirk(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        Range[] availableFpsRanges = (Range[])cameraCharacteristicsCompat.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.mAeFpsRange = this.pickSuitableFpsRange(availableFpsRanges);
    }

    static boolean load(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        Integer level = (Integer)cameraCharacteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        return level != null && level == 2;
    }

    @Nullable
    public Range<Integer> getRange() {
        return this.mAeFpsRange;
    }

    @Nullable
    private Range<Integer> pickSuitableFpsRange(@Nullable Range<Integer>[] availableFpsRanges) {
        if (availableFpsRanges == null || availableFpsRanges.length == 0) {
            return null;
        }
        Range<Integer> pickedRange = null;
        for (Range<Integer> fpsRange : availableFpsRanges) {
            if ((Integer)(fpsRange = this.getCorrectedFpsRange(fpsRange)).getUpper() != 30) continue;
            if (pickedRange == null) {
                pickedRange = fpsRange;
                continue;
            }
            if ((Integer)fpsRange.getLower() >= (Integer)pickedRange.getLower()) continue;
            pickedRange = fpsRange;
        }
        return pickedRange;
    }

    @NonNull
    private Range<Integer> getCorrectedFpsRange(@NonNull Range<Integer> fpsRange) {
        int newUpper = (Integer)fpsRange.getUpper();
        int newLower = (Integer)fpsRange.getLower();
        if ((Integer)fpsRange.getUpper() >= 1000) {
            newUpper = (Integer)fpsRange.getUpper() / 1000;
        }
        if ((Integer)fpsRange.getLower() >= 1000) {
            newLower = (Integer)fpsRange.getLower() / 1000;
        }
        return new Range((Comparable)Integer.valueOf(newLower), (Comparable)Integer.valueOf(newUpper));
    }
}

