/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi28Impl;
import java.util.concurrent.Executor;

@RequiresApi(value=29)
class CameraManagerCompatApi29Impl
extends CameraManagerCompatApi28Impl {
    CameraManagerCompatApi29Impl(@NonNull Context context) {
        super(context);
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessExceptionCompat {
        try {
            this.mCameraManager.openCamera(cameraId, executor, callback);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }

    @Override
    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId) throws CameraAccessExceptionCompat {
        try {
            return this.mCameraManager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }
}

