/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.ApiCompat;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompatApi28Impl;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompatBaseImpl;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class CameraCaptureSessionCompat {
    private final CameraCaptureSessionCompatImpl mImpl;

    private CameraCaptureSessionCompat(@NonNull CameraCaptureSession captureSession, @NonNull Handler compatHandler) {
        this.mImpl = Build.VERSION.SDK_INT >= 28 ? new CameraCaptureSessionCompatApi28Impl(captureSession) : CameraCaptureSessionCompatBaseImpl.create(captureSession, compatHandler);
    }

    @NonNull
    public static CameraCaptureSessionCompat toCameraCaptureSessionCompat(@NonNull CameraCaptureSession captureSession) {
        return CameraCaptureSessionCompat.toCameraCaptureSessionCompat(captureSession, MainThreadAsyncHandler.getInstance());
    }

    @NonNull
    public static CameraCaptureSessionCompat toCameraCaptureSessionCompat(@NonNull CameraCaptureSession captureSession, @NonNull Handler compatHandler) {
        return new CameraCaptureSessionCompat(captureSession, compatHandler);
    }

    @NonNull
    public CameraCaptureSession toCameraCaptureSession() {
        return this.mImpl.unwrap();
    }

    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return this.mImpl.captureBurstRequests(requests, executor, listener);
    }

    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return this.mImpl.captureSingleRequest(request, executor, listener);
    }

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return this.mImpl.setRepeatingBurstRequests(requests, executor, listener);
    }

    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return this.mImpl.setSingleRepeatingRequest(request, executor, listener);
    }

    @RequiresApi(value=21)
    static final class StateCallbackExecutorWrapper
    extends CameraCaptureSession.StateCallback {
        final CameraCaptureSession.StateCallback mWrappedCallback;
        private final Executor mExecutor;

        StateCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onConfigured(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onConfigured(session));
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onConfigureFailed(session));
        }

        public void onReady(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onReady(session));
        }

        public void onActive(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onActive(session));
        }

        @RequiresApi(value=26)
        public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> ApiCompat.Api26Impl.onCaptureQueueEmpty(this.mWrappedCallback, session));
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onClosed(session));
        }

        @RequiresApi(value=23)
        public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
            this.mExecutor.execute(() -> ApiCompat.Api23Impl.onSurfacePrepared(this.mWrappedCallback, session, surface));
        }
    }

    @RequiresApi(value=21)
    static final class CaptureCallbackExecutorWrapper
    extends CameraCaptureSession.CaptureCallback {
        final CameraCaptureSession.CaptureCallback mWrappedCallback;
        private final Executor mExecutor;

        CaptureCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureStarted(session, request, timestamp, frameNumber));
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureProgressed(session, request, partialResult));
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureCompleted(session, request, result));
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureFailed(session, request, failure));
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureSequenceCompleted(session, sequenceId, frameNumber));
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            this.mExecutor.execute(() -> this.mWrappedCallback.onCaptureSequenceAborted(session, sequenceId));
        }

        @RequiresApi(value=24)
        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface target, long frameNumber) {
            this.mExecutor.execute(() -> ApiCompat.Api24Impl.onCaptureBufferLost(this.mWrappedCallback, session, request, target, frameNumber));
        }
    }

    static interface CameraCaptureSessionCompatImpl {
        public int captureBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

        public int captureSingleRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

        public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

        public int setSingleRepeatingRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

        @NonNull
        public CameraCaptureSession unwrap();
    }
}

