/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.CameraCaptureSessionStateCallbacks;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.compat.ApiCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
final class SynchronizedCaptureSessionStateCallbacks
extends SynchronizedCaptureSession.StateCallback {
    private final List<SynchronizedCaptureSession.StateCallback> mCallbacks = new ArrayList<SynchronizedCaptureSession.StateCallback>();

    @NonNull
    static SynchronizedCaptureSession.StateCallback createComboCallback(SynchronizedCaptureSession.StateCallback ... callbacks) {
        return new SynchronizedCaptureSessionStateCallbacks(Arrays.asList(callbacks));
    }

    SynchronizedCaptureSessionStateCallbacks(@NonNull List<SynchronizedCaptureSession.StateCallback> callbacks) {
        this.mCallbacks.addAll(callbacks);
    }

    @Override
    @RequiresApi(api=23)
    public void onSurfacePrepared(@NonNull SynchronizedCaptureSession session, @NonNull Surface surface) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onSurfacePrepared(session, surface);
        }
    }

    @Override
    public void onReady(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onReady(session);
        }
    }

    @Override
    public void onActive(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onActive(session);
        }
    }

    @Override
    @RequiresApi(api=26)
    public void onCaptureQueueEmpty(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onCaptureQueueEmpty(session);
        }
    }

    @Override
    public void onConfigured(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onConfigured(session);
        }
    }

    @Override
    public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onConfigureFailed(session);
        }
    }

    @Override
    public void onClosed(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onClosed(session);
        }
    }

    @Override
    void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
        for (SynchronizedCaptureSession.StateCallback callback : this.mCallbacks) {
            callback.onSessionFinished(session);
        }
    }

    @RequiresApi(value=21)
    static class Adapter
    extends SynchronizedCaptureSession.StateCallback {
        @NonNull
        private final CameraCaptureSession.StateCallback mCameraCaptureSessionStateCallback;

        Adapter(@NonNull CameraCaptureSession.StateCallback cameraCaptureSessionStateCallback) {
            this.mCameraCaptureSessionStateCallback = cameraCaptureSessionStateCallback;
        }

        Adapter(@NonNull List<CameraCaptureSession.StateCallback> callbackList) {
            this(CameraCaptureSessionStateCallbacks.createComboCallback(callbackList));
        }

        @Override
        @RequiresApi(api=23)
        public void onSurfacePrepared(@NonNull SynchronizedCaptureSession session, @NonNull Surface surface) {
            ApiCompat.Api23Impl.onSurfacePrepared(this.mCameraCaptureSessionStateCallback, session.toCameraCaptureSessionCompat().toCameraCaptureSession(), surface);
        }

        @Override
        public void onReady(@NonNull SynchronizedCaptureSession session) {
            this.mCameraCaptureSessionStateCallback.onReady(session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        public void onActive(@NonNull SynchronizedCaptureSession session) {
            this.mCameraCaptureSessionStateCallback.onActive(session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        @RequiresApi(api=26)
        public void onCaptureQueueEmpty(@NonNull SynchronizedCaptureSession session) {
            ApiCompat.Api26Impl.onCaptureQueueEmpty(this.mCameraCaptureSessionStateCallback, session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        public void onConfigured(@NonNull SynchronizedCaptureSession session) {
            this.mCameraCaptureSessionStateCallback.onConfigured(session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
            this.mCameraCaptureSessionStateCallback.onConfigureFailed(session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        public void onClosed(@NonNull SynchronizedCaptureSession session) {
            this.mCameraCaptureSessionStateCallback.onClosed(session.toCameraCaptureSessionCompat().toCameraCaptureSession());
        }

        @Override
        void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
        }
    }
}

