/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionOpener;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.DeferrableSurfaces;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RequiresApi(value=21)
class SynchronizedCaptureSessionBaseImpl
extends SynchronizedCaptureSession.StateCallback
implements SynchronizedCaptureSession,
SynchronizedCaptureSessionOpener.OpenerImpl {
    private static final String TAG = "SyncCaptureSessionBase";
    final Object mLock = new Object();
    @NonNull
    final CaptureSessionRepository mCaptureSessionRepository;
    @NonNull
    final Handler mCompatHandler;
    @NonNull
    final Executor mExecutor;
    @NonNull
    private final ScheduledExecutorService mScheduledExecutorService;
    @Nullable
    SynchronizedCaptureSession.StateCallback mCaptureSessionStateCallback;
    @Nullable
    CameraCaptureSessionCompat mCameraCaptureSessionCompat;
    @Nullable
    @GuardedBy(value="mLock")
    ListenableFuture<Void> mOpenCaptureSessionFuture;
    @Nullable
    @GuardedBy(value="mLock")
    CallbackToFutureAdapter.Completer<Void> mOpenCaptureSessionCompleter;
    @Nullable
    @GuardedBy(value="mLock")
    private ListenableFuture<List<Surface>> mStartingSurface;
    @Nullable
    @GuardedBy(value="mLock")
    private List<DeferrableSurface> mHeldDeferrableSurfaces = null;
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private boolean mOpenerDisabled = false;
    @GuardedBy(value="mLock")
    private boolean mSessionFinished = false;

    SynchronizedCaptureSessionBaseImpl(@NonNull CaptureSessionRepository repository, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler) {
        this.mCaptureSessionRepository = repository;
        this.mCompatHandler = compatHandler;
        this.mExecutor = executor;
        this.mScheduledExecutorService = scheduledExecutorService;
    }

    @Override
    @NonNull
    public SynchronizedCaptureSession.StateCallback getStateCallback() {
        return this;
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getOpeningBlocker() {
        return Futures.immediateFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat, @NonNull List<DeferrableSurface> deferrableSurfaces) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOpenerDisabled) {
                return Futures.immediateFailedFuture((Throwable)new CancellationException("Opener is disabled"));
            }
            this.mCaptureSessionRepository.onCreateCaptureSession(this);
            CameraDeviceCompat cameraDeviceCompat = CameraDeviceCompat.toCameraDeviceCompat(cameraDevice, this.mCompatHandler);
            this.mOpenCaptureSessionFuture = CallbackToFutureAdapter.getFuture(completer -> {
                Object object = this.mLock;
                synchronized (object) {
                    this.holdDeferrableSurfaces(deferrableSurfaces);
                    Preconditions.checkState((this.mOpenCaptureSessionCompleter == null ? 1 : 0) != 0, (String)"The openCaptureSessionCompleter can only set once!");
                    this.mOpenCaptureSessionCompleter = completer;
                    cameraDeviceCompat.createCaptureSession(sessionConfigurationCompat);
                    return "openCaptureSession[session=" + this + "]";
                }
            });
            Futures.addCallback(this.mOpenCaptureSessionFuture, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                }

                public void onFailure(@NonNull Throwable t) {
                    SynchronizedCaptureSessionBaseImpl.this.finishClose();
                    SynchronizedCaptureSessionBaseImpl.this.mCaptureSessionRepository.onCaptureSessionConfigureFail(SynchronizedCaptureSessionBaseImpl.this);
                }
            }, (Executor)CameraXExecutors.directExecutor());
            return Futures.nonCancellationPropagating(this.mOpenCaptureSessionFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCameraCaptureSessionOpen() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOpenCaptureSessionFuture != null;
        }
    }

    @Override
    @NonNull
    public SessionConfigurationCompat createSessionConfigurationCompat(int sessionType, @NonNull List<OutputConfigurationCompat> outputsCompat, @NonNull SynchronizedCaptureSession.StateCallback stateCallback) {
        this.mCaptureSessionStateCallback = stateCallback;
        return new SessionConfigurationCompat(sessionType, outputsCompat, this.getExecutor(), new CameraCaptureSession.StateCallback(){

            public void onReady(@NonNull CameraCaptureSession session) {
                SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                SynchronizedCaptureSessionBaseImpl.this.onReady(SynchronizedCaptureSessionBaseImpl.this);
            }

            public void onActive(@NonNull CameraCaptureSession session) {
                SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                SynchronizedCaptureSessionBaseImpl.this.onActive(SynchronizedCaptureSessionBaseImpl.this);
            }

            @RequiresApi(api=26)
            public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
                SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                SynchronizedCaptureSessionBaseImpl.this.onCaptureQueueEmpty(SynchronizedCaptureSessionBaseImpl.this);
            }

            @RequiresApi(api=23)
            public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
                SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                SynchronizedCaptureSessionBaseImpl.this.onSurfacePrepared(SynchronizedCaptureSessionBaseImpl.this, surface);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConfigured(@NonNull CameraCaptureSession session) {
                try {
                    SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                    SynchronizedCaptureSessionBaseImpl.this.onConfigured(SynchronizedCaptureSessionBaseImpl.this);
                }
                finally {
                    CallbackToFutureAdapter.Completer<Void> completer;
                    Object object = SynchronizedCaptureSessionBaseImpl.this.mLock;
                    synchronized (object) {
                        Preconditions.checkNotNull(SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter, (Object)"OpenCaptureSession completer should not null");
                        completer = SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter;
                        SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter = null;
                    }
                    completer.set(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                try {
                    SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                    SynchronizedCaptureSessionBaseImpl.this.onConfigureFailed(SynchronizedCaptureSessionBaseImpl.this);
                }
                finally {
                    CallbackToFutureAdapter.Completer<Void> completer;
                    Object object = SynchronizedCaptureSessionBaseImpl.this.mLock;
                    synchronized (object) {
                        Preconditions.checkNotNull(SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter, (Object)"OpenCaptureSession completer should not null");
                        completer = SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter;
                        SynchronizedCaptureSessionBaseImpl.this.mOpenCaptureSessionCompleter = null;
                    }
                    completer.setException((Throwable)new IllegalStateException("onConfigureFailed"));
                }
            }

            public void onClosed(@NonNull CameraCaptureSession session) {
                SynchronizedCaptureSessionBaseImpl.this.createCaptureSessionCompat(session);
                SynchronizedCaptureSessionBaseImpl.this.onClosed(SynchronizedCaptureSessionBaseImpl.this);
            }
        });
    }

    @Override
    @NonNull
    public Executor getExecutor() {
        return this.mExecutor;
    }

    void createCaptureSessionCompat(@NonNull CameraCaptureSession session) {
        if (this.mCameraCaptureSessionCompat == null) {
            this.mCameraCaptureSessionCompat = CameraCaptureSessionCompat.toCameraCaptureSessionCompat(session, this.mCompatHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOpenerDisabled) {
                return Futures.immediateFailedFuture((Throwable)new CancellationException("Opener is disabled"));
            }
            this.mStartingSurface = FutureChain.from((ListenableFuture)DeferrableSurfaces.surfaceListWithTimeout(deferrableSurfaces, (boolean)false, (long)timeout, (Executor)this.getExecutor(), (ScheduledExecutorService)this.mScheduledExecutorService)).transformAsync(surfaces -> {
                Logger.d((String)TAG, (String)("[" + this + "] getSurface...done"));
                if (surfaces.contains(null)) {
                    DeferrableSurface deferrableSurface = (DeferrableSurface)deferrableSurfaces.get(surfaces.indexOf(null));
                    return Futures.immediateFailedFuture((Throwable)new DeferrableSurface.SurfaceClosedException("Surface closed", deferrableSurface));
                }
                if (surfaces.isEmpty()) {
                    return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Unable to open capture session without surfaces"));
                }
                return Futures.immediateFuture((Object)surfaces);
            }, this.getExecutor());
            return Futures.nonCancellationPropagating(this.mStartingSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        ListenableFuture<List<Surface>> startingSurface = null;
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mOpenerDisabled) {
                    if (this.mStartingSurface != null) {
                        startingSurface = this.mStartingSurface;
                    }
                    this.mOpenerDisabled = true;
                }
                boolean bl = !this.isCameraCaptureSessionOpen();
                return bl;
            }
        }
        finally {
            if (startingSurface != null) {
                startingSurface.cancel(true);
            }
        }
    }

    @Override
    @NonNull
    public CameraCaptureSessionCompat toCameraCaptureSessionCompat() {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat);
        return this.mCameraCaptureSessionCompat;
    }

    @Override
    @NonNull
    public CameraDevice getDevice() {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat);
        return this.mCameraCaptureSessionCompat.toCameraCaptureSession().getDevice();
    }

    @Override
    @Nullable
    public Surface getInputSurface() {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat);
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getInputSurface(this.mCameraCaptureSessionCompat.toCameraCaptureSession());
        }
        return null;
    }

    @Override
    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.captureSingleRequest(request, this.getExecutor(), listener);
    }

    @Override
    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.captureBurstRequests(requests, this.getExecutor(), listener);
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.setSingleRepeatingRequest(request, this.getExecutor(), listener);
    }

    @Override
    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.setRepeatingBurstRequests(requests, this.getExecutor(), listener);
    }

    @Override
    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.captureSingleRequest(request, executor, listener);
    }

    @Override
    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.captureBurstRequests(requests, executor, listener);
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.setSingleRepeatingRequest(request, executor, listener);
    }

    @Override
    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        return this.mCameraCaptureSessionCompat.setRepeatingBurstRequests(requests, executor, listener);
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        this.mCameraCaptureSessionCompat.toCameraCaptureSession().stopRepeating();
    }

    @Override
    public void abortCaptures() throws CameraAccessException {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        this.mCameraCaptureSessionCompat.toCameraCaptureSession().abortCaptures();
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.mCameraCaptureSessionCompat, (Object)"Need to call openCaptureSession before using this API.");
        this.mCaptureSessionRepository.onCaptureSessionClosing(this);
        this.mCameraCaptureSessionCompat.toCameraCaptureSession().close();
        this.getExecutor().execute(() -> this.onSessionFinished(this));
    }

    @Override
    public void onReady(@NonNull SynchronizedCaptureSession session) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.mCaptureSessionStateCallback.onReady(session);
    }

    @Override
    public void onActive(@NonNull SynchronizedCaptureSession session) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.mCaptureSessionStateCallback.onActive(session);
    }

    @Override
    @RequiresApi(api=26)
    public void onCaptureQueueEmpty(@NonNull SynchronizedCaptureSession session) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.mCaptureSessionStateCallback.onCaptureQueueEmpty(session);
    }

    @Override
    @RequiresApi(api=23)
    public void onSurfacePrepared(@NonNull SynchronizedCaptureSession session, @NonNull Surface surface) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.mCaptureSessionStateCallback.onSurfacePrepared(session, surface);
    }

    @Override
    public void onConfigured(@NonNull SynchronizedCaptureSession session) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.mCaptureSessionRepository.onCaptureSessionCreated(this);
        this.mCaptureSessionStateCallback.onConfigured(session);
    }

    @Override
    public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
        Objects.requireNonNull(this.mCaptureSessionStateCallback);
        this.finishClose();
        this.mCaptureSessionRepository.onCaptureSessionConfigureFail(this);
        this.mCaptureSessionStateCallback.onConfigureFailed(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed(@NonNull SynchronizedCaptureSession session) {
        ListenableFuture<Void> openFuture = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mClosed) {
                this.mClosed = true;
                Preconditions.checkNotNull(this.mOpenCaptureSessionFuture, (Object)"Need to call openCaptureSession before using this API.");
                openFuture = this.mOpenCaptureSessionFuture;
            }
        }
        this.finishClose();
        if (openFuture != null) {
            openFuture.addListener(() -> {
                this.mCaptureSessionRepository.onCaptureSessionClosed(this);
                this.onSessionFinished(session);
                Objects.requireNonNull(this.mCaptureSessionStateCallback);
                this.mCaptureSessionStateCallback.onClosed(session);
            }, CameraXExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
        ListenableFuture<Void> openFuture = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSessionFinished) {
                this.mSessionFinished = true;
                Preconditions.checkNotNull(this.mOpenCaptureSessionFuture, (Object)"Need to call openCaptureSession before using this API.");
                openFuture = this.mOpenCaptureSessionFuture;
            }
        }
        if (openFuture != null) {
            openFuture.addListener(() -> {
                Objects.requireNonNull(this.mCaptureSessionStateCallback);
                this.mCaptureSessionStateCallback.onSessionFinished(session);
            }, CameraXExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void holdDeferrableSurfaces(@NonNull List<DeferrableSurface> deferrableSurfaces) throws DeferrableSurface.SurfaceClosedException {
        Object object = this.mLock;
        synchronized (object) {
            this.releaseDeferrableSurfaces();
            DeferrableSurfaces.incrementAll(deferrableSurfaces);
            this.mHeldDeferrableSurfaces = deferrableSurfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseDeferrableSurfaces() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHeldDeferrableSurfaces != null) {
                DeferrableSurfaces.decrementAll(this.mHeldDeferrableSurfaces);
                this.mHeldDeferrableSurfaces = null;
            }
        }
    }

    @Override
    public void finishClose() {
        this.releaseDeferrableSurfaces();
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static Surface getInputSurface(CameraCaptureSession cameraCaptureSession) {
            return cameraCaptureSession.getInputSurface();
        }
    }
}

