/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExcludedSupportedSizesContainer;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
final class SupportedSurfaceCombination {
    private static final String TAG = "SupportedSurfaceCombination";
    private final List<SurfaceCombination> mSurfaceCombinations = new ArrayList<SurfaceCombination>();
    private final Map<Integer, Size> mMaxSizeCache = new HashMap<Integer, Size>();
    private final String mCameraId;
    private final CamcorderProfileHelper mCamcorderProfileHelper;
    private final CameraCharacteristicsCompat mCharacteristics;
    private final ExcludedSupportedSizesContainer mExcludedSupportedSizesContainer;
    private final ExtraSupportedSurfaceCombinationsContainer mExtraSupportedSurfaceCombinationsContainer;
    private final int mHardwareLevel;
    private final boolean mIsSensorLandscapeResolution;
    private final Map<Integer, List<Size>> mExcludedSizeListCache = new HashMap<Integer, List<Size>>();
    private boolean mIsRawSupported = false;
    private boolean mIsBurstCaptureSupported = false;
    @VisibleForTesting
    SurfaceSizeDefinition mSurfaceSizeDefinition;
    private Map<Integer, Size[]> mOutputSizesCache = new HashMap<Integer, Size[]>();
    @NonNull
    private final DisplayInfoManager mDisplayInfoManager;
    private final ResolutionCorrector mResolutionCorrector = new ResolutionCorrector();

    SupportedSurfaceCombination(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        this.mCameraId = (String)Preconditions.checkNotNull((Object)cameraId);
        this.mCamcorderProfileHelper = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)camcorderProfileHelper);
        this.mExcludedSupportedSizesContainer = new ExcludedSupportedSizesContainer(cameraId);
        this.mExtraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.mDisplayInfoManager = DisplayInfoManager.getInstance(context);
        try {
            this.mCharacteristics = cameraManagerCompat.getCameraCharacteristicsCompat(this.mCameraId);
            Integer keyValue = (Integer)this.mCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            this.mHardwareLevel = keyValue != null ? keyValue : 2;
            this.mIsSensorLandscapeResolution = this.isSensorLandscapeResolution();
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
        int[] availableCapabilities = (int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        if (availableCapabilities != null) {
            for (int capability : availableCapabilities) {
                if (capability == 3) {
                    this.mIsRawSupported = true;
                    continue;
                }
                if (capability != 6) continue;
                this.mIsBurstCaptureSupported = true;
            }
        }
        this.generateSupportedCombinationList();
        this.generateSurfaceSizeDefinition();
        this.checkCustomization();
    }

    String getCameraId() {
        return this.mCameraId;
    }

    boolean isRawSupported() {
        return this.mIsRawSupported;
    }

    boolean isBurstCaptureSupported() {
        return this.mIsBurstCaptureSupported;
    }

    boolean checkSupported(List<SurfaceConfig> surfaceConfigList) {
        SurfaceCombination surfaceCombination;
        boolean isSupported = false;
        Iterator<SurfaceCombination> iterator = this.mSurfaceCombinations.iterator();
        while (iterator.hasNext() && !(isSupported = (surfaceCombination = iterator.next()).isSupported(surfaceConfigList))) {
        }
        return isSupported;
    }

    SurfaceConfig transformSurfaceConfig(int imageFormat, Size size) {
        return SurfaceConfig.transformSurfaceConfig((int)imageFormat, (Size)size, (SurfaceSizeDefinition)this.mSurfaceSizeDefinition);
    }

    @NonNull
    Map<UseCaseConfig<?>, Size> getSuggestedResolutions(@NonNull List<AttachedSurfaceInfo> existingSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs) {
        this.refreshPreviewSize();
        ArrayList<SurfaceConfig> surfaceConfigs = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurfaceInfo : existingSurfaces) {
            surfaceConfigs.add(attachedSurfaceInfo.getSurfaceConfig());
        }
        for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
            surfaceConfigs.add(SurfaceConfig.transformSurfaceConfig((int)useCaseConfig.getInputFormat(), (Size)new Size(640, 480), (SurfaceSizeDefinition)this.mSurfaceSizeDefinition));
        }
        if (!this.checkSupported(surfaceConfigs)) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.mCameraId + ".  May be attempting to bind too many use cases. Existing surfaces: " + existingSurfaces + " New configs: " + newUseCaseConfigs);
        }
        List<Integer> useCasesPriorityOrder = this.getUseCasesPriorityOrder(newUseCaseConfigs);
        ArrayList<List<Size>> arrayList = new ArrayList<List<Size>>();
        for (Integer index : useCasesPriorityOrder) {
            List<Size> supportedOutputSizes = this.getSupportedOutputSizes(newUseCaseConfigs.get(index));
            arrayList.add(supportedOutputSizes);
        }
        List<List<Size>> allPossibleSizeArrangements = this.getAllPossibleSizeArrangements(arrayList);
        HashMap suggestedResolutionsMap = null;
        for (List<Size> possibleSizeList : allPossibleSizeArrangements) {
            ArrayList<SurfaceConfig> surfaceConfigList = new ArrayList<SurfaceConfig>();
            for (AttachedSurfaceInfo sc : existingSurfaces) {
                surfaceConfigList.add(sc.getSurfaceConfig());
            }
            for (int i = 0; i < possibleSizeList.size(); ++i) {
                Size size = possibleSizeList.get(i);
                UseCaseConfig<?> newUseCase = newUseCaseConfigs.get(useCasesPriorityOrder.get(i));
                surfaceConfigList.add(SurfaceConfig.transformSurfaceConfig((int)newUseCase.getInputFormat(), (Size)size, (SurfaceSizeDefinition)this.mSurfaceSizeDefinition));
            }
            if (!this.checkSupported(surfaceConfigList)) continue;
            suggestedResolutionsMap = new HashMap();
            for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigs) {
                suggestedResolutionsMap.put(useCaseConfig, possibleSizeList.get(useCasesPriorityOrder.indexOf(newUseCaseConfigs.indexOf(useCaseConfig))));
            }
        }
        if (suggestedResolutionsMap == null) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.mCameraId + " and Hardware level: " + this.mHardwareLevel + ". May be the specified resolution is too large and not supported. Existing surfaces: " + existingSurfaces + " New configs: " + newUseCaseConfigs);
        }
        return suggestedResolutionsMap;
    }

    private Rational getTargetAspectRatio(@NonNull ImageOutputConfig imageOutputConfig) {
        Rational outputRatio = null;
        int targetAspectRatio = new TargetAspectRatio().get(this.mCameraId, this.mCharacteristics);
        block0 : switch (targetAspectRatio) {
            case 0: {
                outputRatio = this.mIsSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_4_3 : AspectRatioUtil.ASPECT_RATIO_3_4;
                break;
            }
            case 1: {
                outputRatio = this.mIsSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_16_9 : AspectRatioUtil.ASPECT_RATIO_9_16;
                break;
            }
            case 2: {
                Size maxJpegSize = this.fetchMaxSize(256);
                outputRatio = new Rational(maxJpegSize.getWidth(), maxJpegSize.getHeight());
                break;
            }
            case 3: {
                Size targetSize = this.getTargetSize(imageOutputConfig);
                if (imageOutputConfig.hasTargetAspectRatio()) {
                    int aspectRatio = imageOutputConfig.getTargetAspectRatio();
                    switch (aspectRatio) {
                        case 0: {
                            outputRatio = this.mIsSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_4_3 : AspectRatioUtil.ASPECT_RATIO_3_4;
                            break block0;
                        }
                        case 1: {
                            outputRatio = this.mIsSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_16_9 : AspectRatioUtil.ASPECT_RATIO_9_16;
                            break block0;
                        }
                    }
                    Logger.e((String)TAG, (String)("Undefined target aspect ratio: " + aspectRatio));
                    break;
                }
                if (targetSize == null) break;
                outputRatio = new Rational(targetSize.getWidth(), targetSize.getHeight());
                break;
            }
        }
        return outputRatio;
    }

    private Size fetchMaxSize(int imageFormat) {
        Size size = this.mMaxSizeCache.get(imageFormat);
        if (size != null) {
            return size;
        }
        Size maxSize = this.getMaxOutputSizeByFormat(imageFormat);
        this.mMaxSizeCache.put(imageFormat, maxSize);
        return maxSize;
    }

    private List<Integer> getUseCasesPriorityOrder(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList<Integer> priorityOrder = new ArrayList<Integer>();
        ArrayList<Integer> priorityValueList = new ArrayList<Integer>();
        for (UseCaseConfig<?> config : newUseCaseConfigs) {
            int priority = config.getSurfaceOccupancyPriority(0);
            if (priorityValueList.contains(priority)) continue;
            priorityValueList.add(priority);
        }
        Collections.sort(priorityValueList);
        Collections.reverse(priorityValueList);
        Iterator<Object> iterator = priorityValueList.iterator();
        while (iterator.hasNext()) {
            int priorityValue = (Integer)iterator.next();
            for (UseCaseConfig<?> config : newUseCaseConfigs) {
                if (priorityValue != config.getSurfaceOccupancyPriority(0)) continue;
                priorityOrder.add(newUseCaseConfigs.indexOf(config));
            }
        }
        return priorityOrder;
    }

    @NonNull
    @VisibleForTesting
    List<Size> getSupportedOutputSizes(@NonNull UseCaseConfig<?> config) {
        ImageOutputConfig imageOutputConfig;
        int imageFormat = config.getInputFormat();
        Size[] outputSizes = this.getCustomizedSupportSizesFromConfig(imageFormat, imageOutputConfig = (ImageOutputConfig)config);
        if (outputSizes == null) {
            outputSizes = this.getAllOutputSizesByFormat(imageFormat);
        }
        ArrayList<Size> outputSizeCandidates = new ArrayList<Size>();
        Size maxSize = imageOutputConfig.getMaxResolution(null);
        Size maxOutputSizeByFormat = this.getMaxOutputSizeByFormat(imageFormat);
        if (maxSize == null || SizeUtil.getArea((Size)maxOutputSizeByFormat) < SizeUtil.getArea((Size)maxSize)) {
            maxSize = maxOutputSizeByFormat;
        }
        Arrays.sort(outputSizes, new CompareSizesByArea(true));
        Size targetSize = this.getTargetSize(imageOutputConfig);
        Size minSize = SizeUtil.RESOLUTION_VGA;
        int defaultSizeArea = SizeUtil.getArea((Size)SizeUtil.RESOLUTION_VGA);
        int maxSizeArea = SizeUtil.getArea((Size)maxSize);
        if (maxSizeArea < defaultSizeArea) {
            minSize = SizeUtil.RESOLUTION_ZERO;
        } else if (targetSize != null && SizeUtil.getArea((Size)targetSize) < defaultSizeArea) {
            minSize = targetSize;
        }
        for (Size outputSize : outputSizes) {
            if (SizeUtil.getArea((Size)outputSize) > SizeUtil.getArea((Size)maxSize) || SizeUtil.getArea((Size)outputSize) < SizeUtil.getArea((Size)minSize) || outputSizeCandidates.contains(outputSize)) continue;
            outputSizeCandidates.add(outputSize);
        }
        if (outputSizeCandidates.isEmpty()) {
            throw new IllegalArgumentException("Can not get supported output size under supported maximum for the format: " + imageFormat);
        }
        Rational aspectRatio = this.getTargetAspectRatio(imageOutputConfig);
        targetSize = targetSize == null ? imageOutputConfig.getDefaultResolution(null) : targetSize;
        List<Size> supportedResolutions = new ArrayList<Size>();
        Map<Object, Object> aspectRatioSizeListMap = new HashMap();
        if (aspectRatio == null) {
            supportedResolutions.addAll(outputSizeCandidates);
            if (targetSize != null) {
                this.removeSupportedSizesByTargetSize(supportedResolutions, targetSize);
            }
        } else {
            aspectRatioSizeListMap = this.groupSizesByAspectRatio(outputSizeCandidates);
            if (targetSize != null) {
                for (Rational rational : aspectRatioSizeListMap.keySet()) {
                    this.removeSupportedSizesByTargetSize((List)aspectRatioSizeListMap.get(rational), targetSize);
                }
            }
            ArrayList<Object> aspectRatios = new ArrayList<Object>(aspectRatioSizeListMap.keySet());
            Collections.sort(aspectRatios, new AspectRatioUtil.CompareAspectRatiosByDistanceToTargetRatio(aspectRatio));
            for (Rational rational : aspectRatios) {
                for (Size size : (List)aspectRatioSizeListMap.get(rational)) {
                    if (supportedResolutions.contains(size)) continue;
                    supportedResolutions.add(size);
                }
            }
        }
        supportedResolutions = this.mResolutionCorrector.insertOrPrioritize(SurfaceConfig.getConfigType((int)config.getInputFormat()), supportedResolutions);
        return supportedResolutions;
    }

    @Nullable
    private Size getTargetSize(@NonNull ImageOutputConfig imageOutputConfig) {
        int targetRotation = imageOutputConfig.getTargetRotation(0);
        Size targetSize = imageOutputConfig.getTargetResolution(null);
        targetSize = this.flipSizeByRotation(targetSize, targetRotation);
        return targetSize;
    }

    @Nullable
    private Size flipSizeByRotation(@Nullable Size size, int targetRotation) {
        Size outputSize = size;
        if (size != null && this.isRotationNeeded(targetRotation)) {
            outputSize = new Size(size.getHeight(), size.getWidth());
        }
        return outputSize;
    }

    private boolean isRotationNeeded(int targetRotation) {
        Integer sensorOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation, (Object)"Camera HAL in bad state, unable to retrieve the SENSOR_ORIENTATION");
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)targetRotation);
        Integer lensFacing = (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)lensFacing, (Object)"Camera HAL in bad state, unable to retrieve the LENS_FACING");
        boolean isOppositeFacingScreen = 1 == lensFacing;
        int sensorRotationDegrees = CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
        return sensorRotationDegrees == 90 || sensorRotationDegrees == 270;
    }

    private boolean isSensorLandscapeResolution() {
        Size pixelArraySize = (Size)this.mCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
        return pixelArraySize != null ? pixelArraySize.getWidth() >= pixelArraySize.getHeight() : true;
    }

    private Map<Rational, List<Size>> groupSizesByAspectRatio(List<Size> sizes) {
        HashMap<Rational, List<Size>> aspectRatioSizeListMap = new HashMap<Rational, List<Size>>();
        aspectRatioSizeListMap.put(AspectRatioUtil.ASPECT_RATIO_4_3, new ArrayList());
        aspectRatioSizeListMap.put(AspectRatioUtil.ASPECT_RATIO_16_9, new ArrayList());
        for (Size outputSize : sizes) {
            Rational matchedKey = null;
            for (Rational key : aspectRatioSizeListMap.keySet()) {
                List sizeList;
                if (!AspectRatioUtil.hasMatchingAspectRatio((Size)outputSize, (Rational)key) || (sizeList = (List)aspectRatioSizeListMap.get(matchedKey = key)).contains(outputSize)) continue;
                sizeList.add(outputSize);
            }
            if (matchedKey != null) continue;
            aspectRatioSizeListMap.put(new Rational(outputSize.getWidth(), outputSize.getHeight()), new ArrayList<Size>(Collections.singleton(outputSize)));
        }
        return aspectRatioSizeListMap;
    }

    private void removeSupportedSizesByTargetSize(List<Size> supportedSizesList, Size targetSize) {
        Size outputSize;
        if (supportedSizesList == null || supportedSizesList.isEmpty()) {
            return;
        }
        int indexBigEnough = -1;
        ArrayList<Size> removeSizes = new ArrayList<Size>();
        int i = 0;
        while (i < supportedSizesList.size() && (outputSize = supportedSizesList.get(i)).getWidth() >= targetSize.getWidth() && outputSize.getHeight() >= targetSize.getHeight()) {
            if (indexBigEnough >= 0) {
                removeSizes.add(supportedSizesList.get(indexBigEnough));
            }
            indexBigEnough = i++;
        }
        supportedSizesList.removeAll(removeSizes);
    }

    private List<List<Size>> getAllPossibleSizeArrangements(List<List<Size>> supportedOutputSizesList) {
        int totalArrangementsCount = 1;
        for (List<Size> supportedOutputSizes : supportedOutputSizesList) {
            totalArrangementsCount *= supportedOutputSizes.size();
        }
        if (totalArrangementsCount == 0) {
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        ArrayList<List<Size>> allPossibleSizeArrangements = new ArrayList<List<Size>>();
        for (int i = 0; i < totalArrangementsCount; ++i) {
            ArrayList sizeList = new ArrayList();
            allPossibleSizeArrangements.add(sizeList);
        }
        int currentRunCount = totalArrangementsCount;
        int nextRunCount = currentRunCount / supportedOutputSizesList.get(0).size();
        for (int currentIndex = 0; currentIndex < supportedOutputSizesList.size(); ++currentIndex) {
            List<Size> supportedOutputSizes = supportedOutputSizesList.get(currentIndex);
            for (int i = 0; i < totalArrangementsCount; ++i) {
                List surfaceConfigList = (List)allPossibleSizeArrangements.get(i);
                surfaceConfigList.add(supportedOutputSizes.get(i % currentRunCount / nextRunCount));
            }
            if (currentIndex >= supportedOutputSizesList.size() - 1) continue;
            currentRunCount = nextRunCount;
            nextRunCount = currentRunCount / supportedOutputSizesList.get(currentIndex + 1).size();
        }
        return allPossibleSizeArrangements;
    }

    @NonNull
    private Size[] excludeProblematicSizes(@NonNull Size[] outputSizes, int imageFormat) {
        List<Size> excludedSizes = this.fetchExcludedSizes(imageFormat);
        ArrayList<Size> resultSizesList = new ArrayList<Size>(Arrays.asList(outputSizes));
        resultSizesList.removeAll(excludedSizes);
        return resultSizesList.toArray(new Size[0]);
    }

    @Nullable
    private Size[] getCustomizedSupportSizesFromConfig(int imageFormat, @NonNull ImageOutputConfig config) {
        Size[] outputSizes = null;
        List formatResolutionsPairList = config.getSupportedResolutions(null);
        if (formatResolutionsPairList != null) {
            for (Pair formatResolutionPair : formatResolutionsPairList) {
                if ((Integer)formatResolutionPair.first != imageFormat) continue;
                outputSizes = (Size[])formatResolutionPair.second;
                break;
            }
        }
        if (outputSizes != null) {
            outputSizes = this.excludeProblematicSizes(outputSizes, imageFormat);
            Arrays.sort(outputSizes, new CompareSizesByArea(true));
        }
        return outputSizes;
    }

    @NonNull
    private Size[] getAllOutputSizesByFormat(int imageFormat) {
        Size[] outputs = this.mOutputSizesCache.get(imageFormat);
        if (outputs == null) {
            outputs = this.doGetAllOutputSizesByFormat(imageFormat);
            this.mOutputSizesCache.put(imageFormat, outputs);
        }
        return outputs;
    }

    @NonNull
    private Size[] doGetAllOutputSizesByFormat(int imageFormat) {
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            throw new IllegalArgumentException("Can not retrieve SCALER_STREAM_CONFIGURATION_MAP");
        }
        Size[] outputSizes = Build.VERSION.SDK_INT < 23 && imageFormat == 34 ? map.getOutputSizes(SurfaceTexture.class) : map.getOutputSizes(imageFormat);
        if (outputSizes == null) {
            throw new IllegalArgumentException("Can not get supported output size for the format: " + imageFormat);
        }
        outputSizes = this.excludeProblematicSizes(outputSizes, imageFormat);
        Arrays.sort(outputSizes, new CompareSizesByArea(true));
        return outputSizes;
    }

    Size getMaxOutputSizeByFormat(int imageFormat) {
        Size[] outputSizes = this.getAllOutputSizesByFormat(imageFormat);
        return Collections.max(Arrays.asList(outputSizes), new CompareSizesByArea());
    }

    private void generateSupportedCombinationList() {
        this.mSurfaceCombinations.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList(this.mHardwareLevel, this.mIsRawSupported, this.mIsBurstCaptureSupported));
        this.mSurfaceCombinations.addAll(this.mExtraSupportedSurfaceCombinationsContainer.get(this.mCameraId, this.mHardwareLevel));
    }

    private void checkCustomization() {
    }

    private void generateSurfaceSizeDefinition() {
        Size analysisSize = new Size(640, 480);
        Size previewSize = this.mDisplayInfoManager.getPreviewSize();
        Size recordSize = this.getRecordSize();
        this.mSurfaceSizeDefinition = SurfaceSizeDefinition.create((Size)analysisSize, (Size)previewSize, (Size)recordSize);
    }

    private void refreshPreviewSize() {
        this.mDisplayInfoManager.refresh();
        if (this.mSurfaceSizeDefinition == null) {
            this.generateSurfaceSizeDefinition();
        } else {
            Size previewSize = this.mDisplayInfoManager.getPreviewSize();
            this.mSurfaceSizeDefinition = SurfaceSizeDefinition.create((Size)this.mSurfaceSizeDefinition.getAnalysisSize(), (Size)previewSize, (Size)this.mSurfaceSizeDefinition.getRecordSize());
        }
    }

    @NonNull
    private Size getRecordSize() {
        int cameraId;
        try {
            cameraId = Integer.parseInt(this.mCameraId);
        }
        catch (NumberFormatException e) {
            return this.getRecordSizeFromStreamConfigurationMap();
        }
        CamcorderProfile profile = null;
        if (this.mCamcorderProfileHelper.hasProfile(cameraId, 1)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 1);
        }
        if (profile != null) {
            return new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        }
        return this.getRecordSizeByHasProfile(cameraId);
    }

    @NonNull
    private Size getRecordSizeFromStreamConfigurationMap() {
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            throw new IllegalArgumentException("Can not retrieve SCALER_STREAM_CONFIGURATION_MAP");
        }
        Size[] videoSizeArr = map.getOutputSizes(MediaRecorder.class);
        if (videoSizeArr == null) {
            return SizeUtil.RESOLUTION_480P;
        }
        Arrays.sort(videoSizeArr, new CompareSizesByArea(true));
        for (Size size : videoSizeArr) {
            if (size.getWidth() > SizeUtil.RESOLUTION_1080P.getWidth() || size.getHeight() > SizeUtil.RESOLUTION_1080P.getHeight()) continue;
            return size;
        }
        return SizeUtil.RESOLUTION_480P;
    }

    @NonNull
    private Size getRecordSizeByHasProfile(int cameraId) {
        Size recordSize = SizeUtil.RESOLUTION_480P;
        CamcorderProfile profile = null;
        if (this.mCamcorderProfileHelper.hasProfile(cameraId, 10)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 10);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 8)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 8);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 12)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 12);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 6)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 6);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 5)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 5);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 4)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 4);
        }
        if (profile != null) {
            recordSize = new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        }
        return recordSize;
    }

    @NonNull
    private List<Size> fetchExcludedSizes(int imageFormat) {
        List<Size> excludedSizes = this.mExcludedSizeListCache.get(imageFormat);
        if (excludedSizes == null) {
            excludedSizes = this.mExcludedSupportedSizesContainer.get(imageFormat);
            this.mExcludedSizeListCache.put(imageFormat, excludedSizes);
        }
        return excludedSizes;
    }
}

