/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.StillCaptureFlashStopRepeatingQuirk;
import java.util.List;

@RequiresApi(value=21)
public class StillCaptureFlow {
    private final boolean mShouldStopRepeatingBeforeStillCapture;

    public StillCaptureFlow() {
        StillCaptureFlashStopRepeatingQuirk quirk = DeviceQuirks.get(StillCaptureFlashStopRepeatingQuirk.class);
        this.mShouldStopRepeatingBeforeStillCapture = quirk != null;
    }

    public boolean shouldStopRepeatingBeforeCapture(@NonNull List<CaptureRequest> captureRequests, boolean isStillCapture) {
        if (!this.mShouldStopRepeatingBeforeStillCapture || !isStillCapture) {
            return false;
        }
        for (CaptureRequest request : captureRequests) {
            int aeMode = (Integer)request.get(CaptureRequest.CONTROL_AE_MODE);
            if (aeMode != 2 && aeMode != 3) continue;
            return true;
        }
        return false;
    }
}

