/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.params.OutputConfiguration;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatBaseImpl;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@RequiresApi(value=24)
class OutputConfigurationCompatApi24Impl
extends OutputConfigurationCompatBaseImpl {
    OutputConfigurationCompatApi24Impl(@NonNull Surface surface) {
        this(new OutputConfigurationParamsApi24(new OutputConfiguration(surface)));
    }

    OutputConfigurationCompatApi24Impl(@NonNull Object outputConfiguration) {
        super(outputConfiguration);
    }

    @RequiresApi(value=24)
    static OutputConfigurationCompatApi24Impl wrap(@NonNull OutputConfiguration outputConfiguration) {
        return new OutputConfigurationCompatApi24Impl(new OutputConfigurationParamsApi24(outputConfiguration));
    }

    @Override
    public void enableSurfaceSharing() {
        ((OutputConfigurationParamsApi24)this.mObject).mIsShared = true;
    }

    @Override
    boolean isSurfaceSharingEnabled() {
        return ((OutputConfigurationParamsApi24)this.mObject).mIsShared;
    }

    @Override
    public void setPhysicalCameraId(@Nullable String physicalCameraId) {
        ((OutputConfigurationParamsApi24)this.mObject).mPhysicalCameraId = physicalCameraId;
    }

    @Override
    @Nullable
    public String getPhysicalCameraId() {
        return ((OutputConfigurationParamsApi24)this.mObject).mPhysicalCameraId;
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return ((OutputConfiguration)this.getOutputConfiguration()).getSurface();
    }

    @Override
    @NonNull
    public List<Surface> getSurfaces() {
        return Collections.singletonList(this.getSurface());
    }

    @Override
    public int getSurfaceGroupId() {
        return ((OutputConfiguration)this.getOutputConfiguration()).getSurfaceGroupId();
    }

    @Override
    public Object getOutputConfiguration() {
        Preconditions.checkArgument((boolean)(this.mObject instanceof OutputConfigurationParamsApi24));
        return ((OutputConfigurationParamsApi24)this.mObject).mOutputConfiguration;
    }

    @RequiresApi(value=21)
    private static final class OutputConfigurationParamsApi24 {
        final OutputConfiguration mOutputConfiguration;
        @Nullable
        String mPhysicalCameraId;
        boolean mIsShared;

        OutputConfigurationParamsApi24(@NonNull OutputConfiguration configuration) {
            this.mOutputConfiguration = configuration;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutputConfigurationParamsApi24)) {
                return false;
            }
            OutputConfigurationParamsApi24 otherOutputConfig = (OutputConfigurationParamsApi24)obj;
            return Objects.equals(this.mOutputConfiguration, otherOutputConfig.mOutputConfiguration) && this.mIsShared == otherOutputConfig.mIsShared && Objects.equals(this.mPhysicalCameraId, otherOutputConfig.mPhysicalCameraId);
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mOutputConfiguration.hashCode();
            h = (h << 5) - h ^ (this.mIsShared ? 1 : 0);
            h = (h << 5) - h ^ (this.mPhysicalCameraId == null ? 0 : this.mPhysicalCameraId.hashCode());
            return h;
        }
    }
}

