/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.annotation.SuppressLint;
import android.hardware.camera2.params.InputConfiguration;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.util.Objects;

@RequiresApi(value=21)
public final class InputConfigurationCompat {
    private final InputConfigurationCompatImpl mImpl;

    public InputConfigurationCompat(int width, int height, int format) {
        this.mImpl = Build.VERSION.SDK_INT >= 31 ? new InputConfigurationCompatApi31Impl(width, height, format) : (Build.VERSION.SDK_INT >= 23 ? new InputConfigurationCompatApi23Impl(width, height, format) : new InputConfigurationCompatBaseImpl(width, height, format));
    }

    private InputConfigurationCompat(@NonNull InputConfigurationCompatImpl impl) {
        this.mImpl = impl;
    }

    @Nullable
    public static InputConfigurationCompat wrap(@Nullable Object inputConfiguration) {
        if (inputConfiguration == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            return new InputConfigurationCompat(new InputConfigurationCompatApi31Impl(inputConfiguration));
        }
        return new InputConfigurationCompat(new InputConfigurationCompatApi23Impl(inputConfiguration));
    }

    public int getWidth() {
        return this.mImpl.getWidth();
    }

    public int getHeight() {
        return this.mImpl.getHeight();
    }

    public int getFormat() {
        return this.mImpl.getFormat();
    }

    public boolean isMultiResolution() {
        return this.mImpl.isMultiResolution();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputConfigurationCompat)) {
            return false;
        }
        return this.mImpl.equals(((InputConfigurationCompat)obj).mImpl);
    }

    public int hashCode() {
        return this.mImpl.hashCode();
    }

    @NonNull
    public String toString() {
        return this.mImpl.toString();
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getInputConfiguration();
    }

    @RequiresApi(value=31)
    private static final class InputConfigurationCompatApi31Impl
    extends InputConfigurationCompatApi23Impl {
        InputConfigurationCompatApi31Impl(@NonNull Object inputConfiguration) {
            super(inputConfiguration);
        }

        InputConfigurationCompatApi31Impl(int width, int height, int format) {
            super(width, height, format);
        }

        @Override
        public boolean isMultiResolution() {
            return ((InputConfiguration)this.getInputConfiguration()).isMultiResolution();
        }
    }

    @RequiresApi(value=23)
    private static class InputConfigurationCompatApi23Impl
    implements InputConfigurationCompatImpl {
        private final InputConfiguration mObject;

        InputConfigurationCompatApi23Impl(@NonNull Object inputConfiguration) {
            this.mObject = (InputConfiguration)inputConfiguration;
        }

        InputConfigurationCompatApi23Impl(int width, int height, int format) {
            this(new InputConfiguration(width, height, format));
        }

        @Override
        public int getWidth() {
            return this.mObject.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mObject.getHeight();
        }

        @Override
        public int getFormat() {
            return this.mObject.getFormat();
        }

        @Override
        public boolean isMultiResolution() {
            return false;
        }

        @Override
        @Nullable
        public Object getInputConfiguration() {
            return this.mObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InputConfigurationCompatImpl)) {
                return false;
            }
            return Objects.equals(this.mObject, ((InputConfigurationCompatImpl)obj).getInputConfiguration());
        }

        public int hashCode() {
            return this.mObject.hashCode();
        }

        @NonNull
        public String toString() {
            return this.mObject.toString();
        }
    }

    @VisibleForTesting
    static final class InputConfigurationCompatBaseImpl
    implements InputConfigurationCompatImpl {
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;

        InputConfigurationCompatBaseImpl(int width, int height, int format) {
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
        }

        @Override
        public int getWidth() {
            return this.mWidth;
        }

        @Override
        public int getHeight() {
            return this.mHeight;
        }

        @Override
        public int getFormat() {
            return this.mFormat;
        }

        @Override
        public boolean isMultiResolution() {
            return false;
        }

        @Override
        public Object getInputConfiguration() {
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InputConfigurationCompatBaseImpl)) {
                return false;
            }
            InputConfigurationCompatBaseImpl otherInputConfig = (InputConfigurationCompatBaseImpl)obj;
            return otherInputConfig.getWidth() == this.mWidth && otherInputConfig.getHeight() == this.mHeight && otherInputConfig.getFormat() == this.mFormat;
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mWidth;
            h = (h << 5) - h ^ this.mHeight;
            h = (h << 5) - h ^ this.mFormat;
            return h;
        }

        @NonNull
        @SuppressLint(value={"DefaultLocale"})
        public String toString() {
            return String.format("InputConfiguration(w:%d, h:%d, format:%d)", this.mWidth, this.mHeight, this.mFormat);
        }
    }

    private static interface InputConfigurationCompatImpl {
        public int getWidth();

        public int getHeight();

        public int getFormat();

        public boolean isMultiResolution();

        @Nullable
        public Object getInputConfiguration();
    }
}

