/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionBaseImpl;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionImpl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseCaptureSession;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseDeferrableSurface;
import androidx.camera.camera2.internal.compat.workaround.WaitForRepeatingRequestStart;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RequiresApi(value=21)
final class SynchronizedCaptureSessionOpener {
    @NonNull
    private final OpenerImpl mImpl;

    SynchronizedCaptureSessionOpener(@NonNull OpenerImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat, @NonNull List<DeferrableSurface> deferrableSurfaces) {
        return this.mImpl.openCaptureSession(cameraDevice, sessionConfigurationCompat, deferrableSurfaces);
    }

    @NonNull
    SessionConfigurationCompat createSessionConfigurationCompat(int sessionType, @NonNull List<OutputConfigurationCompat> outputsCompat, @NonNull SynchronizedCaptureSession.StateCallback stateCallback) {
        return this.mImpl.createSessionConfigurationCompat(sessionType, outputsCompat, stateCallback);
    }

    @NonNull
    ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        return this.mImpl.startWithDeferrableSurface(deferrableSurfaces, timeout);
    }

    boolean stop() {
        return this.mImpl.stop();
    }

    @NonNull
    public Executor getExecutor() {
        return this.mImpl.getExecutor();
    }

    static interface OpenerImpl {
        @NonNull
        public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice var1, @NonNull SessionConfigurationCompat var2, @NonNull List<DeferrableSurface> var3);

        @NonNull
        public SessionConfigurationCompat createSessionConfigurationCompat(int var1, @NonNull List<OutputConfigurationCompat> var2, @NonNull SynchronizedCaptureSession.StateCallback var3);

        @NonNull
        public Executor getExecutor();

        @NonNull
        public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> var1, long var2);

        public boolean stop();
    }

    static class Builder {
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduledExecutorService;
        private final Handler mCompatHandler;
        private final CaptureSessionRepository mCaptureSessionRepository;
        private final Quirks mCameraQuirks;
        private final Quirks mDeviceQuirks;
        private final boolean mQuirkExist;

        Builder(@NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler, @NonNull CaptureSessionRepository captureSessionRepository, @NonNull Quirks cameraQuirks, @NonNull Quirks deviceQuirks) {
            this.mExecutor = executor;
            this.mScheduledExecutorService = scheduledExecutorService;
            this.mCompatHandler = compatHandler;
            this.mCaptureSessionRepository = captureSessionRepository;
            this.mCameraQuirks = cameraQuirks;
            this.mDeviceQuirks = deviceQuirks;
            this.mQuirkExist = new ForceCloseDeferrableSurface(this.mCameraQuirks, this.mDeviceQuirks).shouldForceClose() || new WaitForRepeatingRequestStart(this.mCameraQuirks).shouldWaitRepeatingSubmit() || new ForceCloseCaptureSession(this.mDeviceQuirks).shouldForceClose();
        }

        @NonNull
        SynchronizedCaptureSessionOpener build() {
            return new SynchronizedCaptureSessionOpener(this.mQuirkExist ? new SynchronizedCaptureSessionImpl(this.mCameraQuirks, this.mDeviceQuirks, this.mCaptureSessionRepository, this.mExecutor, this.mScheduledExecutorService, this.mCompatHandler) : new SynchronizedCaptureSessionBaseImpl(this.mCaptureSessionRepository, this.mExecutor, this.mScheduledExecutorService, this.mCompatHandler));
        }
    }
}

