/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public interface SynchronizedCaptureSession {
    @NonNull
    public CameraDevice getDevice();

    @NonNull
    public StateCallback getStateCallback();

    @Nullable
    public Surface getInputSurface();

    @NonNull
    public ListenableFuture<Void> getOpeningBlocker();

    @NonNull
    public CameraCaptureSessionCompat toCameraCaptureSessionCompat();

    public int captureSingleRequest(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int captureSingleRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public void stopRepeating() throws CameraAccessException;

    public void abortCaptures() throws CameraAccessException;

    public void close();

    public void finishClose();

    public static abstract class StateCallback {
        void onReady(@NonNull SynchronizedCaptureSession session) {
        }

        void onActive(@NonNull SynchronizedCaptureSession session) {
        }

        @RequiresApi(api=26)
        void onCaptureQueueEmpty(@NonNull SynchronizedCaptureSession session) {
        }

        @RequiresApi(api=23)
        void onSurfacePrepared(@NonNull SynchronizedCaptureSession session, @NonNull Surface surface) {
        }

        void onConfigured(@NonNull SynchronizedCaptureSession session) {
        }

        public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
        }

        public void onClosed(@NonNull SynchronizedCaptureSession session) {
        }

        void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
        }
    }
}

